// *******************************************************************
//
// RMTEXEC 1.00, Copyright (c) 1994, Bob Flanders and Michael Holmes
// Network Administrator, Run programs at another NetWare workstation
//
// *******************************************************************
//
// Compile RMTEXEC using the following vendor specific commands.
//
//    Borland C++ version 3.x and 4.0
//      BCC -O2 -mt rmtexec.cpp
//
// *******************************************************************

#include <stdio.h>                          // standard i/o library
#include <stdlib.h>                         // commonly used routines
#include <dos.h>                            // DOS rtn definitions
#include <string.h>                         // string functions
#include <conio.h>                          // console i/o functions
#include <io.h>                             // file i/o functions
#pragma  pack(1)                            // pack to byte alignment

#define NOT !                               // logical not
#define UINT unsigned                       // unsigned integer
#define SWAP(x) ((x >> 8) | (x << 8))       // byte swapping
#define SET(x,y) memset(x, y, sizeof(x))    // memset an area
#define LENGTHOF(x) sizeof(x) - sizeof(int) // control block length
#define DATE(x) x.month, x.day, x.year      // date fields
#define TIME(x) x.hour, x.minute, x.second  // time fields
#define TICKS_DAY 1573040L                  // number of ticks per day
#define SO_WORK     "RMTEXEC.$$$"           // temporary stdout file

#define WAIT      91                        // 91 ticks (5 sec) wait
#define S_WAIT    20                        // 20 ticks (1+ sec) wait
#define IPXINT    0x7a                      // IPX interrupt number

                                            // IPX functions
#define IPX_OPEN        0                   //   open a socket
#define IPX_CLOSE       1                   //   close a socket
#define IPX_GET_TARGET  2                   //   get local target fnc
#define IPX_SEND        3                   //   send function
#define IPX_LISTEN      4                   //   listen for message
#define IPX_CANCEL      6                   //   cancel event

#define IPX_CHECK       0x7a00              // check for IPX available

#define CONN_SERVICE    0xe3                // connection service
#define CONN_GET_NAME   0x16                // get connection info fnc
#define CONN_GET_NBR    0xdc00              // get connection number

#define MSG_BROADCAST   0xe1                // broadcast a message


#if defined(__TURBOC__) || defined(__BORLANDC__)    // BC++ 3.1
#define  _BC_VER                            // Borland compiler
#define BREAK_ARGS  ...                     // interrupt rtn args
#endif



// *******************************************************************
//
//  globals
//
// *******************************************************************

int     rc = 1,                             // errorlevel return code
        ctrl_break,                         // control break flag
        station,                            // network connection nbr
        socket = 0x40BF,                    // base socket number
        wait_val = S_WAIT,                  // short wait value
        errors;                             // error count

UINT    cmds_received;                      // server mode cmds rec'd

char    sw_server,                          // server mode switch
        sw_wait,                            // wait switch
        block = 219,                        // one block character
        blocks[80],                         // ..and a line of blocks
        cmd_line[128],                      // target command line
        line[100],                          // stdout file buffer
        userid[55];                         // username and connection

extern
UINT    _heaplen = 1024;                    // specify very small heap

struct  SREGS   s;                          // segment registers
union   REGS    r;                          // ..and other registers



// *******************************************************************
//
//  structures
//
//
// *******************************************************************

struct conn_packet                      // connection request packet
    {
    int  c_len;                             // packet length
    char c_fnc;                             // function code
    char c_station;                         // station number
    } conn_pkt;

struct name_packet                      // logon name reply packet
    {
    int  n_len;                             // packet length
    long n_uid;                             // unique id
    int  n_type;                            // type
    char n_name[48],                        // login name
         n_log[8];                          // log time
    } name_pkt;

struct bc_packet                        // broadcast msg packet
    {
    int  b_len;                             // packet length
    char b_fnc,                             // function code
         b_cnt,                             // station count
         b_station,                         // station number
         b_mlen,                            // message length
         b_msg[128];                        // message text
    } bc_pkt;

struct bcr_packet                       // broadcast reply packet
    {
    int  r_len;                             // packet length
    char r_cnt,                             // station count
         r_status;                          // completion status
    } bcr_pkt;

struct ecb_block                        // event control block
    {
    long e_link;                            // network link field
    char far *e_esr;                        // ESR address
    char e_use,                             // in use flag
         e_code;                            // completion code
    int  e_socket;                          // socket number
    long e_iwrk;                            // IPX work space
    char e_dwrk[12],                        // driver work space
         e_iaddr[6];                        // immediate address
    int  e_fragcnt;                         // fragment count
    char far *e_fragaddr;                   // fragment address
    int  e_fragsize;                        // fragment size
    };

struct ipx_header                       // IPX Header
    {
    int  i_chks,                            // checksum
         i_len;                             // length
    char i_tc,                              // transport control
         i_packet;                          // packet type
    long i_dnet;                            // destination network
    char i_dnode[6];                        // ..node
    int  i_dsocket;                         // ..socket nbr
    long i_snet;                            // source network
    char i_snode[6];                        // ..node
    int  i_ssocket;                         // ..socket nbr
    };

struct message                          // user message buffers
    {
    int  m_len;                             // message length
    char m_type,                            // message type
         m_wflag,                           // client waiting flag
         m_station,                         // station number
         m_name[48],                        // login name
         m_msg[128];                        // area for command
    int  m_sequence;                        // job sequence number
    };

struct message_buffer                   // IPX message blocks
    {
    struct ecb_block  ecb;                  // event control block
    struct ipx_header ipx;                  // IPX header
    struct message    msg;                  // user data
    } msg_buffer[3];                        // message buffer/packet

typedef message_buffer MB;                  // shorthand notation
#define FRAGSIZE (sizeof(SEND.ipx) + sizeof(SEND.msg))  // fragment sz
#define LISTEN (msg_buffer[0])              // receiving buffer
#define SEND   (msg_buffer[1])              // sending buffer
#define REPLY  (msg_buffer[2])              // ack reply buffer

                                        // message types (m_type)
#define MT_COMMAND  0                       // execute command
#define MT_EXECUTE  1                       // command executing
#define MT_RESPONSE 2                       // execution response
#define MT_ACK      3                       // response ack
#define MT_DONE     4                       // finished responses

#define SEND_SOCKET   socket + (sw_server ? 1 : 0)  // socket numbers
#define LISTEN_SOCKET socket + (sw_server ? 0 : 1)  // for send & recv



// *******************************************************************
//
//  messages and strings
//
// *******************************************************************

char    copyright[]    = "RMTEXEC 1.00 \xfe Copyright (c) 1994, "
                         "Bob Flanders and Michael Holmes\n"
                         "Network Administrator \xfe Run programs "
                         "at another Netware workstation\n\n",
        stop_here[]    = "\nReturning to DOS...\n",
        no_network[]   = "Network software is not loaded\n",
        in_use[]       = "Network socket already in use\n",
        sending[]      = "Sending to RMTEXEC server: %s  ",
        started_job[]  = "\nJob %u started by RMTEXEC server\n",
        client_gone[]  = "Client not responding\n",
        one_dot[]      = ".",
        unknown[]      = " Unknown ",
        job_done[]     = "RMTEXEC completed job %u: %s",
        running[]      = "\n%79.79s\n"
                         "%c    User: %-50.50sJob: %-12u%c\n"
                         "%c Command: %-67.67s%c\n"
                         "%c Started: %02d/%02d/%d %02d:%02d:%02d    ",
        not_eoj[]      = "%44.44s%c\n%79.79s\n\n",
        end_of_job[]   = " Finished: %02d:%02d:%02d    "
                         "Elapsed: %2d:%02d:%02d.%02d %c\n"
                         "%79.79s\n",
        waiting[]      = "RMTEXEC is in server mode.  Ctrl-Break to "
                         "stop.\n",
        totals[]       = "RMTEXEC terminating, %d commands processed."
                         "\n",
        help[]         =
            "  Usage: RMTEXEC  /S\n"
            "         RMTEXEC  [/W]  cmd_line\n\n"
            "Options: /S       places RMTEXEC in server mode\n"
            "         /W       wait for screen output\n"
            "         cmd_line command line to be executed on the "
            "RMTEXEC server\n";



// *******************************************************************
//
//  listen_buffer() -- prepare a buffer to receive a message
//
//  This routine prepares our listen buffer to receive a message.  The
//  listen buffer contains the event control block (ECB).  This block
//  contains the socket number and the address and length of the user
//  data area.  After a sucessful receive, the user data area will
//  contain the message from the other RMTEXEC system.
//
// *******************************************************************

void    listen_buffer(MB   *mb)             // message buffer
{

mb->ecb.e_use = 1;                          // preset to not in-use
mb->ecb.e_socket =                          // ..ECB socket,
    mb->ipx.i_dsocket =                     // ..destination and
    mb->ipx.i_ssocket = LISTEN_SOCKET;      // ..source socket numbers
mb->ecb.e_fragcnt = 1;                      // ..fragment count
mb->ecb.e_fragsize = FRAGSIZE;              // ..fragment size
mb->ecb.e_fragaddr = (char far *) &mb->ipx; // ..userdata area

r.x.bx = IPX_LISTEN;                        // bx = listen function
r.x.si = (UINT) mb;                         // si -> ECB
s.es = FP_SEG(mb);                          // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // listen a buffer

}



// *******************************************************************
//
//  quit_with() -- give an error message, then return to DOS
//
// *******************************************************************

void    quit_with(char *msg)
{

printf(msg);                                // give error message
exit(rc);                                   // ..and then quit

}



// *******************************************************************
//
//  get_username() -- get connection number and username
//
//  This routine checks for the existance of NetWare and NetWare Lite.
//  If a NetWare shell is loaded, the connection number and username
//  are retrieved and stored for later use.
//
// *******************************************************************

void    get_username()
{

r.x.ax = IPX_CHECK;                         // ax = IPX loaded check
int86x(0x2f, &r, &r, &s);                   // issue multiplex int

if (r.h.al != 0xff)                         // q. network loaded?
    quit_with(no_network);                  // a. no .. give err/quit

r.x.ax = CONN_GET_NBR;                      // ah = get station number
int86x(0x21, &r, &r, &s);                   // get station number

if ((station = r.h.al) != 0)                // q. net shell loaded?
    {                                       // a. yes .. get username
    conn_pkt.c_len = LENGTHOF(conn_pkt);    // request packet length
    conn_pkt.c_fnc = CONN_GET_NAME;         // get connection name..
    conn_pkt.c_station = station;           // ..for our connection
    name_pkt.n_len = LENGTHOF(name_pkt);    // reply packet length
    s.es = s.ds = FP_SEG(&name_pkt);        // set up segment regs
    r.x.si = (int) &conn_pkt;               // request packet address
    r.x.di = (int) &name_pkt;               // reply packet address
    r.h.ah = CONN_SERVICE;                  // use connection services
    int86x(0x21, &r, &r, &s);               // get this station's name
    }
}



// *******************************************************************
//
//  open_sockets() -- establish network sockets
//
//  This routine opens the network sockets for later use and prepares
//  the receive buffer for receipt of a message.
//
// *******************************************************************

void    open_sockets(void)
{
int     i;                                  // loop control


get_username();                             // get net information

for (i = 0; i < 2; i++)                     // loop opening sockets
    {
    r.x.bx = IPX_OPEN;                      // bx = open socket fnc
    r.h.al = 0;                             // al = open till eoj
    r.x.dx = socket + i;                    // dx = socket number
    int86x(IPXINT, &r, &r, &s);             // open the socket

    if (r.h.al)                             // q. open socket ok?
        quit_with(in_use);                  // a. no .. give err/quit
    }

listen_buffer(&LISTEN);                     // prepare to receive msg

}



// *******************************************************************
//
//  close_socket() -- close network sockets
//
//  This routine closes the network sockets and cancels any
//  outstanding event control blocks.
//
// *******************************************************************

void    close_sockets()
{
int     i;                                  // loop control

r.x.bx = IPX_CANCEL;                        // bx = cancel event fnc
r.x.si = (unsigned) &SEND;                  // si -> sending ECB
s.es = FP_SEG(&SEND);                       // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // cancel send function

r.x.bx = IPX_CANCEL;                        // bx = cancel event fnc
r.x.si = (unsigned) &LISTEN;                // si -> listening ECBs
int86x(IPXINT, &r, &r, &s);                 // cancel send function

r.x.bx = IPX_CANCEL;                        // bx = cancel event fnc
r.x.si = (unsigned) &REPLY;                 // si -> reply ECBs
int86x(IPXINT, &r, &r, &s);                 // cancel send function

for (i = 0; i < 2; i++)                     // loop, closing sockets
    {
    r.x.bx = IPX_CLOSE;                     // bx = close socket fnc
    r.x.dx = socket + i;                    // dx = socket number
    int86(IPXINT, &r, &r);                  // close the socket
    }

}



// *******************************************************************
//
//  break_rtn() -- control break interrupt routine
//
//  This routine handles the control break and control C interrupts.
//  When executed, this routine sets the global ctrl_break flag.
//
// *******************************************************************

void interrupt far break_rtn(BREAK_ARGS)
{

ctrl_break = 1;                             // set ^c/^break flag

}



// *******************************************************************
//
//  key_hit() -- handle key hits and control breaks
//
//  This routine process spurious keyboard characters by discarding
//  them.  If the global ctrl_break flag has been set, this routine
//  closes the network sockets, prints a summary line, and terminates
//  the program.
//
// *******************************************************************

void    key_hit(void)
{

if (kbhit())                                // q. user hit a key?
    getch();                                // a. yes .. discard key

if (ctrl_break)                             // q. ^break pressed?
    {                                       // a. yes .. shut down
    close_sockets();                        // close any open sockets

    if (sw_server)                          // q. server mode?
        printf(totals, cmds_received);      // a. yes .. print totals

    quit_with(stop_here);                   // a. yes .. give stop msg
    }

}



// *******************************************************************
//
//  wait_til() -- wait for timeout or event completion
//
//  This routine handles timeouts for events.  This routine returns
//  when either the timeout period has completed or the monitored
//  event completes.
//
// *******************************************************************

int     wait_til(UINT count,                // countdown tick counter
                 char *flag)                // event complete flag
{
long    far *timer = (long far *)           // BIOS timer tick counter
                MK_FP(0x40, 0x6c),          // ..address in low memory
        work;                               // current tick value


key_hit();                                  // check keyboard
work = *timer;                              // get current time

while (count && *flag)                      // loop 'til out of time
    {                                       // ..or operation finishes
    if (work != *timer)                     // q. a tick pass?
        {
        work = *timer;                      // a. yes .. save new time
        count--;                            // ..and decrement t/o cnt
        }

    key_hit();                              // handle spurious keys
    }

return(*flag);                              // rtn with status flag

}



// *******************************************************************
//
//  check_arguments() -- check command line arguments
//
//  This routine processes the commmand line switches.  If a client
//  mode request is received, this routine will build an appropriate
//  command buffer which can be passed to the system() function.
//
// *******************************************************************

void    check_arguments(int  ac,            // DOS cmd line token cnt
                        char *av[])         // ..token strings
{
int     i = 1;                              // loop control
char    *p;                                 // string pointer


s.ds = s.es = s.cs = s.ss = FP_SEG(&rc);    // set up default segments
memset(blocks, block, 79);                  // ..and graphics chars

if (NOT strcmp(av[1], "/?"))                // q. user needs help?
    quit_with(help);                        // a. yes .. give help

if (NOT stricmp(av[1], "/S"))               // q. run in server mode?
    {
    sw_server = 1;                          // a. yes .. set flag

    if (ac != 2)                            // q. any other arguments?
        quit_with(help);                    // a. yes .. give help

    return;                                 // ..and return to caller
    }

if (NOT stricmp(av[i], "/W"))               // q. run with wait?
    {
    sw_wait = 1;                            // a. yes .. set flag
    i++;                                    // set up for next arg
    }

if (ac <= i)                                // q. missing pgm name?
    quit_with(help);                        // a. yes .. give help

for (; i < ac; i++)                         // for each argument
    {
    if (strchr(av[i], ' '))                 // q. token contain space?
        {
        p = (char *) malloc(                // a. yes .. get some more
                strlen(av[i]) + 3);         // ..space for new string
        sprintf(p, "\"%s\"", av[i]);        // surround with quotes
        av[i] = p;                          // ..and store new address
        }

    if (strlen(cmd_line))                   // q. 1st item on line?
        strcat(cmd_line, " ");              // a. no .. put in a space

    strcat(cmd_line, av[i]);                // ..then add the argument
    }

}



// *******************************************************************
//
//  broadcast_msg() -- broadcast completion message to user
//
//  This routine sends the requestor a confirmation message.  This
//  routine uses the network shell's send a broadcast message to
//  alert the client that the remote job has finished.
//
// *******************************************************************

void    broadcast_msg(void)
{

if (station)                                // q. running shell?
    {                                       // a. yes .. send done msg
    bc_pkt.b_len = LENGTHOF(bc_pkt);        // request packet length
    bc_pkt.b_fnc = 0;                       // send a broadcast msg
    bc_pkt.b_cnt = 1;                       // station count
    bc_pkt.b_station = LISTEN.msg.m_station;// station number
    sprintf(bc_pkt.b_msg, job_done,         // format message data
                LISTEN.msg.m_sequence,      // ..with sequence number
                cmd_line);                  // ..and command executed
    bc_pkt.b_mlen = strlen(bc_pkt.b_msg);   // message length

    bcr_pkt.r_len = LENGTHOF(bcr_pkt);      // reply packet length
    r.x.si = (int) &bc_pkt;                 // request packet
    r.x.di = (int) &bcr_pkt;                // reply packet
    s.es = s.ds = FP_SEG(&name_pkt);        // set up segment regs
    r.h.ah = MSG_BROADCAST;                 // send a broadcast msg
    int86x(0x21, &r, &r, &s);               // ..to requesting station
    }
}



// *******************************************************************
//
//  send_and_wait() -- send response message and await acknowledgement
//
// *******************************************************************

void    send_and_wait(void)
{

listen_buffer(&REPLY);                      // make a buffer available

r.x.bx = IPX_SEND;                          // bx = send function code
r.x.si = (unsigned) &LISTEN;                // si -> ECB
s.es = FP_SEG(&LISTEN);                     // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // send reply to command

for (;;)                                    // loop check responses
    {
    if (NOT wait_til(wait_val,              // q. receive response..
            &REPLY.ecb.e_use))              // ..from RMTEXEC client?
        {                                   // a. yes .. check format
        if (REPLY.msg.m_type == MT_ACK)     // q. get acknowledgement?
            break;                          // a. yes .. exit loop
         else
            listen_buffer(&REPLY);          // make a buffer available
        }
     else                                   // else .. timeouts
        {
        if (++errors > 2)                   // q. reach max errors?
            {
            wait_val = 2;                   // a. yes .. don't wait
//          quit_with(client_gone);         // ..and quit w/error msg
            }

        break;                              // ..just exit loop
        }
    }
}



// *******************************************************************
//
//  send_ack() -- send acknowledgement message
//
// *******************************************************************

void    send_ack(void)
{

SEND.msg.m_type = MT_ACK;                   // acknowledgement message

r.x.bx = IPX_SEND;                          // bx = send function code
r.x.si = (unsigned) &SEND;                  // si -> ECB
s.es = FP_SEG(&SEND);                       // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // send acknowledgement

}



// *******************************************************************
//
//  run_command() -- run user command
//
// *******************************************************************

void    run_command(void)
{
int     old_so,                             // old stdout handle
        old_se,                             // ..and old stderr handle
        hh, mm, ss;                         // hours, minutes, seconds
long    hs,                                 // ..and hundredths seconds
        s_tick, e_tick,                     // start and end ticks
        far *timer = (long far *)           // BIOS timer tick counter
                MK_FP(0x40, 0x6c);          // ..address in low memory
FILE   *t_so;                               // temporary stdout
struct  dosdate_t s_date, e_date;           // date fields
struct  dostime_t s_time, e_time;           // ..and time fields


if (LISTEN.msg.m_station)                   // q. station info here?
    sprintf(userid, "%s[%d]",               // a. yes .. build user id
            LISTEN.msg.m_name,              // ..with username
            LISTEN.msg.m_station);          // ..and connection number
 else
    strcpy(userid, unknown);                // else .. use "unknown"

_dos_getdate(&s_date);                      // get start date..
_dos_gettime(&s_time);                      // ..and start time
s_tick = *timer;                            // get starting ticks

printf(running, blocks, block,              // give client info like
        userid, ++cmds_received, block,     // ..userid, job number
        block, LISTEN.msg.m_msg, block,     // ..command to execute
        block, DATE(s_date), TIME(s_time)); // ..starting date/time
printf(not_eoj, "", block, blocks);         // ..and tidy up the block

                                            // set up reply to command
LISTEN.ecb.e_socket =                       // ..ECB socket,
    LISTEN.ipx.i_dsocket =                  // ..destination and
    LISTEN.ipx.i_ssocket = SEND_SOCKET;     // ..source socket numbers
LISTEN.msg.m_sequence = cmds_received;      // ..job number
LISTEN.msg.m_type = MT_EXECUTE;             // ..and message type

r.x.bx = IPX_SEND;                          // bx = send function code
r.x.si = (unsigned) &LISTEN;                // si -> ECB
s.es = FP_SEG(&LISTEN);                     // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // send reply to command

if (LISTEN.msg.m_wflag)                     // q. user waiting?
    {                                       // a. yes .. capture stdout
    t_so = fopen(SO_WORK, "w+");            // create temp stdout file
    old_so = dup(fileno(stdout));           // get duplicate handle
    old_se = dup(fileno(stderr));           // ..for stdout and stderr
    dup2(fileno(t_so), fileno(stdout));     // ..then make them
    dup2(fileno(t_so), fileno(stderr));     // ..use temp file
    }

strcpy(cmd_line, LISTEN.msg.m_msg);         // save command to use
system(LISTEN.msg.m_msg);                   // execute received cmd
if (LISTEN.msg.m_wflag)                     // q. user waiting?
    {                                       // a. yes .. capture stdout
    dup2(old_so, fileno(stdout));           // force stdout back to org
    close(old_so);                          // close copy of org stdout
    dup2(old_se, fileno(stderr));           // force stderr back to org
    close(old_se);                          // close copy of org stderr
    fseek(t_so, 0L, SEEK_SET);              // start from beginning

    LISTEN.msg.m_type = MT_RESPONSE;        // response message type
    errors = 0;                             // clear error count

    while (fgets(LISTEN.msg.m_msg,          // for each line..
            sizeof(LISTEN.msg.m_msg), t_so))
        {
        printf(">> %s", LISTEN.msg.m_msg);  // display locally and ..
        send_and_wait();                    // ..send msg & await ack
        }

    LISTEN.msg.m_type = MT_DONE;            // EOF message type
    send_and_wait();                        // ..send msg & await ack

    fclose(t_so);                           // close our work file
    unlink(SO_WORK);                        // ..then erase it
    }

broadcast_msg();                            // tell user we're done

e_tick = *timer;                            // then get ending ticks
_dos_getdate(&e_date);                      // get ending date..
_dos_gettime(&e_time);                      // ..and time

if (e_tick < s_tick)                        // q. pass day boundary?
    e_tick += TICKS_DAY;                    // a. yes .. fix up count

hs = e_tick - s_tick;                       // get overall tick count

if (NOT hs)                                 // q. take any time?
    hs = 1;                                 // a. yes .. if only a bit

hs *= 5.49254932;                           // ticks to hundredth secs
hh = (int) (hs / 360000L);                  // get hours
hs %= 360000L;                              // ..then remove from total
mm = (int) (hs / 6000);                     // get minutes
hs %= 6000;                                 // ..then remove from total
ss = (int) (hs / 100);                      // get seconds
hs %= 100;                                  // ..leaving hundredths secs

printf(running, blocks, block,              // give client info like
        userid, cmds_received, block,       // ..userid, job number
        block, cmd_line, block,             // ..command to execute
        block, DATE(s_date), TIME(s_time)); // ..starting date/time
printf(end_of_job, TIME(e_time), hh, mm,    // ..completion time
        ss, (int) hs, block, blocks);       // ..and elapsed time
printf(waiting);                            // ..and waiting message

listen_buffer(&LISTEN);                     // prepare to receive msg

}



// *******************************************************************
//
//  process_commands() -- handle server mode processing
//
// *******************************************************************

void    process_commands(void)
{

printf(waiting);                            // tell user our status

for (;;)                                    // loop 'til ctrl-break
    {
    key_hit();                              // handle spurious keys

    if (NOT LISTEN.ecb.e_use)               // q. something available?
        run_command();                      // a. yes .. run user cmd
    }
}



// *******************************************************************
//
//  send_command() -- send command line to RMTEXEC server
//
// *******************************************************************

void    send_command(void)
{
                                            // setup event control blk
SEND.ecb.e_socket = SEND_SOCKET;            // ..socket number
SEND.ecb.e_fragcnt = 1;                     // ..fragment count
SEND.ecb.e_fragaddr = (char far *)&SEND.ipx;// ..user data area
SEND.ecb.e_fragsize = FRAGSIZE;             // ..and fragment size

                                            // set up IPX header
SEND.ipx.i_chks = 0xffff;                   // ..checksum (disabled)
SEND.ipx.i_len = SWAP(FRAGSIZE);            // ..packet length
SEND.ipx.i_packet = 4;                      // ..packet type
SET(SEND.ipx.i_dnode, 0xff);                // ..destination net/node
SEND.ipx.i_dsocket =                        // ..destination and
    SEND.ipx.i_ssocket = SEND_SOCKET;       // ..source socket numbers

                                            // set up user msg area
SEND.msg.m_len = LENGTHOF(SEND.msg);        // ..message length
SEND.msg.m_type = MT_COMMAND;               // ..execute command
SEND.msg.m_station = station;               // ..station number
SEND.msg.m_wflag = sw_wait;                 // ..client waiting flag
strcpy(SEND.msg.m_name, name_pkt.n_name);   // ..user name
strcpy(SEND.msg.m_msg, cmd_line);           // ..and the command

r.x.bx = IPX_GET_TARGET;                    // bx = get local target
r.x.si = (unsigned) &SEND.ipx.i_dnet;       // si -> destination addr
r.x.di = (unsigned) SEND.ecb.e_iaddr;       // di -> immediate addr
s.es = FP_SEG(&SEND);                       // es:si -> ECB
int86x(IPXINT, &r, &r, &s);                 // get local target addr

printf(sending, cmd_line);                  // give status to user

for (;;)                                    // loop 'til message rcv'd
    {
    printf(one_dot);                        // put out one dot per msg

    r.x.bx = IPX_SEND;                      // bx = send function code
    r.x.si = (unsigned) &SEND;              // si -> ECB
    s.es = FP_SEG(&SEND);                   // es:si -> ECB
    int86x(IPXINT, &r, &r, &s);             // send ECB to listen

    if (wait_til(WAIT, &SEND.ecb.e_use))    // q. send complete ok?
        {                                   // a. no .. cancel event
        r.x.bx = IPX_CANCEL;                // bx = cancel event fnc
        r.x.si = (unsigned) &SEND;          // si -> sending ECB
        s.es = FP_SEG(&SEND);               // es:si -> ECB
        int86x(IPXINT, &r, &r, &s);         // cancel send function

        continue;                           // do send again
        }

    if (NOT wait_til(WAIT,                  // q. receive response..
            &LISTEN.ecb.e_use) &&           // ..from RMTEXEC server
            LISTEN.msg.m_type == MT_EXECUTE)// ..and all ok?
        {
        listen_buffer(&LISTEN);             // a. yes .. new listen
        break;                              // ..and exit loop, the
        }                                   // ..server is running
    }

printf(started_job, LISTEN.msg.m_sequence); // give start of job info

if (sw_wait)                                // q. waiting completion?
    {                                       // a. yes .. continue
    for (;;)                                // loop waiting
        {
        if (NOT wait_til(S_WAIT,            // q. receive response..
                    &LISTEN.ecb.e_use))     // ..from RMTEXEC server?
            {
            if (LISTEN.msg.m_type == MT_DONE)   // q. all done?
                {
                send_ack();                     // a. yes .. send ack
                break;                          // ..and quit loop
                }

            if (LISTEN.msg.m_type ==        // q. our type of
                    MT_RESPONSE)            // ..response message?
                {
                printf(">> %s",             // a. yes .. display line
                        LISTEN.msg.m_msg);

                listen_buffer(&LISTEN);     // prepare another rec'v
                send_ack();                 // ..and send an ack
                }

             else                           // if not our msg, just
                listen_buffer(&LISTEN);     // ..prepare to receive
            }
        }
    }
}



// *******************************************************************
//
//  main()
//
// *******************************************************************

void    main(int  ac,                       // DOS cmd line token cnt
             char *av[])                    // ..token strings
{

printf(copyright);                          // give copyright message

check_arguments(ac, av);                    // check arguments
_dos_setvect(0x23, break_rtn);              // set up ^break/^c rtn
open_sockets();                             // open network sockets

if (sw_server)                              // q. server mode?
    process_commands();                     // a. yes .. wait for cmds
 else
    send_command();                         // else, just send command

close_sockets();                            // close network sockets

}
