/*                                                                                                                                                                                              */
/*      NETGRAPH.H -  Header file with structure definitions for Diagnostics    */
/*                                                                      */

#define DIAG_NODES 80
#define IPX_QUERY_SOCKET 0x5604 /* hi-lo order */
#define MAX_RETRIES 3

typedef struct IPXConfigRequestStructure
{
        IPXHeader                                               ipxHeader;
        ExclusionPacketStructure        exclusionList;
} IPXRequestStruct;

typedef struct IPXConfigReplyStructure
{
        IPXHeader       ipxHeader;
        BYTE                    majorVersion;
        BYTE                    minorVersion;
        WORD                    spxDiagnosticSocket;
        BYTE                    componentCount;
        BYTE                    componentType[100];
} IPXReplyStruct;

/* Local Prototypes */

int  DiagnosticsBroadcast(WORD socket, IPXAddress far *ipxAddress);
void SetupECB( ECB far *ecbPtr, WORD socket, void far *fragAddress, WORD size );
int  InBridgeList( struct StructDriver far *driverStruct );
int  InNodeList( BYTE far node[6] );
int  InExceptionList( BYTE far node[6] );

void PrintAddress( BYTE far byte[], int count );
void PrintServersBridges( AddrStruct far BridgeList[] );
void PrintNodes( BYTE far NodeList[][6] );
void Usage( char *s );
