/*																								*/
/*	NETGRAPH.H -  Header file with structure definitions for Diagnostics	*/
/*                                                                   	*/

#define DIAG_NODES 80
#define IPX_QUERY_SOCKET 0x5604 /* hi-lo order */
#define MAX_RETRIES 3

typedef struct IPXConfigRequestStructure
{
	IPXHeader						ipxHeader;
	ExclusionPacketStructure 	exclusionList;
} IPXRequestStruct;

typedef struct IPXConfigReplyStructure
{
	IPXHeader	ipxHeader;
	BYTE			majorVersion;
	BYTE			minorVersion;
	WORD			spxDiagnosticSocket;
	BYTE			componentCount;
	BYTE			componentType[54];
} IPXReplyStruct;

/* Local Prototypes */

/* IPX diagnostic query broadcast */
int  DiagnosticsBroadcast(WORD socket, IPXAddress far *ipxAddress);

/* SPX diagnostic function test harness */
int  DiagnosticsFunctions(AddrStruct far *Address);

void SetupECB( ECB far *ecbPtr, WORD socket, void far *fragAddress, WORD size );
int  InBridgeList( struct StructDriver far *driverStruct );
int  InNodeList( BYTE far node[6] );
int  InExceptionList( BYTE far node[6] );

void PrintAddress( BYTE far byte[], int count );
void PrintServersBridges( AddrStruct far BridgeList[] );
void PrintNodes( BYTE far NodeList[][6] );
void Usage( char *s );
