/*
fgotim.c
cc fgotim.c -o fgotim

           Program to return time_t value according to month and day provided
           The time_t value generated is set to 00:00:00 of the day/month
           provided as input.  This utility can be used by programs which
           need a starting date for comparison purposes - such as getting
           database info starting on a particular date.  This program
           is part of a trio of time utilities which include ftim and
           fcvtim.

           Syntax:  fgotim month day year

           If no parameters are provided, fgotim becomes interactive.  This
           makes fgotim easy to use from shell scripts or from the command
           line when the SysAdmin is writing a special report and needs
           start/stop times.

Fred Lenk 11/5/93

*/

#ident "@(#) fgotim  Display Julian seconds for Month/Day/Year. Fred Lenk 11/5/93."
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
struct tm when;
time_t now;
time_t result;
int month,days,year;

main(argc, argv)
int argc;char **argv;
{

    if(argv[1][0]=='-') {
        printf("Syntax:  fgotim [month 1-12] [day 1-31] [year YY]\n");
        printf("         interactive if no parameters supplied.\n");
        exit(1);
    }

    /*some error checking is done, but is not bulletproof.  This command*/
    /*would typically only be used by SysAdmin who knows how.*/
    if(argc<4) { /*we do the interactive version*/
        printf("Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec\n");
        printf("1   2   3   4   5   6   7   8   9   10  11  12\n");
        printf("Which month?  ");
        scanf("%d",&month);
        printf("\n");
        printf("Enter starting day (1-31):  ");
        scanf("%d",&days);
        printf("\n");
        printf("Enter year (92, 93, etc):  ");
        scanf("%d",&year);
    }
    else {  /*we do the command line version*/
        month=atoi(argv[1]);
        days=atoi(argv[2]);
        year=atoi(argv[3]);
    }

    if(month>12 || month<1) {
        printf("fgotim: illegal month: %d\n",month);
        exit(1);
    }

    if(days>31 || days<1) {
        printf("fgotim: illegal day: %d\n",days);
        exit(1);
    }

    /*There will be limits to the max historical and max future years*/
    /*the platform will be able to use.  Experiment.*/

    time(&now);
    /*printf("now=%ld  %s\n",now,ctime(&now));*/
    when = *localtime(&now);
    when.tm_sec=0;
    when.tm_min=0;
    when.tm_hour=0;
    when.tm_mday = days;
    when.tm_mon = month - 1;
    when.tm_year = year;
    if ((result = mktime(&when)) != (time_t)-1) {
        printf("%ld\n",result);
    }
    else {
        perror("fgotim failed");
    }

    return;
}
/*end fgotim.c*/
