%{
#include "y.tab.h"
#include "linker.h"
extern char *copy_token();
%}
/* at the moment it can not handle underscore's unless you use flex */


path [-a-zA-Z0-9_\/\.:]+
depthval [0-9]+
eql ==
sym ->
delimit ;
brack \[|\]
root ROOT
depth search-depth
singlel single_link
multil multi_link
subl sub_multi_link
manl man_link
%%

{brack}  { return BRACK;}

{singlel}  return SINGLE_LINK; 

{multil}  { return MULTI_LINK; }

{subl}  { return SUB_MULTI_LINK; }

{manl}  { return MAN_LINK; }

{depth} { return DEPTH; }

{depthval} { yylval.string = copy_token();
	printf("depth = %s\n", yylval.string);
	return DEPTHVAL; }

{root} { return ROOT; }

{path} { yylval.string = copy_token();
	printf("path = %s\n", yylval.string);
	return PATH; }

{delimit} return DELIMIT;

{sym} return SYM;

{eql} { return EQL; }

[ \t]* ;

\n  ;

^#.*$  ;

%
