/*
 * passwd -- a super dooper password changer
 * it checks for specifically bad passwords and refuses
 * to change a password to them
 *
 * this is the header file
 */
#include <stdio.h>
#include <ctype.h>
#include <grp.h>
#include <pwd.h>
#include <sys/types.h>
#include "sys.h"
#ifdef SYSLOG
#	include <syslog.h>
#endif

/*
 * the following should be reset to those parameters
 * that fit best with your system
 */
#define DEFPWFILE	"./passwd.data"		/* password file */
#define PWTESTFILE	"./passwd.test"		/* password test file */
#define DEFAULTTEST				/* default test if needed */
#define LG_DEFAULT	LG_NONE			/* default logging */
#define LG_OUTDEF	"> ./passwd.log"		/* default logging location */
#define LG_INIT		" "			/* initial logging */

/*
 * the following may be changed but odds are you won't want to
 */
#define ROOTID		0		/* the UID of the superuser */
#define PWSIGCHARS	8		/* significant characters */
#define MAXLOGTO	10		/* max number of open logs */
#define GECOSSIZE	100		/* max size of gecos fields */

/*
 * the following should NEVER be changed (unless you're suicidal!)
 */
#ifndef NUVAR
	/**** WARNING -- IF YOU CHANGE THIS REMEMBER TO DELETE THE ****/
	/**** 		 APPROPRIATE ESCAPES IN VERIFY.C           ****/
#	define NUVAR		10	/* number of user definable escapes */
#endif

/*
 *========== L O G G I N G  M A C R O S ==========
 *
 * We allow the user to log a number of ways
 * The macros below indicate his choices
 */
#define LG_FILE		0x01		/* to a file */
#define LG_PIPE		0x02		/* to a pipe */
#define LG_STDERR	0x04		/* to stderr */
					/* if no syslog, write to error */
#ifdef SYSLOG
#define	LG_SYSLOG	0x08		/* syslog; may not be valid */
#else
#define	LG_SYSLOG	LG_STDERR	/* no syslog: send to stderr */
#endif

/*
 * he can log several sorts of things:
 */
#define	LG_NONE		0x00		/* log nothing */
#define	LG_SYNTAX	0x01		/* log syntax errors */
#define LG_USE		0x02		/* log use of program */
#define LG_RESULT	0x04		/* log result of run */
#define LG_ITEM		0x08		/* log why test failed */
#define LG_DEBUG	0x10		/* log debugging information */
#define LG_SYSTEM	0x20		/* log system problems */
#define LG_ALL		0x3f		/* log everything */
/*
 * a convenience to make excluding components easy
 */
#define LG_NEG		'!'		/* negation character */
/*
 * some generally useful macros
 */
					/* ends log keyword */
#define log_end(x)	(ispunct((x))||isspace((x))||((x)=='\0'))
#define log_set(x,y)	((x)|=((y)&LG_ALL))	/* set one bit for logging */
#define log_reset(x,y)	((x)&=((~(y))&LG_ALL))	/* clear one bit for logging */
#define	log_test(x,y)	(((x)&(y))==(y))	/* 1 if to log y */
/*
 * these macros do the actual logging
 * and are here to keep the logging functions simple
 * they are named LOGn, where n is the number of arguments to sprintf
 */
#define LOG0(y, z)	logfunc(y, z)
#define LOG1(y, z, a)	{					\
			char tbuf[BUFSIZ];			\
			SPRINTF(tbuf, z, a);			\
			logfunc(y, tbuf);			\
		}
#define LOG2(y, z, a, b)	{				\
			char tbuf[BUFSIZ];			\
			SPRINTF(tbuf, z, a, b);			\
			logfunc(y, tbuf);			\
		}
#define LOG3(y, z, a, b, c)	{				\
			char tbuf[BUFSIZ];			\
			SPRINTF(tbuf, z, a, b, c);		\
			logfunc(y, tbuf);			\
		}

/*
 *========== E S C A P E   S E Q U E N C E S   F O R   T E S T S ==========
 *
 * these tell how to access escape sequences
 */
#define	F_ASIS		0	/* insert the string as is */
#define F_NUMBER	1	/* insert the length of the string */
#define F_UPPER		2	/* insert the string in upper case */
#define F_LOWER		3	/* insert the string in lower case */
#define F_FIRST		4	/* insert the string first capitalized */

/*
 * a number or a string?
 */
#define	TY_STR		0	/* string */
#define	TY_NUM		1	/* number */

/*
 * map upper case to lower case
 */
#define lowcase(x)	(isupper((x)) ? tolower((x)) : (x))
#define upcase(x)	(islower((x)) ? toupper((x)) : (x))

/*
 * structure to hold "%" and "#" escapes (ie, internal variables)
 */
struct intvar {
	char name;		/* internal variable name to the user */
	int nstype;		/* 1 if a number, 0 if a string */
	char *string;		/* string value */
	char *length;		/* length (as a string) */
	int userset;		/* 1 if this can be reset */
	char *prompt;		/* a prompt, if needed */
};
			/* quick assignment macros */
#define	IVSASSIGN(x, y)	{						\
		register struct intvar *ipx = findiv(x);		\
		ipx->string = strsave((y));				\
		if ((y) == CH_NULL)	ipx->length = strsave(CH_NULL);	\
		else			ipx->length = tonum(strlen(y));	\
	}
#define	IVSPASSIGN(x, y)	{					\
		(x)->string = strsave((y));				\
		if ((y) == CH_NULL)	(x)->length = strsave(CH_NULL);	\
		else			(x)->length = tonum(strlen(y));	\
	}
#define	IVNASSIGN(x, y, z) {						\
		register struct intvar *ipx = findiv(x);		\
		ipx->string = tonum((y));				\
		ipx->length = tonum((z));				\
	}

/*
 *========== N U L L   P O I N T E R S ==========
 *
 * NULL pointers -- these are used to shut lint up
 */
#define CH_NULL	((char *) NULL)		/* NULL character pointer */
#define FI_NULL ((FILE *) NULL)		/* NULL file pointer */
#define GR_NULL ((struct group *) NULL)	/* NULL group structure pointer */
#define IV_NULL ((struct intvar *) NULL)/* NULL escape structure pointer */
#define PW_NULL ((struct passwd *) NULL)/* NULL password structure pointer */
#define TI_NULL ((time_t *) NULL)	/* NULL time pointer */

/*
 *========== D E C L A R A T I O N S ==========
 *
 * globals
 */
extern char runner[];		/* who is running this program */
extern char user[];		/* name of user */
extern char password[];		/* new password */
extern char oldpassword[];	/* current password */
extern struct passwd *pwinfo;	/* associated password structure */
extern char *progname;		/* program name */
extern char *pwdfile;		/* password file */
extern char pwtest[];		/* password test file */
extern int pwsig;		/* number of significant chars in password */
extern unsigned int logging;	/* logging level */
extern int linect;		/* line number of test file */
extern struct intvar iv[];	/* internal variables */
extern int pf_errno;		/* system error from update_pwd() */

/*
 * system variables
 */
extern int errno;		/* system error number */
extern int sys_nerr;		/* number of system errors */
extern char *sys_errlist[];	/* descriptions of system errors */

/*
 * internal (forward) declarations
 */
extern struct intvar *findiv();	/* find entry for internal variable */
extern int fmgets();		/* like mgets but folds to lower case */
extern char *getcstring();	/* read a string in C syntax */
extern int mgets();		/* like fgets but clobbers trailing newline */
extern struct passwd *mgpwnam();/* password structure lookup on name */
extern struct passwd *mgpwuid();/* password structure lookup on uid */
extern char *nfmt();		/* formats a number */
extern char *sfmt();		/* formats a string */
extern char *strsave();		/* copy a string into allocated memory */
extern char *tonum();		/* convert inter to char string */

/*
 * library functions
 */
extern char *crypt();		/* encrypt a password */
extern int fclose();		/* closes a file */
extern FILE *fopen();		/* opens a file, returns pointer */
extern int fprintf();		/* formatted print to file */
extern struct group *getgrgid();/* get group information */
extern char *getpass();		/* grab a password */
#ifdef GETUSERSHELL
extern char *GETUSERSHELL();	/* return legal user shells */
#endif
extern char *index();		/* find first occurrance of char */
extern char *malloc();		/* allocate memory */
extern int pclose();		/* closes a pipe */
extern FILE *popen();		/* opens a pipe, returns pointer */
extern int printf();		/* formatted print to standard output */
extern char *sprintf();		/* formatted print to memory */
extern char *strcat();		/* append to a string */
extern int strcmp();		/* string comparison function */
extern char *strcpy();		/* copy a string */
extern char *strncpy();		/* copy part of a string */
extern time_t time();		/* return internal time */

/*
 * lint stuff
 */
#define FPRINTF	(void) fprintf	/* return value of fprintf NEVER used */
#define PRINTF	(void) printf	/* return value of printf NEVER used */
#define SPRINTF	(void) sprintf	/* return value of sprintf NEVER used */
