/* LocaleInformation_vi.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_vi extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "VND";

  private static final String currenciesDisplayNameValues = "\u0111\u1ed3ng";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "VND";

  private static final String currenciesSymbolValues = "\u0111";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "thg 1",
    "thg 2",
    "thg 3",
    "thg 4",
    "thg 5",
    "thg 6",
    "thg 7",
    "thg 8",
    "thg 9",
    "thg 10",
    "thg 11",
    "thg 12",
    null,
  };

  private static final String[] months = {
    "th\u00e1ng m\u1ed9t",
    "th\u00e1ng hai",
    "th\u00e1ng ba",
    "th\u00e1ng t\u01b0",
    "th\u00e1ng n\u0103m",
    "th\u00e1ng s\u00e1u",
    "th\u00e1ng b\u1ea3y",
    "th\u00e1ng t\u00e1m",
    "th\u00e1ng ch\u00edn",
    "th\u00e1ng m\u01b0\u1eddi",
    "th\u00e1ng m\u01b0\u1eddi m\u1ed9t",
    "th\u00e1ng m\u01b0\u1eddi hai",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "CN",
    "Th 2",
    "Th 3",
    "Th 4",
    "Th 5",
    "Th 6",
    "Th 7",
  };

  private static final String[] weekdays = {
    null,
    "Ch\u1ee7 nh\u1eadt",
    "Th\u1ee9 hai",
    "Th\u1ee9 ba",
    "Th\u1ee9 t\u01b0",
    "Th\u1ee9 n\u0103m",
    "Th\u1ee9 s\u00e1u",
    "Th\u1ee9 b\u1ea3y",
  };

  private static final String[] eras = {
    "tr. CN",
    "sau CN",
  };

  private static final String[] ampms = {
    "SA",
    "CH",
  };

  private static final String territoriesKeys = "TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GT\u00A6GR\u00A6GQ\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6SV\u00A6ST\u00A6GH\u00A6SR\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SI\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6PY\u00A6DK\u00A6DJ\u00A6PT\u00A6DE\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BJ\u00A6BI\u00A6BH\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6AZ\u00A6NE\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6MZ\u00A6AO\u00A6MY\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6MR\u00A6AG\u00A6AF\u00A6AE\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6TW\u00A6TV\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "T\u00e1t-gi-ki-xtan\u00A6Th\u00e1i Lan\u00A6T\u00f4-g\u00f4\u00A6Guy-a-na\u00A6S\u00e1t\u00A6Ghi-n\u00ea B\u00edt-xao\u00A6Goa-t\u00ea-ma-la\u00A6Hy L\u1ea1p\u00A6Ghi-n\u00ea X\u00edch-\u0111\u1ea1o\u00A6Xoa-di-len\u00A6Xi-ri\u00A6Ghi-n\u00ea\u00A6G\u0103m-bi-a\u00A6En-san-va-\u0111o\u00A6Xao T\u00f4-m\u00ea v\u00e0 Prin-xi-p\u00ea\u00A6Gha-na\u00A6Xu-ri-nam\u00A6Gru-di-a\u00A6X\u00f4-ma-li\u00A6Gr\u00ea-na-\u0111a\u00A6X\u00ea-n\u00ea-gan\u00A6Xan Ma-ri-n\u00f4\u00A6V\u01b0\u01a1ng qu\u1ed1c Anh\u00A6Xi-\u00ea-ra L\u00ea-\u00f4n\u00A6Ga-b\u00f4ng\u00A6Xl\u00f4-va-ki-a\u00A6Xl\u00f4-ven-ni-a\u00A6Xin-ga-po\u00A6Th\u1ee5y \u0110i\u1ec3n\u00A6Xu-\u0111\u0103ng\u00A6X\u00e2y-sen\u00A6Qu\u1ea7n \u0111\u1ea3o X\u00f4-l\u00f4-m\u00f4ng\u00A6A-r\u1eadp X\u00ea-\u00fat\u00A6Ph\u00e1p\u00A6Mi-cr\u00f4-n\u00ea-xi-a\u00A6Ru-an-\u0111a\u00A6Nga\u00A6Phi-gi\u00A6Ph\u1ea7n Lan\u00A6Ru-ma-ni\u00A6\u00ca-ti-\u00f4-pi-a\u00A6T\u00e2y Ban Nha\u00A6\u00ca-ri-t\u01a1-r\u00ea-a\u00A6T\u00e2y Sahara\u00A6Ai C\u1eadp\u00A6E-xt\u00f4-ni-a\u00A6\u00ca-cu-a-\u0111o\u00A6An-gi\u00ea-ri\u00A6Ca-ta\u00A6Pa-ra-goay\u00A6\u0110an M\u1ea1ch\u00A6Gi-bu-ti\u00A6B\u1ed3 \u0110\u00e0o Nha\u00A6\u0110\u1ee9c\u00A6Ba Lan\u00A6Pa-ki-xtan\u00A6Phi-lip-pin\u00A6Pa-pu-a Niu Ghi-n\u00ea\u00A6C\u1ed9ng h\u00f2a S\u00e9c\u00A6P\u00ea-ru\u00A6S\u00edp\u00A6C\u00e1p-ve\u00A6Pa-na-ma\u00A6Cu Ba\u00A6C\u1ed1t-xta Ri-ca\u00A6C\u00f4-l\u00f4m-bi-a\u00A6Trung Qu\u1ed1c\u00A6Ca-m\u01a1-run\u00A6Chi-l\u00ea\u00A6B\u1edd Bi\u1ec3n Ng\u00e0\u00A6Th\u1ee5y S\u0129\u00A6C\u00f4ng-g\u00f4\u00A6C\u1ed9ng h\u00f2a Trung Phi\u00A6\u00d4-man\u00A6Ca-na-\u0111a\u00A6B\u00ea-li-x\u00ea\u00A6B\u00ea-la-r\u00fat\u00A6B\u1ed1t-xoa-na\u00A6Ba-ha-ma\u00A6Bra-xin\u00A6Niu Di-l\u00e2n\u00A6B\u00f4-li-vi-a\u00A6Bru-n\u00e2y\u00A6B\u00ea-nanh\u00A6Bu-run-\u0111i\u00A6Ba-ren\u00A6Bun-ga-ri\u00A6Bu\u1ed1c-ki-na Pha-x\u00f4\u00A6N\u00ea-pan\u00A6B\u1ec9\u00A6Na Uy\u00A6B\u0103ng-la-\u0111\u00e9t\u00A6B\u00e1c-ba-\u0111\u1ed1t\u00A6Dim-ba-bu-\u00ea\u00A6H\u00e0 Lan\u00A6B\u00f4-xni-a H\u00e9c-x\u00ea-g\u00f4-vi-na\u00A6Ni-ca-ra-goa\u00A6Ni-gi\u00ea-ri-a\u00A6Ai-d\u00e9c-bai-gian\u00A6Ni-gi\u00ea\u00A6D\u0103m-bi-a\u00A6\u00dac\u00A6Nam-mi-bi-a\u00A6\u00c1o\u00A6\u00c1c-hen-ti-na\u00A6M\u00f4-d\u0103m-b\u00edch\u00A6\u0102ng-g\u00f4-la\u00A6Ma-lay-xi-a\u00A6M\u00ea-hi-c\u00f4\u00A6\u00c1c-m\u00ea-ni-a\u00A6Ma-la-uy\u00A6An-ba-ni\u00A6Man-\u0111i-v\u01a1\u00A6Nam Phi\u00A6M\u00f4-ri-x\u01a1\u00A6Man-ta\u00A6M\u00f4-ri-ta-ni\u00A6An-ti-gu-a v\u00e0 Ba-bu-\u0111a\u00A6\u00c1p-ga-ni-xtan\u00A6C\u00e1c Ti\u1ec3u V\u01b0\u01a1ng qu\u1ed1c A-r\u1eadp Th\u1ed1ng nh\u1ea5t\u00A6M\u00f4ng C\u1ed5\u00A6Mi-an-ma\u00A6Ma-li\u00A6Ma-x\u00ea-\u0111\u00f4-ni-a\u00A6Nam T\u01b0\u00A6Qu\u1ea7n \u0111\u1ea3o M\u00e1c-san\u00A6Ma-\u0111a-g\u00e1t-xca\u00A6M\u00f4n-\u0111\u00f4-va\u00A6M\u00f4-na-c\u00f4\u00A6Ma-r\u1ed1c\u00A6Y-\u00ea-men\u00A6Li-bi\u00A6L\u00e1t-vi-a\u00A6L\u00fac-x\u0103m-bua\u00A6Li-tu-a-ni-a\u00A6L\u00ea-x\u00f4-th\u00f4\u00A6Li-b\u00ea-ri-a\u00A6Xri Lan-ca\u00A6Lich-ten-xt\u00ean\u00A6Xan Lu-xi\u00A6Li-b\u0103ng\u00A6L\u00e0o\u00A6Ka-d\u1eafc-xtan\u00A6C\u00f4-o\u00e9t\u00A6H\u00e0n Qu\u1ed1c\u00A6B\u1eafc Tri\u1ec1u Ti\u00ean\u00A6Xan-k\u00edt v\u00e0 N\u00ea-vi\u00A6C\u00f4-m\u00f4\u00A6Ki-ri-ba-ti\u00A6Xa-moa\u00A6Campuchia\u00A6C\u01b0-r\u01a1-g\u01b0-xtan\u00A6K\u00ea-ni-a\u00A6Nh\u1eadt B\u1ea3n\u00A6Gi\u00f3c-\u0111a-ni\u00A6Ha-mai-ca\u00A6Va-nu-a-tu\u00A6Vi\u1ec7t Nam\u00A6V\u00ea-n\u00ea-zu-\u00ea-la\u00A6Xan Vin-xen v\u00e0 Gr\u00ea-na-din\u00A6Va-ti-c\u0103ng\u00A6\u00dd\u00A6Ai-x\u01a1-len\u00A6I-ran\u00A6I-r\u1eafc\u00A6U-d\u01a1-b\u00ea-ki-xtan\u00A6U-ru-goay\u00A6\u1ea4n \u0110\u1ed9\u00A6I-xra-en\u00A6Hoa K\u1ef3\u00A6Ai-len\u00A6Nam D\u01b0\u01a1ng\u00A6U-gan-\u0111a\u00A6U-crai-na\u00A6Hung-ga-ri\u00A6Ha-i-ti\u00A6Cr\u00f4-a-ti-a\u00A6Tan-da-ni-a\u00A6H\u00f4n-\u0111u-r\u00e1t\u00A6\u0110\u00e0i Loan\u00A6Tu-va-lu\u00A6Tri-ni-\u0111\u00e1t v\u00e0 T\u00f4-ba-g\u00f4\u00A6Th\u1ed5 Nh\u0129 K\u1ef3\u00A6T\u00f4ng-ga\u00A6Tuy-ni-di\u00A6Tu\u1ed1c-m\u00ea-ni-xtan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ne\u00A6th\u00A6az\u00A6zh\u00A6ar\u00A6jv\u00A6ms\u00A6sv\u00A6pt\u00A6sr\u00A6mn\u00A6sq\u00A6so\u00A6mk\u00A6de\u00A6pl\u00A6sl\u00A6sk\u00A6da\u00A6ga\u00A6vi\u00A6ja\u00A6yi\u00A6sa\u00A6cs\u00A6lv\u00A6it\u00A6fr\u00A6is\u00A6uz\u00A6lt\u00A6ru\u00A6lo\u00A6fi\u00A6ro\u00A6ca\u00A6id\u00A6uk\u00A6fa\u00A6ia\u00A6la\u00A6hy\u00A6et\u00A6hu\u00A6es\u00A6bo\u00A6hr\u00A6eo\u00A6en\u00A6el\u00A6ko\u00A6kn\u00A6no\u00A6km\u00A6bg\u00A6tr\u00A6hi\u00A6be\u00A6nl\u00A6he";

  private static final String languagesValues = "Ti\u1ebfng N\u00ea-pan\u00A6Ti\u1ebfng Th\u00e1i\u00A6Ti\u1ebfng Ai-d\u00e9c-bai-gian\u00A6Ti\u1ebfng Trung Qu\u1ed1c\u00A6Ti\u1ebfng A-r\u1eadp\u00A6Ti\u1ebfng Gia-va\u00A6Ti\u1ebfng Ma-lay-xi-a\u00A6Ti\u1ebfng Th\u1ee5y \u0110i\u1ec3n\u00A6Ti\u1ebfng B\u1ed3 \u0110\u00e0o Nha\u00A6Ti\u1ebfng S\u00e9c-bi\u00A6Ti\u1ebfng M\u00f4ng C\u1ed5\u00A6Ti\u1ebfng An-ba-ni\u00A6Ti\u1ebfng X\u00f4-ma-li\u00A6Ti\u1ebfng Ma-x\u00ea-\u0111\u00f4-ni-a\u00A6Ti\u1ebfng \u0110\u1ee9c\u00A6Ti\u1ebfng Ba Lan\u00A6Ti\u1ebfng Xl\u00f4-ven\u00A6Ti\u1ebfng Xl\u00f4-v\u00e1c\u00A6Ti\u1ebfng \u0110an M\u1ea1ch\u00A6Ti\u1ebfng Ai-len\u00A6Ti\u1ebfng Vi\u1ec7t\u00A6Ti\u1ebfng Nh\u1eadt\u00A6Ti\u1ebfng Y-\u0111it\u00A6Ti\u1ebfng Ph\u1ea1n\u00A6Ti\u1ebfng S\u00e9c\u00A6Ti\u1ebfng L\u00e1t-vi-a\u00A6Ti\u1ebfng \u00dd\u00A6Ti\u1ebfng Ph\u00e1p\u00A6Ti\u1ebfng Ai-x\u01a1-len\u00A6Ti\u1ebfng U-d\u01a1-b\u1ebfch\u00A6Ti\u1ebfng L\u00edt-va\u00A6Ti\u1ebfng Nga\u00A6Ti\u1ebfng L\u00e0o\u00A6Ti\u1ebfng Ph\u1ea7n Lan\u00A6Ti\u1ebfng Ru-ma-ni\u00A6Ti\u1ebfng Ca-ta-l\u0103ng\u00A6Ti\u1ebfng In-\u0111\u00f4-n\u00ea-xia\u00A6Ti\u1ebfng U-crai-na\u00A6Ti\u1ebfng Ba T\u01b0\u00A6Ti\u1ebfng Khoa H\u1ecdc Qu\u1ed1c T\u1ebf\u00A6Ti\u1ebfng La-tinh\u00A6Ti\u1ebfng \u00c1c-m\u00ea-ni\u00A6Ti\u1ebfng E-xt\u00f4-ni-a\u00A6Ti\u1ebfng Hung-ga-ri\u00A6Ti\u1ebfng T\u00e2y Ban Nha\u00A6Ti\u1ebfng T\u00e2y T\u1ea1ng\u00A6Ti\u1ebfng Cr\u00f4-a-ti-a\u00A6Ti\u1ebfng Qu\u1ed1c T\u1ebf Ng\u1eef\u00A6Ti\u1ebfng Anh\u00A6Ti\u1ebfng Hy L\u1ea1p\u00A6Ti\u1ebfng H\u00e0n Qu\u1ed1c\u00A6Ti\u1ebfng Kan-na-\u0111a\u00A6Ti\u1ebfng Na Uy\u00A6Ti\u1ebfng Campuchia\u00A6Ti\u1ebfng Bun-ga-ri\u00A6Ti\u1ebfng Th\u1ed5 Nh\u0129 K\u1ef3\u00A6Ti\u1ebfng Hin-\u0111i\u00A6Ti\u1ebfng B\u00ea-la-r\u00fat\u00A6Ti\u1ebfng H\u00e0 Lan\u00A6Ti\u1ebfng H\u00ea-br\u01a1";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currencyFormat", "#,##0.00 \u00a4;-#,##0.00 \u00a4" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd/MM/yyyy" },
    { "mediumDateFormat", "dd-MM-yyyy" },
    { "longDateFormat", "'Ng\u00e0y' dd 'th\u00e1ng' M 'n\u0103m' yyyy" },
    { "fullDateFormat", "EEEE, 'ng\u00e0y' dd MMMM 'n\u0103m' yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
