/*
 * Electric(tm) VLSI Design System
 *
 * File: sim.h
 * Simulation tool: header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/********************* for all simulators *********************/

#define ESIM       0					/* ESIM from MIT (SIM format) */
#define RSIM       1					/* RSIM from MIT (SIM format) */
#define RNL        2					/* RNL from MIT (SIM format) */
#define COSMOS     3					/* COSMOS from CMU (SIM format) */
#define SPICE      4					/* SPICE from Berkeley (SPICE format) */
#define MOSSIM     5					/* MOSSIM from CalTech (NTK format) */
#define TEXSIM     6					/* TEGAS from Calma (TDL format) */
#define ABEL       7					/* ABEL from Data I/O (PAL programmer) */
#define VERILOG    8					/* VERILOG from Gateway (VER format) */
#define SILOS      9					/* SILOS from Simucad */
#define ALS       10					/* ALS (NET format) */
#define FASTHENRY 11					/* FastHenry (INP format) */
#define IRSIM     12					/* IRSIM from Stanford (SIM format) */
#define CDL       13					/* CDL (SPICE with no headers or parameters) */

/* the meaning of "SIM_dontrun" */
#define SIMRUNYES       -1				/* run simulation, show output */
#define SIMRUNYESPARSE   0				/* run simulation, show output, parse output */
#define SIMRUNNO         1				/* do not runs simulation */
#define SIMRUNYESQPARSE  2				/* run simulation, parse output */
#define SIMRUNYESQ       3				/* run simulation */

extern TOOL      *sim_tool;				/* the Simulator tool object */
extern INTBIG     sim_formatkey;		/* key for "SIM_format" (ESIM, etc) */
extern INTBIG     sim_netfilekey;		/* key for "SIM_netfile" */
extern INTBIG     sim_dontrunkey;		/* key for "SIM_dontrun" */
extern INTBIG     sim_weaknodekey;		/* key for "SIM_weak_node" */
extern INTBIG     sim_spice_partskey;	/* key for "SIM_spice_parts" */
extern char      *sim_spice_parts;		/* cached value for "SIM_spice_parts" */
extern NODEPROTO *sim_simnt;			/* facet being simulated */
extern int        sim_tosim[2];			/* pipe to the simulator process */
extern int        sim_fromsim[2];		/* pipe from the simulator process */
extern INTBIG     sim_process;			/* process number of simulator */
extern INTBIG     sim_filetypeesim;		/* ESIM netlist disk file descriptor */
extern INTBIG     sim_filetypefasthenry;/* FastHenry netlist disk file descriptor */
extern INTBIG     sim_filetypemossim;	/* MOSSIM netlist disk file descriptor */
extern INTBIG     sim_filetypepal;		/* PAL netlist disk file descriptor */
extern INTBIG     sim_filetypeals;		/* ALS netlist disk file descriptor */
extern INTBIG     sim_filetypealsvec;	/* ALS vectors disk file descriptor */
extern INTBIG     sim_filetypeirsimcmd;	/* IRSIM command (vectors) file descriptor */
extern INTBIG     sim_filetypenetlisp;	/* Netlisp netlist disk file descriptor */
extern INTBIG     sim_filetypequisc;	/* QUISC netlist disk file descriptor */
extern INTBIG     sim_filetypersim;		/* RSIM netlist disk file descriptor */
extern INTBIG     sim_filetypeirsim;	/* IRSIM netlist disk file descriptor */
extern INTBIG     sim_filetypesilos;	/* Silos netlist disk file descriptor */
extern INTBIG     sim_filetypespice;	/* SPICE input disk file descriptor */
extern INTBIG     sim_filetypespicecmd;	/* SPICE command disk file descriptor */
extern INTBIG     sim_filetypespiceout;	/* SPICE output disk file descriptor */
extern INTBIG     sim_filetypehspiceout;/* HSPICE output file descriptor */
extern INTBIG     sim_filetyperawspiceout; /* SPICE raw output disk file descriptor */
extern INTBIG     sim_filetypecdl;		/* CDL output file descriptor */
extern INTBIG     sim_filetypectemp;	/* CDL template disk file descriptor */
extern INTBIG     sim_filetypetegas;	/* Tegas netlist disk file descriptor */
extern INTBIG     sim_filetypetegastab;	/* Tegas table disk file descriptor */
extern INTBIG     sim_filetypeverilog;	/* Verilog disk file descriptor */

/********************* for Simulation Window *********************/

/* the bits returned by "sim_window_isactive()" */
#define SIMWINDOWWAVEFORM       1		/* set if waveform window is active */
#define SIMWINDOWSCHEMATIC      2		/* set if schematic window is active */

#define MAXSIMWINDOWBUSWIDTH  300		/* maximum width of a bus in thw waveform window */

/* logic levels and signal strengths in the window */
#define LOGIC_LOW              -1
#define LOGIC_X                -2
#define LOGIC_HIGH             -3
#define OFF_STRENGTH            0
#define NODE_STRENGTH           2
#define GATE_STRENGTH           4
#define VDD_STRENGTH            6

/* the meaning of "SIM_window_state" */
#define FULLSTATE              01		/* set for full 12-state simulation */
#define SHOWWAVEFORM           02		/* set to show waveform window */
#define ADVANCETIME            04		/* set to advance time to end of simulation */
#define BUSBASEBITS           070		/* base to use for bus display */
#define BUSBASE10               0		/*   use base 10 for bus display */
#define BUSBASE2              010		/*   use base 2 for bus display */
#define BUSBASE8              020		/*   use base 8 for bus display */
#define BUSBASE16             040		/*   use base 16 for bus display */
#define WAVEPLACE            0300		/* location of waveform windows */
#define WAVEPLACECAS            0		/*   cascade waveform windows */
#define WAVEPLACETHOR        0100		/*   cascade waveform windows */
#define WAVEPLACETVER        0200		/*   cascade waveform windows */
#define SIMENGINE           01400		/* simulation engine to use */
#define SIMENGINEALS            0		/*   use ALS simulation engine */
#define SIMENGINEIRSIM       0400		/*   use IRSIM simulation engine */

extern INTBIG  sim_window_statekey;		/* key for "SIM_window_state" */
extern INTBIG  sim_window_state;		/* cached value of "SIM_window_state" */
extern INTBIG  sim_window_signalorder_key;	/* key for "SIM_window_signalorder" */
extern INTBIG  sim_window_format;		/* type of simulation in window */

/* prototypes */
void    sim_window_init(void);
void    sim_window_term(void);
BOOLEAN sim_window_create(INTBIG, NODEPROTO*, BOOLEAN(*)(WINDOWPART*, INTSML, INTBIG),
						  BOOLEAN(*)(WINDOWPART*, INTSML, INTBIG), INTBIG);
void    sim_window_stopsimulation(void);
INTBIG  sim_window_isactive(NODEPROTO **np);
void    sim_window_redraw(void);
void    sim_window_setnumframes(INTBIG);
INTBIG  sim_window_getnumframes(void);
INTBIG  sim_window_getnumvisframes(void);
INTBIG  sim_window_getcurframe(void);
void    sim_window_settopvisframe(INTBIG count);
INTBIG  sim_window_gettopvisframe(void);
void    sim_window_savegraph(void);
void    sim_window_writespicecmd(void);
void    sim_window_displaycolor(INTBIG strength, INTBIG color);
INTBIG  sim_window_newtrace(INTBIG, char*, INTBIG);
BOOLEAN sim_window_buscommand(void);
INTBIG  sim_window_makebus(INTBIG count, INTBIG *traces, char *busname);
void    sim_window_loaddigtrace(INTBIG, INTBIG, double*, INTSML*);
void    sim_window_loadanatrace(INTBIG, INTBIG, double*, float*);
void    sim_window_setanarange(INTBIG, float, float);
void    sim_window_getanarange(INTBIG, float*, float*);
void    sim_window_setanaextents(float, float);
void    sim_window_getanaextents(float*, float*);
void    sim_window_settraceframe(INTBIG, INTBIG);
void    sim_window_killtrace(INTBIG);
void    sim_window_killalltraces(BOOLEAN);
INTBIG *sim_window_getbustraces(INTBIG);
INTBIG  sim_window_gettraceframe(INTBIG);
char   *sim_window_gettracename(INTBIG);
INTBIG  sim_window_gettracedata(INTBIG);
float   sim_window_getanatracevalue(INTBIG, double);
INTBIG  sim_window_findtrace(char*);
void    sim_window_inittraceloop(void);
void    sim_window_inittraceloop2(void);
INTBIG  sim_window_nexttraceloop(void);
INTBIG  sim_window_nexttraceloop2(void);
void    sim_window_cleartracehighlight(void);
void    sim_window_addhighlighttrace(INTBIG);
void    sim_window_deletehighlighttrace(INTBIG);
INTBIG  sim_window_gethighlighttrace(void);
INTBIG *sim_window_gethighlighttraces(void);
void    sim_window_clearframehighlight(void);
void    sim_window_setmaincursor(double);
double  sim_window_getmaincursor(void);
void    sim_window_setextensioncursor(double);
double  sim_window_getextensioncursor(void);
void    sim_window_settimerange(INTBIG, double, double);
void    sim_window_gettimerange(INTBIG, double*, double*);
void    sim_window_getaveragetimerange(double *avgmintime, double *avgmaxtime);
void    sim_window_gettimeextents(double*, double*);
void    sim_window_updatelayoutwindow(void);
void    sim_windowconvertengineeringnotation(double, char*);
void    sim_window_setstate(INTBIG);
INTBIG  sim_window_getwidevalue(INTBIG **bits);

/********************* for ESIM *********************/

#define ESIMNAME    "esim"

/********************* for RSIM *********************/

#define RSIMPRENAME "presim"
#define RSIMNAME    "rsim"
#define RSIMIN      "rsim.in"			/* name of file with binary network */

/********************* for ALS *********************/

#define NET_EXT		".net"
#define PLOT_EXT	".hpgl"

/********************* for RNL *********************/

#define RNLPRENAME  "presim"
#define RNLNAME     "rnl"
#define RNLIN       "rnl.in"			/* name of file with binary network */
#define RNLCOMM     "nl.l"				/* file with simulator initialization */

/********************* for VERILOG *********************/

/* Meaning of bits in "SIM_verilog_state" */
#define VERILOGUSEASSIGN  01			/* set to use "assign" construct */
#define VERILOGUSETRIREG  02			/* set to use "trireg" wire by default */

extern INTBIG sim_verilog_statekey;		/* key for "SIM_verilog_state" */

/********************* for SPICE *********************/

#define MAXSPICELEVEL     3				/* levels 1, 2, and 3 */

/* Meaning of bits in sim_spice_state */
#define SPICERESISTANCE    01			/* set for resistances */
#define SPICEPLOT          02			/* set for plots (vs prints) */
#define SPICENODENAMES    010			/* set for node names (vs numbers) */
#define SPICETYPE         060			/* mask for spice type */
#define SPICE2            000			/*   spice 2 */
#define SPICE3            020			/*   spice 3 */
#define SPICEHSPICE       040			/*   hspice  */
#define SPICEPSPICE       060			/*   pspice  */
#define SPICERAWFILE     0100			/* set to read rawfile */
#define SPICEGLOBALPG    0200			/* set to use global power and ground */
#define SPICEFACETPARAM 01000			/* set to use facet parameters */

extern INTBIG sim_spice_levelkey;		/* key for "SIM_spice_level" */
extern INTBIG sim_spice_statekey;		/* key for "SIM_spice_state" */
extern INTBIG sim_spice_state;			/* value of "SIM_spice_state" */
extern INTBIG sim_spice_listingfilekey;	/* key for "SIM_listingfile" */
extern INTBIG sim_spice_runargskey;		/* key for "SIM_spice_runarguments" */

/********************* for FASTHENRY *********************/

/* the meaning of "tool:sim.SIM_fasthenry_state" */
#define FHUSESINGLEFREQ       01			/* use single frequency */
#define FHMAKEMULTIPOLECKT    02			/* make multipole circuit */
#define FHMAKEPOSTSCRIPTVIEW  04			/* make PostScript view */
#define FHMAKESPICESUBCKT    010			/* make SPICE subcircuit */
#define FHEXECUTETYPE       0160			/* what to do after writing the deck */
#define FHEXECUTENONE          0			/*    no simulator run */
#define FHEXECUTERUNFH       020			/*    run fasthenry */
#define FHEXECUTERUNFHMUL    040			/*    run fasthenry for every group */

extern INTBIG sim_fasthenrystatekey;		/* variable key for "SIM_fasthenry_state" */
extern INTBIG sim_fasthenryfreqstartkey;	/* variable key for "SIM_fasthenry_freqstart" */
extern INTBIG sim_fasthenryfreqendkey;		/* variable key for "SIM_fasthenry_freqend" */
extern INTBIG sim_fasthenryrunsperdecadekey;/* variable key for "SIM_fasthenry_runsperdecade" */
extern INTBIG sim_fasthenrynumpoleskey;		/* variable key for "SIM_fasthenry_numpoles" */
extern INTBIG sim_fasthenryseglimitkey;		/* variable key for "SIM_fasthenry_seglimit" */
extern INTBIG sim_fasthenrythicknesskey;	/* variable key for "SIM_fasthenry_thickness" */
extern INTBIG sim_fasthenrywidthsubdivkey;	/* variable key for "SIM_fasthenry_width_subdivs" */
extern INTBIG sim_fasthenryheightsubdivkey;	/* variable key for "SIM_fasthenry_height_subdivs" */
extern INTBIG sim_fasthenryzheadkey;		/* variable key for "SIM_fasthenry_z_head" */
extern INTBIG sim_fasthenryztailkey;		/* variable key for "SIM_fasthenry_z_tail" */
extern INTBIG sim_fasthenrygroupnamekey;	/* variable key for "SIM_fasthenry_group_name" */

/* prototypes for tool interface */
void        sim_init(INTBIG*, char*[], TOOL*);
void        sim_done(void);
void        sim_set(INTBIG, char*[]);
void        sim_slice(void);
void        sim_startbatch(TOOL*, BOOLEAN);
void        sim_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void        sim_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void        sim_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void        sim_newobject(INTBIG, INTBIG);
void        sim_killobject(INTBIG, INTBIG);
void        sim_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void        sim_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, UINTBIG*);
void        sim_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void        sim_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void        sim_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void        sim_readlibrary(LIBRARY*);

/* prototypes for intratool interface */
void        sim_freespicememory(void);
void        sim_freespicerun_memory(void);
void        sim_freeirsimmemory(void);
void        sim_freeverilogmemory(void);
void        sim_spice_xprintf(FILE*, BOOLEAN, char*, ...);
NETWORK    *sim_spice_networkfromname(char *name);
char       *sim_spice_signalname(NETWORK *net);
void        sim_simpointout(char*, INTBIG);
void        sim_spice_execute(char*, char*, NODEPROTO*);
void        sim_writefasthenrynetlist(NODEPROTO*);
void        sim_fasthenryinit(void);
void        sim_writesim(NODEPROTO*, INTBIG);
void        sim_writeirsim(NODEPROTO*);
void        sim_writepalnetlist(NODEPROTO*);
void        sim_writemossim(NODEPROTO*);
void        sim_writetexnetlist(NODEPROTO*);
void        sim_writespice(NODEPROTO*, BOOLEAN);
void        sim_writevernetlist(NODEPROTO*);
void        sim_writesilnetlist(NODEPROTO*);
void        sim_resumesim(BOOLEAN);
INTBIG      sim_alsclockdlog(char *paramstart[]);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
