/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.IvanFlater;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.user.User;
import java.net.URL;
import java.util.Properties;

public class IvanFlat
extends Job {
    private static void error(boolean pred, String msg) {
        if (pred) {
            throw new RuntimeException(msg);
        }
    }

    private boolean osIsWindows() {
        Properties props = System.getProperties();
        String osName = ((String)props.get("os.name")).toLowerCase();
        return osName.indexOf("windows") != -1;
    }

    private static String userName() {
        Properties props = System.getProperties();
        return (String)props.get("user.name");
    }

    private Library openLibForRead(String libNm, String libFileNm) {
        Library lib = Library.findLibrary(libNm);
        if (lib == null) {
            URL libFileURL = TextUtils.makeURLToFile(libFileNm);
            Input.readLibrary(libFileURL, FileType.ELIB);
            lib = Library.findLibrary(libNm);
        }
        IvanFlat.error(lib == null, "can't open Library for reading: " + libFileNm);
        return lib;
    }

    private void openSpiceParts(String libDir) {
        String spNm = "spiceparts";
        Library lib = this.openLibForRead(spNm, libDir + spNm + ".elib");
    }

    private Cell openCell(String libDir, String libNm, String cellNm) {
        this.openSpiceParts(libDir);
        Library lib = this.openLibForRead(libNm, libDir + libNm + ".elib");
        Cell cell = lib.findNodeProto(cellNm);
        IvanFlat.error(cell == null, "can't find cell: " + cellNm);
        return cell;
    }

    private String getKaoHomeDir() {
        boolean nfsWedged = false;
        if (this.osIsWindows()) {
            if (nfsWedged) {
                return "c:/a1/kao/Sun/";
            }
            return "x:/";
        }
        return "/home/rkao/";
    }

    private Cell getTestCell(String homeDir) {
        Cell cell = null;
        Object libDir = null;
        return cell;
    }

    private String outFileName(String cellNm) {
        int openBrace = cellNm.indexOf("{");
        String fileNm = openBrace >= 0 ? cellNm.substring(0, openBrace) : cellNm;
        fileNm = fileNm + ".flat";
        return fileNm;
    }

    private void flattenOneCell(String outFileDir, String libDir, CellDescription cellDesc) {
        System.out.println("processing: " + cellDesc.libName + " : " + cellDesc.cellName);
        Cell cell = this.openCell(libDir, cellDesc.libName, cellDesc.cellName);
        Netlist netlist = cell.getNetlist(false);
        String cellNm = cell.getName();
        String outFileNm = outFileDir + this.outFileName(cellNm);
        IvanFlater flattener = new IvanFlater(outFileNm);
        long startTime = System.currentTimeMillis();
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, netlist, flattener);
        long endTime = System.currentTimeMillis();
        double deltaTime = (double)(endTime - startTime) / 1000.0;
        System.out.println("Flattening took " + deltaTime + " seconds");
        System.out.flush();
        flattener.close();
    }

    public boolean doIt() {
        System.out.println("Begin IvanFlat");
        String homeDir = this.getKaoHomeDir();
        String outFileDir = homeDir + "ivanTest/qFourP1/";
        String libDir = homeDir + "ivanTest/qFourP1/electric-final/";
        CellDescription[] cellDescrs = new CellDescription[]{new CellDescription("stages", "stagePairJac{lay}"), new CellDescription("rxPads", "equilibrate{lay}"), new CellDescription("rxPads", "rxPadArray2{lay}"), new CellDescription("rxPads", "rxGroup{lay}"), new CellDescription("qFourP1", "expArings{lay}"), new CellDescription("qFourP1", "expTail{lay}")};
        for (int i = 0; i < cellDescrs.length; ++i) {
            this.flattenOneCell(outFileDir, libDir, cellDescrs[i]);
        }
        System.out.println("Done");
        return true;
    }

    public IvanFlat() {
        super("Flatten Netlists for Ivan", User.tool, Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.startJob();
    }

    private static class CellDescription {
        final String libName;
        final String cellName;

        CellDescription(String libNm, String cellNm) {
            this.libName = libNm;
            this.cellName = cellNm;
        }
    }
}

