/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.StratAdjacent;
import com.sun.electric.tool.ncc.strategy.StratCount;
import com.sun.electric.tool.ncc.strategy.StratHashParts;
import com.sun.electric.tool.ncc.strategy.StratHashWires;
import com.sun.electric.tool.ncc.strategy.StratPortName;
import com.sun.electric.tool.ncc.strategy.StratRandomMatch;
import com.sun.electric.tool.ncc.strategy.StratResult;
import com.sun.electric.tool.ncc.strategy.StratSizes;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Date;
import java.util.Iterator;

public class HashCodePartitioning {
    NccGlobals globals;

    private void error(boolean pred, String msg) {
        this.globals.error(msg);
    }

    private LeafList hashFrontierParts() {
        if (this.globals.getParts() == null) {
            return new LeafList();
        }
        this.globals.status2("----- hash all Parts on frontier");
        Iterator frontier = this.globals.getPartLeafEquivRecs().getUnmatched();
        LeafList offspring = StratHashParts.doYourJob(frontier, this.globals);
        return offspring;
    }

    private LeafList hashFrontierWires() {
        if (this.globals.getParts() == null) {
            return new LeafList();
        }
        this.globals.status2("----- hash all Wires on frontier");
        Iterator frontier = this.globals.getWireLeafEquivRecs().getUnmatched();
        LeafList offspring = StratHashWires.doYourJob(frontier, this.globals);
        return offspring;
    }

    private boolean isPartsList(LeafList el) {
        EquivRecord er = el.get(0);
        return er.getNetObjType() == NetObject.Type.PART;
    }

    private void chaseMatched(LeafList newDivided) {
        if (newDivided.size() == 0) {
            return;
        }
        this.globals.status2("------ starting chaseMatched");
        int i = 0;
        while (newDivided.size() != 0) {
            LeafList adjacent;
            this.globals.status2("------ chaseMatched pass: " + i++);
            LeafList newMatches = newDivided.selectMatched(this.globals);
            if (newMatches.size() == 0 || (adjacent = StratAdjacent.doYourJob(newMatches, this.globals)).size() == 0) break;
            boolean doParts = this.isPartsList(adjacent);
            newDivided = doParts ? StratHashParts.doYourJob(adjacent.iterator(), this.globals) : StratHashWires.doYourJob(adjacent.iterator(), this.globals);
        }
        this.globals.status2("------ done  chaseMatched after " + i + " passes");
        this.globals.status2("");
    }

    private void hashFrontier() {
        LeafList wireOffspring;
        LeafList partOffspring;
        this.globals.status2("----- hash all NetObjects on frontier");
        do {
            partOffspring = this.hashFrontierParts();
            this.chaseMatched(partOffspring);
            wireOffspring = this.hashFrontierWires();
            this.chaseMatched(wireOffspring);
        } while (partOffspring.size() != 0 || wireOffspring.size() != 0);
    }

    private boolean done() {
        return this.globals.getWireLeafEquivRecs().numUnmatched() == 0 && this.globals.getPartLeafEquivRecs().numUnmatched() == 0;
    }

    private void useExportNames() {
        this.globals.status2("----- use Export Names");
        while (true) {
            StratCount.doYourJob(this.globals);
            LeafList offspring = StratPortName.doYourJob(this.globals);
            if (offspring.size() == 0) break;
            this.chaseMatched(offspring);
            this.hashFrontier();
        }
    }

    private void useTransistorSizes() {
        LeafList offspring;
        this.globals.status2("----- use transistor sizes");
        while ((offspring = StratSizes.doYourJob(this.globals)).size() != 0) {
            this.chaseMatched(offspring);
            this.hashFrontier();
        }
    }

    private void randomMatch() {
        LeafList offspring;
        this.globals.status2("----- random matching");
        while ((offspring = StratRandomMatch.doYourJob(this.globals)).size() != 0) {
            this.chaseMatched(offspring);
            this.hashFrontier();
        }
    }

    private void doWork() {
        if (this.done()) {
            return;
        }
        Date d1 = new Date();
        this.hashFrontier();
        Date d2 = new Date();
        this.globals.status1("  Hashing frontier took: " + NccUtils.hourMinSec(d1, d2));
        if (this.done()) {
            return;
        }
        this.useExportNames();
        Date d3 = new Date();
        this.globals.status1("  Using export names took: " + NccUtils.hourMinSec(d2, d3));
        if (this.done()) {
            return;
        }
        this.useTransistorSizes();
        Date d4 = new Date();
        this.globals.status1("  Using transistor sizes took: " + NccUtils.hourMinSec(d3, d4));
        if (this.done()) {
            return;
        }
        this.randomMatch();
        Date d5 = new Date();
        this.globals.status1("  Random match took: " + NccUtils.hourMinSec(d4, d5));
    }

    private HashCodePartitioning(NccGlobals globals) {
        this.globals = globals;
        globals.status2("----- starting HashCodePartitioning");
        this.doWork();
        globals.status2("----- done HashCodePartitioning");
    }

    public static boolean doYourJob(NccGlobals globals) {
        new HashCodePartitioning(globals);
        return StratResult.doYourJob(globals);
    }
}

