/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.parasitic;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ParasiticTool
extends Tool {
    private static ParasiticTool tool = new ParasiticTool();
    private static Pref cacheMaxDistance = Pref.makeDoublePref("MaximumDistance", ParasiticTool.tool.prefs, 20.0);

    private ParasiticTool() {
        super("Parasitic");
    }

    public void init() {
    }

    public static ParasiticTool getParasiticTool() {
        return tool;
    }

    public void netwokParasitic(Network network, Cell cell) {
        AnalyzeParasitic job = new AnalyzeParasitic(network, cell);
    }

    public static double getMaxDistance() {
        return cacheMaxDistance.getDouble();
    }

    public static void setMaxDistance(double value) {
        cacheMaxDistance.setDouble(value);
    }

    protected static class AnalyzeParasitic
    extends Job {
        Cell cell;
        Network net;

        protected AnalyzeParasitic(Network network, Cell cell) {
            super("Analyze Network " + network.describe(), tool, Job.Type.EXAMINE, null, cell, Job.Priority.USER);
            this.net = network;
            this.cell = cell;
            this.startJob();
        }

        private List getClosestPolys(Cell cell, Geometric geom, Technology tech, Poly poly, Rectangle2D bounds) {
            ArrayList polyList = new ArrayList();
            Iterator it = cell.searchIterator(bounds);
            while (it.hasNext()) {
                Geometric nGeom = (Geometric)it.next();
                if (nGeom == geom || Geometric.objectsTouch(nGeom, geom)) continue;
                if (nGeom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)nGeom;
                    NodeProto np = ni.getProto();
                    if (np == Generic.tech.cellCenterNode || np.getFunction() == PrimitiveNode.Function.PIN || np.getTechnology() != tech) continue;
                    if (np instanceof Cell) {
                        System.out.println("Skipping case for now");
                        continue;
                    }
                    System.out.println("Found node " + nGeom + " for " + geom);
                    AffineTransform trans = ni.rotateOut();
                    Poly[] nodeInstPolyList = tech.getShapeOfNode(ni);
                    for (int i = 0; i < nodeInstPolyList.length; ++i) {
                        Poly nPoly = nodeInstPolyList[i];
                        Layer layer = nPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        nPoly.transform(trans);
                        polyList.addAll(ParasiticValue.initParasiticValues(poly, nPoly));
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)nGeom;
                ArcProto ap = ai.getProto();
                if (ap.getTechnology() != tech) continue;
                System.out.println("Found arc " + nGeom + " for " + geom);
                Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcInstPolyList.length; ++i) {
                    Poly nPoly = arcInstPolyList[i];
                    Layer layer = nPoly.getLayer();
                    if (!layer.getFunction().isMetal()) continue;
                    nPoly = ai.cropPerLayer(nPoly);
                    polyList.addAll(ParasiticValue.initParasiticValues(poly, nPoly));
                }
            }
            return polyList;
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            System.out.println("Extracting Parasitic for '" + this.cell.libDescribe() + "' network '" + this.net.describe() + "'");
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            double maxDistance = ParasiticTool.getMaxDistance();
            ArrayList polyToCheckList = new ArrayList();
            Iterator it = this.net.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcInstPolyList.length; ++i) {
                    Poly poly = arcInstPolyList[i];
                    Layer layer = poly.getLayer();
                    if (!layer.getFunction().isMetal()) continue;
                    poly = ai.cropPerLayer(poly);
                    Rectangle2D bnd = poly.getBounds2D();
                    ((Rectangle2D)bounds).setRect(bnd.getMinX() - maxDistance, bnd.getMinY() - maxDistance, bnd.getWidth() + maxDistance * 2.0, bnd.getHeight() + maxDistance * 2.0);
                    polyToCheckList.addAll(this.getClosestPolys(this.cell, ai, tech, poly, bounds));
                }
            }
            HashMap<NodeInst, NodeInst> nodeMap = new HashMap<NodeInst, NodeInst>();
            Iterator it2 = this.net.getPorts();
            while (it2.hasNext()) {
                PortInst pi = (PortInst)it2.next();
                NodeInst ni = pi.getNodeInst();
                if (nodeMap.get(ni) != null) continue;
                AffineTransform trans = ni.rotateOut();
                NodeProto np = ni.getProto();
                nodeMap.put(ni, ni);
                if (np instanceof PrimitiveNode) {
                    PrimitiveNode pNp = (PrimitiveNode)np;
                    Technology tech = pNp.getTechnology();
                    Poly[] nodeInstPolyList = tech.getShapeOfNode(ni);
                    for (int i = 0; i < nodeInstPolyList.length; ++i) {
                        Poly poly = nodeInstPolyList[i];
                        Layer layer = poly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        poly.transform(trans);
                        Rectangle2D bnd = poly.getBounds2D();
                        ((Rectangle2D)bounds).setRect(bnd.getMinX() - maxDistance, bnd.getMinY() - maxDistance, bnd.getWidth() + maxDistance * 2.0, bnd.getHeight() + maxDistance * 2.0);
                        polyToCheckList.addAll(this.getClosestPolys(this.cell, ni, tech, poly, bounds));
                    }
                    continue;
                }
                System.out.println("Not implemented");
            }
            it2 = polyToCheckList.iterator();
            while (it2.hasNext()) {
                ParasiticValue val = (ParasiticValue)it2.next();
                System.out.println("Value " + val + " Layer " + ((ParasiticValue)val).elements[1].poly.getLayer());
            }
            long endTime = System.currentTimeMillis();
            System.out.println("Done (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    public static class ParasiticValue {
        private ParasiticBucket[] elements = new ParasiticBucket[2];
        private boolean angle;
        private double distance = -1.0;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < 2; ++i) {
                buf.append("Poly " + i + ":" + this.elements[i].poly.getBounds2D() + "(area=" + this.elements[i].area + ", length=" + this.elements[i].length + ") ");
            }
            return buf.toString();
        }

        public static List initParasiticValues(Poly p1, Poly p2) {
            Rectangle2D thisBounds = p1.getBox();
            Rectangle2D otherBounds = p2.getBox();
            ArrayList<ParasiticValue> values = new ArrayList<ParasiticValue>();
            if (thisBounds == null || otherBounds == null) {
                return null;
            }
            int dir = -1;
            double[][] points1 = new double[][]{{thisBounds.getMinX(), thisBounds.getMinY()}, {thisBounds.getMaxX(), thisBounds.getMaxY()}};
            double[][] points2 = new double[][]{{otherBounds.getMinX(), otherBounds.getMinY()}, {otherBounds.getMaxX(), otherBounds.getMaxY()}};
            double pdx = Math.max(points2[0][0] - points1[1][0], points1[0][0] - points2[1][0]);
            double pdy = Math.max(points2[0][1] - points1[1][1], points1[0][1] - points2[1][1]);
            double area1 = 0.0;
            double area2 = 0.0;
            double over1 = 0.0;
            double over2 = 0.0;
            double length1 = 0.0;
            double length2 = 0.0;
            double thickP1 = p1.getLayer().getThickness();
            double thickP2 = p1.getLayer().getThickness();
            thickP2 = 1.0;
            thickP1 = 1.0;
            if (pdx > 0.0 && pdy > 0.0) {
                ParasiticValue newValue1 = new ParasiticValue();
                ParasiticValue newValue2 = new ParasiticValue();
                newValue1.distance = newValue2.distance = Math.sqrt(pdx * pdx + pdy * pdy);
                newValue2.angle = true;
                newValue1.angle = true;
                length1 = p1.getBox().getWidth();
                length2 = p2.getBox().getHeight();
                area1 = thickP1 * p1.getBox().getHeight();
                area2 = thickP2 * p2.getBox().getWidth();
                newValue1.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue1.elements[1] = new ParasiticBucket(p2, area2, length2);
                length1 = p1.getBox().getHeight();
                length2 = p2.getBox().getWidth();
                area1 = thickP1 * p1.getBox().getWidth();
                area2 = thickP2 * p2.getBox().getHeight();
                newValue2.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue2.elements[1] = new ParasiticBucket(p2, area2, length2);
                values.add(newValue1);
                values.add(newValue2);
            } else {
                if (pdx == 0.0 || pdy == 0.0) {
                    System.out.println("How do I treat this?");
                }
                ParasiticValue newValue = new ParasiticValue();
                newValue.angle = false;
                if (pdx > pdy) {
                    dir = 0;
                    newValue.distance = pdx;
                    length1 = p1.getBox().getWidth();
                    length2 = p2.getBox().getWidth();
                } else {
                    dir = 1;
                    newValue.distance = pdy;
                    length1 = p1.getBox().getHeight();
                    length2 = p2.getBox().getHeight();
                }
                int oppDir = (dir + 1) % 2;
                over1 = over2 = Math.min(points1[1][oppDir], points2[1][oppDir]) - Math.max(points1[0][oppDir], points2[0][oppDir]);
                area1 = thickP1 * over1;
                area2 = thickP2 * over2;
                newValue.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue.elements[1] = new ParasiticBucket(p2, area2, length2);
                values.add(newValue);
            }
            return values;
        }
    }

    private static class ParasiticBucket {
        public Poly poly;
        public double area;
        public double length;

        protected ParasiticBucket(Poly p, double a, double l) {
            this.poly = p;
            this.area = a;
            this.length = l;
        }
    }
}

