/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AutoStitch {
    private static ArcProto preferredArc;
    private static InteractiveRouter router;
    private static List allRoutes;
    private static List possibleInlinePins;
    private static HashSet nodeMark;

    public static void autoStitch(boolean highlighted, boolean forced) {
        AutoStitchJob job = new AutoStitchJob(highlighted, forced);
    }

    public static void runAutoStitch(boolean highlighted, boolean forced) {
        ArcProto curAp;
        NodeInst ni;
        ArrayList nodesToStitch = new ArrayList();
        if (highlighted) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            List highs = wnd.getHighlighter().getHighlightedEObjs(true, false);
            Iterator it = highs.iterator();
            while (it.hasNext()) {
                nodesToStitch.add(it.next());
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni2 = (NodeInst)it.next();
                if (ni2.isIconOfParent()) continue;
                nodesToStitch.add(ni2);
            }
        }
        if (nodesToStitch.size() == 0) {
            if (forced) {
                System.out.println("No ports or nodes selected to auto-route");
            }
            return;
        }
        allRoutes = new ArrayList();
        possibleInlinePins = new ArrayList();
        HashSet<Cell> cellMark = new HashSet<Cell>();
        nodeMark = new HashSet();
        int count = 0;
        HashMap<NodeInst, double[]> nodeBounds = new HashMap<NodeInst, double[]>();
        Iterator it = nodesToStitch.iterator();
        while (it.hasNext()) {
            NodeInst nodeToStitch = (NodeInst)it.next();
            Cell parent = nodeToStitch.getParent();
            if (cellMark.contains(parent)) continue;
            cellMark.add(parent);
            Iterator nIt = parent.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                nodeMark.remove(ni);
                int total = ni.getProto().getNumPorts();
                double[] bbArray = new double[total * 4];
                nodeBounds.put(ni, bbArray);
                int i = 0;
                Iterator pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    PortOriginal fp = new PortOriginal(ni, pp);
                    AffineTransform trans = fp.getTransformToTop();
                    NodeInst rNi = fp.getBottomNodeInst();
                    Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                    DBMath.transformRect(bounds, trans);
                    bbArray[i++] = bounds.getMinX();
                    bbArray[i++] = bounds.getMaxX();
                    bbArray[i++] = bounds.getMinY();
                    bbArray[i++] = bounds.getMaxY();
                }
            }
        }
        it = nodesToStitch.iterator();
        while (it.hasNext()) {
            NodeInst ni3 = (NodeInst)it.next();
            nodeMark.add(ni3);
        }
        preferredArc = null;
        String preferredName = Routing.getPreferredRoutingArc();
        if (preferredName.length() > 0) {
            preferredArc = ArcProto.findArcProto(preferredName);
        }
        if (preferredArc == null && (curAp = User.tool.getCurrentArcProto()) != null) {
            preferredArc = curAp;
        }
        HashMap arcLayers = new HashMap();
        HashMap arcCount = new HashMap();
        Iterator it2 = nodesToStitch.iterator();
        while (it2.hasNext()) {
            ni = (NodeInst)it2.next();
            if (ni.getParent().isAllLocked()) continue;
            count += AutoStitch.checkStitching(ni, arcCount, nodeBounds, arcLayers);
        }
        if (count != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("AUTO ROUTING: added ");
            boolean first = true;
            Iterator it3 = arcCount.keySet().iterator();
            while (it3.hasNext()) {
                ArcProto ap = (ArcProto)it3.next();
                if (!first) {
                    buf.append("; ");
                }
                Integer c = (Integer)arcCount.get(ap);
                buf.append(c + " " + ap.describe() + " wires");
                first = false;
            }
            System.out.println(buf.toString());
        } else if (forced) {
            System.out.println("No arcs added");
        }
        it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (cellMark.contains(cell)) continue;
            }
        }
        cellMark = null;
        nodeMark = null;
        it2 = allRoutes.iterator();
        while (it2.hasNext()) {
            Route route = (Route)it2.next();
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            Router.createRouteNoJob(route, c, false, false, null);
        }
        ArrayList<CircuitChanges.Reconnect> pinsToPassThrough = new ArrayList<CircuitChanges.Reconnect>();
        Cell cell = null;
        Iterator it4 = possibleInlinePins.iterator();
        while (it4.hasNext()) {
            CircuitChanges.Reconnect re;
            NodeInst ni4 = (NodeInst)it4.next();
            cell = ni4.getParent();
            if (!ni4.isInlinePin() || (re = CircuitChanges.Reconnect.erasePassThru(ni4, false)) == null) continue;
            pinsToPassThrough.add(re);
        }
        if (pinsToPassThrough.size() > 0 && cell != null) {
            CircuitChanges.CleanupChanges job = new CircuitChanges.CleanupChanges(cell, true, new ArrayList(), pinsToPassThrough, new HashMap(), new ArrayList(), new HashMap(), 0, 0, 0);
            job.doIt();
        }
    }

    private static int checkStitching(NodeInst ni, HashMap arcCount, HashMap nodeBounds, HashMap arcLayers) {
        Cell cell = ni.getParent();
        Netlist netlist = cell.getUserNetlist();
        double[] boundArray = (double[])nodeBounds.get(ni);
        ArrayList<Geometric> nodesInArea = new ArrayList<Geometric>();
        Iterator it = cell.searchIterator(ni.getBounds());
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst)) continue;
            nodesInArea.add(geom);
        }
        int count = 0;
        Iterator it2 = nodesInArea.iterator();
        block1: while (it2.hasNext()) {
            Integer c;
            Layer oLayer;
            NodeInst oNi = (NodeInst)it2.next();
            if (nodeMark.contains(oNi) && oNi.getNodeIndex() <= ni.getNodeIndex()) continue;
            Rectangle2D oBounds = oNi.getBounds();
            if (ni.getProto() instanceof Cell) {
                int bbp = 0;
                Iterator pIt = ni.getProto().getPorts();
                block2: while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    if (boundArray != null) {
                        double lX = boundArray[bbp++];
                        double hX = boundArray[bbp++];
                        double lY = boundArray[bbp++];
                        double hY = boundArray[bbp++];
                        if (lX > oBounds.getMaxX() || hX < oBounds.getMinX() || lY > oBounds.getMaxY() || hY < oBounds.getMinY()) continue;
                    }
                    AffineTransform trans = ni.rotateOut();
                    NodeInst rNi = ni;
                    PortProto rPp = pp;
                    while (rNi.getProto() instanceof Cell) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    ArcProto[] connections = pp.getBasePort().getConnections();
                    for (int i = 0; i < connections.length; ++i) {
                        AutoStitch.findSmallestLayer(connections[i], arcLayers);
                    }
                    boolean usePortPoly = false;
                    Technology tech = rNi.getProto().getTechnology();
                    Poly[] nodePolys = tech.getShapeOfNode(rNi, null, true, true, null);
                    int tot = nodePolys.length;
                    if (tot == 0 || rNi.getProto() == Generic.tech.simProbeNode) {
                        usePortPoly = true;
                        tot = 1;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Layer layer = null;
                        Poly poly = null;
                        if (usePortPoly) {
                            poly = ni.getShapeOfPort(pp);
                            layer = poly.getLayer();
                        } else {
                            poly = nodePolys[j];
                            if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                            poly.transform(trans);
                            layer = poly.getLayer();
                            if (layer != null) {
                                layer = layer.getNonPseudoLayer();
                            }
                        }
                        boolean connected = false;
                        for (int pass = 0; pass < 2; ++pass) {
                            for (int i = 0; i < connections.length; ++i) {
                                ArcProto ap = connections[i];
                                if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                                if (!usePortPoly && !tech.sameLayer(oLayer = (Layer)arcLayers.get(ap), layer) || !(connected = AutoStitch.testPoly(ni, pp, ap, poly, oNi, netlist, nodeBounds, arcLayers))) continue;
                                c = (Integer)arcCount.get(ap);
                                if (c == null) {
                                    c = new Integer(0);
                                }
                                c = new Integer(c + 1);
                                arcCount.put(ap, c);
                                ++count;
                                break;
                            }
                            if (connected) break;
                        }
                        if (connected) continue block2;
                    }
                }
                continue;
            }
            AffineTransform trans = ni.rotateOut();
            double oX = oNi.getAnchorCenterX();
            double oY = oNi.getAnchorCenterY();
            boolean usePortPoly = false;
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni, null, true, true, null);
            int tot = polys.length;
            if (tot == 0 || ni.getProto() == Generic.tech.simProbeNode) {
                usePortPoly = true;
                tot = 1;
            }
            for (int j = 0; j < tot; ++j) {
                double dist;
                double y;
                Iterator pIt;
                double bestDist;
                PortProto bestPp;
                PortProto rPp = null;
                Poly polyPtr = null;
                if (usePortPoly) {
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = (PortProto)pIt.next();
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                            bestPp = tPp;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr = ni.getShapeOfPort(rPp);
                } else {
                    polyPtr = polys[j];
                    if (polyPtr.getPort() == null) continue;
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = (PortProto)pIt.next();
                        if (!netlist.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr.transform(trans);
                }
                Layer layer = polyPtr.getLayer();
                if (layer != null) {
                    layer = layer.getNonPseudoLayer();
                }
                boolean found = false;
                Iterator cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    PortInst pi = con.getPortInst();
                    if (!netlist.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHead().getPortInst().getNodeInst() != oNi && con.getArc().getTail().getPortInst().getNodeInst() != oNi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean connected = false;
                ArcProto[] connections = rPp.getBasePort().getConnections();
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < connections.length; ++i) {
                        ArcProto ap = connections[i];
                        if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                        if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                        AutoStitch.findSmallestLayer(ap, arcLayers);
                        if (!usePortPoly) {
                            oLayer = (Layer)arcLayers.get(ap);
                            if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                        }
                        if (!(connected = AutoStitch.testPoly(ni, rPp, ap, polyPtr, oNi, netlist, nodeBounds, arcLayers))) continue;
                        c = (Integer)arcCount.get(ap);
                        if (c == null) {
                            c = new Integer(0);
                        }
                        c = new Integer(c + 1);
                        arcCount.put(ap, c);
                        ++count;
                        break;
                    }
                    if (connected) break;
                }
                if (connected) continue block1;
            }
        }
        return count;
    }

    private static boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, Netlist netlist, HashMap nodeBounds, HashMap arcLayers) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Network net = netlist.getNetwork(pi);
        if (oNi.getProto() instanceof Cell) {
            double[] boundArray = (double[])nodeBounds.get(oNi);
            int bbp = 0;
            Rectangle2D bounds = poly.getBounds2D();
            Iterator it = oNi.getProto().getPorts();
            while (it.hasNext()) {
                PortProto mPp = (PortProto)it.next();
                if (boundArray != null) {
                    double lX = boundArray[bbp++];
                    double hX = boundArray[bbp++];
                    double lY = boundArray[bbp++];
                    double hY = boundArray[bbp++];
                    if (lX > bounds.getMaxX() || hX < bounds.getMinX() || lY > bounds.getMaxY() || hY < bounds.getMinY()) continue;
                }
                if (!mPp.getBasePort().connectsTo(ap)) continue;
                PortInst oPi = oNi.findPortInstFromProto(mPp);
                boolean ignore = false;
                Iterator piit = oPi.getConnections();
                while (piit.hasNext()) {
                    Connection conn = (Connection)piit.next();
                    ArcInst ai = conn.getArc();
                    if (ai.getHead().getPortInst() == pi) {
                        ignore = true;
                    }
                    if (ai.getTail().getPortInst() != pi) continue;
                    ignore = true;
                }
                if (ignore) continue;
                AffineTransform trans = oNi.rotateOut();
                NodeInst rNi = oNi;
                PortProto rPp = mPp;
                while (rNi.getProto() instanceof Cell) {
                    AffineTransform temp = rNi.translateOut();
                    temp.preConcatenate(trans);
                    Export e = (Export)rPp;
                    rNi = e.getOriginalPort().getNodeInst();
                    rPp = e.getOriginalPort().getPortProto();
                    trans = rNi.rotateOut();
                    trans.preConcatenate(temp);
                }
                Technology tech = rNi.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(rNi, null, true, true, null);
                int tot = polys.length;
                if (tot == 0) {
                    Poly oPoly = oNi.getShapeOfPort(mPp);
                    if (!AutoStitch.comparePoly(oNi, mPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                    return true;
                }
                Netlist subNetlist = rNi.getParent().getUserNetlist();
                for (int j = 0; j < tot; ++j) {
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                    if (ni.getProto() != Generic.tech.simProbeNode) {
                        Layer apLayer;
                        Layer oLayer = oPoly.getLayer();
                        if (oLayer != null) {
                            oLayer = oLayer.getNonPseudoLayer();
                        }
                        if (!tech.sameLayer(oLayer, apLayer = (Layer)arcLayers.get(ap))) continue;
                    }
                    oPoly.transform(trans);
                    if (!AutoStitch.comparePoly(oNi, mPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                    return true;
                }
            }
        } else {
            AffineTransform trans = oNi.rotateOut();
            double ox = poly.getCenterX();
            double oy = poly.getCenterY();
            Technology tech = oNi.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(oNi, null, true, true, null);
            int tot = polys.length;
            if (tot == 0) {
                Poly oPoly;
                PortProto rPp;
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator pIt = oNi.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto rPp2 = (PortProto)pIt.next();
                    Poly portPoly = oNi.getShapeOfPort(rPp2);
                    double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                    if (bestPp == null) {
                        bestDist = dist;
                        bestPp = rPp2;
                    }
                    if (dist > bestDist) continue;
                    bestPp = rPp2;
                    bestDist = dist;
                }
                if (bestPp != null && (rPp = bestPp).getBasePort().connectsTo(ap) && AutoStitch.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), ni, pp, poly, ap, netlist)) {
                    return true;
                }
            } else {
                for (int j = 0; j < tot; ++j) {
                    PortProto rPp;
                    Layer apLayer;
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null) continue;
                    Layer oLayer = oPoly.getLayer();
                    if (oLayer != null) {
                        oLayer = oLayer.getNonPseudoLayer();
                    }
                    if (!tech.sameLayer(apLayer = (Layer)arcLayers.get(ap), oLayer)) continue;
                    PortInst oPi = oNi.findPortInstFromProto(oPoly.getPort());
                    Network oNet = netlist.getNetwork(oPi);
                    if (net != null && oNet == net) continue;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp3 = (PortProto)pIt.next();
                        if (!netlist.portsConnected(oNi, rPp3, oPoly.getPort())) continue;
                        Poly portPoly = oNi.getShapeOfPort(rPp3);
                        double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp3;
                        bestDist = dist;
                    }
                    if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                    oPoly.transform(trans);
                    if (!AutoStitch.comparePoly(oNi, rPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, NodeInst ni, PortProto pp, Poly poly, ArcProto ap, Netlist netlist) {
        Point2D.Double tPortCenter;
        double tDist;
        PortProto tPp;
        Rectangle2D polyBounds = poly.getBounds2D();
        Rectangle2D oPolyBounds = oPoly.getBounds2D();
        if (polyBounds.getMinX() > oPolyBounds.getMaxX() || oPolyBounds.getMinX() > polyBounds.getMaxX() || polyBounds.getMinY() > oPolyBounds.getMaxY() || oPolyBounds.getMinY() > polyBounds.getMaxY()) {
            return false;
        }
        Poly portPoly = ni.getShapeOfPort(pp);
        Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        portPoly = oNi.getShapeOfPort(opp);
        Point2D.Double oPortCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        double dist = portCenter.distance(oPortCenter);
        Iterator it = oNi.getProto().getPorts();
        while (it.hasNext()) {
            tPp = (PortProto)it.next();
            if (tPp == opp || !netlist.portsConnected(oNi, tPp, opp) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            opp = tPp;
            oPortCenter.setLocation(tPortCenter);
        }
        it = ni.getProto().getPorts();
        while (it.hasNext()) {
            tPp = (PortProto)it.next();
            if (tPp == pp || !netlist.portsConnected(ni, tPp, pp) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            pp = tPp;
            portCenter.setLocation(tPortCenter);
        }
        double x = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
        double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
        PortInst pi = ni.findPortInstFromProto(pp);
        PortInst opi = oNi.findPortInstFromProto(opp);
        Route route = router.planRoute(ni.getParent(), pi, opi, new Point2D.Double(x, y));
        if (route.size() == 0) {
            return false;
        }
        allRoutes.add(route);
        if (ni.getFunction() == PrimitiveNode.Function.PIN && ni.getNumExports() == 0 && ni.getNumConnections() == 0 && !possibleInlinePins.contains(ni)) {
            possibleInlinePins.add(ni);
        }
        if (oNi.getFunction() == PrimitiveNode.Function.PIN && oNi.getNumExports() == 0 && oNi.getNumConnections() == 0 && !possibleInlinePins.contains(oNi)) {
            possibleInlinePins.add(oNi);
        }
        return true;
    }

    public static void findSmallestLayer(ArcProto ap, HashMap arcLayers) {
        if (arcLayers.get(ap) != null) {
            return;
        }
        ArcInst ai = ArcInst.makeDummyInstance((PrimitiveArc)ap, 100.0);
        boolean bestFound = false;
        double bestArea = 0.0;
        Technology tech = ap.getTechnology();
        Poly[] polys = tech.getShapeOfArc(ai);
        int tot = polys.length;
        for (int i = 0; i < tot; ++i) {
            Poly poly = polys[i];
            double area = Math.abs(poly.getArea());
            if (bestFound && area >= bestArea) continue;
            bestArea = area;
            bestFound = true;
            arcLayers.put(ap, poly.getLayer());
        }
    }

    static {
        router = new SimpleWirer();
    }

    private static class AutoStitchJob
    extends Job {
        private boolean highlighted;
        private boolean forced;

        protected AutoStitchJob(boolean highlighted, boolean forced) {
            super("Auto-Stitch", Routing.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlighted = highlighted;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            AutoStitch.runAutoStitch(this.highlighted, this.forced);
            return true;
        }
    }
}

