/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class FastHenryArc
extends EDialog {
    private ArcInst ai;
    private List groupsList;
    private String initialGroupName;
    private double initialThickness;
    private int initialWidthSubdivs;
    private int initialHeightSubdivs;
    private double initialZHead;
    private double initialZTail;
    private JButton cancel;
    private JLabel fhaDefaultHeightSubdivs;
    private JLabel fhaDefaultThickness;
    private JLabel fhaDefaultWidthSubdivs;
    private JLabel fhaDefaultZ;
    private JLabel fhaGroupLabel;
    private JComboBox fhaGroups;
    private JLabel fhaHeadXY;
    private JTextField fhaHeadZ;
    private JTextField fhaHeightSubdivs;
    private JLabel fhaHeightSubdivsLabel;
    private JCheckBox fhaIncludeArc;
    private JButton fhaNewGroup;
    private JLabel fhaTailXY;
    private JTextField fhaTailZ;
    private JTextField fhaThickness;
    private JLabel fhaThicknessLabel;
    private JLabel fhaWidth;
    private JLabel fhaWidthLabel;
    private JTextField fhaWidthSubdivs;
    private JLabel fhaWidthSubdivsLabel;
    private JPanel head;
    private JSeparator jSeparator1;
    private JButton ok;
    private JPanel tail;

    public static void showFastHenryArcDialog() {
        TopLevel jf = null;
        if (TopLevel.isMDIMode()) {
            jf = TopLevel.getCurrentJFrame();
        }
        FastHenryArc theDialog = new FastHenryArc((Frame)jf, true);
        theDialog.setVisible(true);
    }

    private FastHenryArc(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.ai = null;
        int arcCount = 0;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd != null) {
            Iterator it = wnd.getHighlighter().getHighlights().iterator();
            while (it.hasNext()) {
                ElectricObject eobj;
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
                this.ai = (ArcInst)eobj;
                ++arcCount;
            }
            if (arcCount > 1) {
                this.ai = null;
            }
        }
        if (this.ai == null) {
            this.disableDialog();
            return;
        }
        this.fhaIncludeArc.setEnabled(true);
        HashSet<String> groupNames = new HashSet<String>();
        Iterator it = this.ai.getParent().getArcs();
        while (it.hasNext()) {
            ArcInst oAi = (ArcInst)it.next();
            Variable var = oAi.getVar(FastHenry.GROUP_NAME_KEY);
            if (var == null) continue;
            groupNames.add(var.getPureValue(-1));
        }
        this.groupsList = new ArrayList();
        it = groupNames.iterator();
        while (it.hasNext()) {
            this.groupsList.add(it.next());
        }
        Collections.sort(this.groupsList, new TextUtils.StringsCaseInsensitive());
        it = this.groupsList.iterator();
        while (it.hasNext()) {
            this.fhaGroups.addItem((String)it.next());
        }
        FastHenry.FastHenryArcInfo fhai = new FastHenry.FastHenryArcInfo(this.ai);
        this.initialGroupName = "";
        String groupName = fhai.getGroupName();
        if (groupName == null) {
            this.fhaIncludeArc.setSelected(false);
        } else {
            this.fhaIncludeArc.setSelected(true);
            this.initialGroupName = groupName;
            this.fhaGroups.setSelectedItem(this.initialGroupName);
        }
        this.fhaWidth.setText(TextUtils.formatDouble(this.ai.getWidth() - this.ai.getProto().getWidthOffset()));
        String thickness = "";
        if (fhai.getThickness() >= 0.0) {
            this.initialThickness = fhai.getThickness();
            thickness = TextUtils.formatDouble(this.initialThickness);
        }
        this.fhaThickness.setText(thickness);
        this.fhaDefaultThickness.setText("default=" + TextUtils.formatDouble(Simulation.getFastHenryDefThickness()));
        String widthSubdivisions = "";
        if (fhai.getWidthSubdivisions() >= 0) {
            this.initialWidthSubdivs = fhai.getWidthSubdivisions();
            widthSubdivisions = Integer.toString(this.initialWidthSubdivs);
        }
        this.fhaWidthSubdivs.setText(widthSubdivisions);
        this.fhaDefaultWidthSubdivs.setText("default=" + Integer.toString(Simulation.getFastHenryWidthSubdivisions()));
        String heightSubdivisions = "";
        if (fhai.getHeightSubdivisions() >= 0) {
            this.initialHeightSubdivs = fhai.getHeightSubdivisions();
            heightSubdivisions = Integer.toString(this.initialHeightSubdivs);
        }
        this.fhaHeightSubdivs.setText(heightSubdivisions);
        this.fhaDefaultHeightSubdivs.setText("default=" + Integer.toString(Simulation.getFastHenryHeightSubdivisions()));
        this.fhaHeadXY.setText("Head at:   X=" + TextUtils.formatDouble(this.ai.getHead().getLocation().getX()) + "   Y=" + TextUtils.formatDouble(this.ai.getHead().getLocation().getY()) + "   Z=");
        String headZ = "";
        if (fhai.getZHead() >= 0.0) {
            this.initialZHead = fhai.getZHead();
            headZ = TextUtils.formatDouble(this.initialZHead);
        }
        this.fhaHeadZ.setText(headZ);
        this.fhaTailXY.setText("Tail at:   X=" + TextUtils.formatDouble(this.ai.getTail().getLocation().getX()) + "   Y=" + TextUtils.formatDouble(this.ai.getTail().getLocation().getY()) + "   Z=");
        String tailZ = "";
        if (fhai.getZTail() >= 0.0) {
            this.initialZTail = fhai.getZTail();
            tailZ = TextUtils.formatDouble(this.initialZTail);
        }
        this.fhaTailZ.setText(tailZ);
        String defaultZ = "";
        if (fhai.getZDefault() >= 0.0) {
            defaultZ = TextUtils.formatDouble(fhai.getZDefault());
        }
        this.fhaDefaultZ.setText("default=" + defaultZ);
        this.includeArcClicked();
        this.fhaNewGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryArc.this.makeNewGroup();
            }
        });
        this.fhaIncludeArc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryArc.this.includeArcClicked();
            }
        });
    }

    private void makeNewGroup() {
        String groupName = (String)JOptionPane.showInputDialog(null, "Name of new FastHenry group:", "New Group Name", 3, null, null, "NewGroup");
        if (groupName == null) {
            return;
        }
        if (this.groupsList.contains(groupName)) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "That group name is already in the list");
            return;
        }
        this.groupsList.add(groupName);
        Collections.sort(this.groupsList, new TextUtils.StringsCaseInsensitive());
        this.fhaGroups.removeAllItems();
        Iterator it = this.groupsList.iterator();
        while (it.hasNext()) {
            this.fhaGroups.addItem((String)it.next());
        }
        this.fhaGroups.setSelectedItem(groupName);
    }

    private void includeArcClicked() {
        boolean enable = this.fhaIncludeArc.isSelected();
        this.fhaGroupLabel.setEnabled(enable);
        this.fhaGroups.setEnabled(enable);
        this.fhaNewGroup.setEnabled(enable);
        this.fhaWidthLabel.setEnabled(enable);
        this.fhaWidth.setEnabled(enable);
        this.fhaThicknessLabel.setEnabled(enable);
        this.fhaThickness.setEnabled(enable);
        this.fhaThickness.setEditable(enable);
        this.fhaDefaultThickness.setEnabled(enable);
        this.fhaWidthSubdivsLabel.setEnabled(enable);
        this.fhaWidthSubdivs.setEnabled(enable);
        this.fhaWidthSubdivs.setEditable(enable);
        this.fhaDefaultWidthSubdivs.setEnabled(enable);
        this.fhaHeightSubdivsLabel.setEnabled(enable);
        this.fhaHeightSubdivs.setEnabled(enable);
        this.fhaHeightSubdivs.setEditable(enable);
        this.fhaDefaultHeightSubdivs.setEnabled(enable);
        this.fhaHeadXY.setEnabled(enable);
        this.fhaHeadZ.setEnabled(enable);
        this.fhaHeadZ.setEditable(enable);
        this.fhaTailXY.setEnabled(enable);
        this.fhaTailZ.setEnabled(enable);
        this.fhaTailZ.setEditable(enable);
        this.fhaDefaultZ.setEnabled(enable);
    }

    private void disableDialog() {
        this.fhaIncludeArc.setSelected(false);
        this.fhaIncludeArc.setEnabled(false);
        this.fhaGroupLabel.setEnabled(false);
        this.fhaGroups.setEnabled(false);
        this.fhaNewGroup.setEnabled(false);
        this.fhaWidthLabel.setEnabled(false);
        this.fhaWidth.setText("");
        this.fhaThicknessLabel.setEnabled(false);
        this.fhaThickness.setText("");
        this.fhaDefaultThickness.setText("");
        this.fhaWidthSubdivsLabel.setEnabled(false);
        this.fhaWidthSubdivs.setText("");
        this.fhaDefaultWidthSubdivs.setText("");
        this.fhaHeightSubdivsLabel.setEnabled(false);
        this.fhaHeightSubdivs.setText("");
        this.fhaDefaultHeightSubdivs.setText("");
        this.fhaHeadXY.setText("Head at:   X=   Y=   Z=");
        this.fhaHeadXY.setEnabled(false);
        this.fhaHeadZ.setText("");
        this.fhaTailXY.setText("Tail at:   X=   Y=   Z=");
        this.fhaTailXY.setEnabled(false);
        this.fhaTailZ.setText("");
        this.fhaDefaultZ.setText("default=");
        this.fhaDefaultZ.setEnabled(false);
    }

    private void okPressed() {
        if (this.ai != null) {
            UpdateFastHenryArc updateFastHenryArc = new UpdateFastHenryArc(this);
        }
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.ok = new JButton();
        this.cancel = new JButton();
        this.fhaIncludeArc = new JCheckBox();
        this.fhaGroupLabel = new JLabel();
        this.fhaGroups = new JComboBox();
        this.fhaThicknessLabel = new JLabel();
        this.fhaThickness = new JTextField();
        this.fhaWidthLabel = new JLabel();
        this.fhaWidth = new JLabel();
        this.fhaWidthSubdivsLabel = new JLabel();
        this.fhaWidthSubdivs = new JTextField();
        this.fhaHeightSubdivsLabel = new JLabel();
        this.fhaHeightSubdivs = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.fhaNewGroup = new JButton();
        this.fhaDefaultZ = new JLabel();
        this.head = new JPanel();
        this.fhaHeadXY = new JLabel();
        this.fhaHeadZ = new JTextField();
        this.tail = new JPanel();
        this.fhaTailXY = new JLabel();
        this.fhaTailZ = new JTextField();
        this.fhaDefaultThickness = new JLabel();
        this.fhaDefaultWidthSubdivs = new JLabel();
        this.fhaDefaultHeightSubdivs = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("FastHenry Arc Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FastHenryArc.this.closeDialog(evt);
            }
        });
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryArc.this.ok(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryArc.this.cancel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.fhaIncludeArc.setText("Include this arc in FastHenry analysis");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaIncludeArc, gridBagConstraints);
        this.fhaGroupLabel.setText("Group name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaGroupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaGroups, gridBagConstraints);
        this.fhaThicknessLabel.setText("Thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaThicknessLabel, gridBagConstraints);
        this.fhaThickness.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaThickness, gridBagConstraints);
        this.fhaWidthLabel.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaWidthLabel, gridBagConstraints);
        this.fhaWidth.setText("3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaWidth, gridBagConstraints);
        this.fhaWidthSubdivsLabel.setText("Width subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaWidthSubdivsLabel, gridBagConstraints);
        this.fhaWidthSubdivs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaWidthSubdivs, gridBagConstraints);
        this.fhaHeightSubdivsLabel.setText("Height subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaHeightSubdivsLabel, gridBagConstraints);
        this.fhaHeightSubdivs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaHeightSubdivs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.fhaNewGroup.setText("New Group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaNewGroup, gridBagConstraints);
        this.fhaDefaultZ.setText("default=17");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaDefaultZ, gridBagConstraints);
        this.head.setLayout(new GridBagLayout());
        this.fhaHeadXY.setText("Head at:   X=-17   Y=7   Z=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.head.add((Component)this.fhaHeadXY, gridBagConstraints);
        this.fhaHeadZ.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.head.add((Component)this.fhaHeadZ, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.getContentPane().add((Component)this.head, gridBagConstraints);
        this.tail.setLayout(new GridBagLayout());
        this.fhaTailXY.setText("Tail at:   X=20   Y=7   Z=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.tail.add((Component)this.fhaTailXY, gridBagConstraints);
        this.fhaTailZ.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.tail.add((Component)this.fhaTailZ, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.getContentPane().add((Component)this.tail, gridBagConstraints);
        this.fhaDefaultThickness.setText("default=2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaDefaultThickness, gridBagConstraints);
        this.fhaDefaultWidthSubdivs.setText("default=1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaDefaultWidthSubdivs, gridBagConstraints);
        this.fhaDefaultHeightSubdivs.setText("default=1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.fhaDefaultHeightSubdivs, gridBagConstraints);
        this.pack();
    }

    private void ok(ActionEvent evt) {
        this.okPressed();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class UpdateFastHenryArc
    extends Job {
        FastHenryArc fha;

        private UpdateFastHenryArc(FastHenryArc fha) {
            super("Update FastHenry Arc", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fha = fha;
            this.startJob();
        }

        public boolean doIt() {
            if (this.fha.fhaIncludeArc.isSelected()) {
                Variable var;
                String newGroupName = (String)this.fha.fhaGroups.getSelectedItem();
                if (!newGroupName.equals(this.fha.initialGroupName) && (var = this.fha.ai.newVar(FastHenry.GROUP_NAME_KEY, (Object)newGroupName)) != null) {
                    var.setDisplay(true);
                }
                double thickness = -1.0;
                if (this.fha.fhaThickness.getText().length() > 0) {
                    thickness = TextUtils.atof(this.fha.fhaThickness.getText());
                }
                if (thickness != this.fha.initialThickness) {
                    this.fha.ai.newVar(FastHenry.THICKNESS_KEY, (Object)new Double(thickness));
                }
                int widthSubdivs = -1;
                if (this.fha.fhaWidthSubdivs.getText().length() > 0) {
                    widthSubdivs = TextUtils.atoi(this.fha.fhaWidthSubdivs.getText());
                }
                if (widthSubdivs != this.fha.initialWidthSubdivs) {
                    this.fha.ai.newVar(FastHenry.WIDTH_SUBDIVS_KEY, (Object)new Integer(widthSubdivs));
                }
                int heightSubdivs = -1;
                if (this.fha.fhaHeightSubdivs.getText().length() > 0) {
                    heightSubdivs = TextUtils.atoi(this.fha.fhaHeightSubdivs.getText());
                }
                if (heightSubdivs != this.fha.initialHeightSubdivs) {
                    this.fha.ai.newVar(FastHenry.HEIGHT_SUBDIVS_KEY, (Object)new Integer(heightSubdivs));
                }
                double zHead = -1.0;
                if (this.fha.fhaHeadZ.getText().length() > 0) {
                    zHead = TextUtils.atof(this.fha.fhaHeadZ.getText());
                }
                if (zHead != this.fha.initialZHead) {
                    this.fha.ai.newVar(FastHenry.ZHEAD_KEY, (Object)new Double(zHead));
                }
                double zTail = -1.0;
                if (this.fha.fhaTailZ.getText().length() > 0) {
                    zTail = TextUtils.atof(this.fha.fhaTailZ.getText());
                }
                if (zTail != this.fha.initialZTail) {
                    this.fha.ai.newVar(FastHenry.ZTAIL_KEY, (Object)new Double(zTail));
                }
            } else if (this.fha.ai.getVar(FastHenry.GROUP_NAME_KEY) != null) {
                this.fha.ai.delVar(FastHenry.GROUP_NAME_KEY);
            }
            this.fha.closeDialog(null);
            return true;
        }
    }
}

