/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.About;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

public class HelpMenu {
    protected static MenuBar.Menu addHelpMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu helpMenu = new MenuBar.Menu("Help", 'H');
        menuBar.add(helpMenu);
        if (TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
            helpMenu.addMenuItem("About Electric...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpMenu.aboutCommand();
                }
            });
            helpMenu.addSeparator();
        }
        helpMenu.addMenuItem("User's Manual...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpMenu.userManualCommand();
            }
        });
        helpMenu.addMenuItem("Load Samples Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualViewer.loadSamplesLibrary();
            }
        });
        MenuBar.Menu builtInLibSubMenu = new MenuBar.Menu("Load Built-in Libraries", 'B');
        helpMenu.add(builtInLibSubMenu);
        builtInLibSubMenu.addMenuItem("MOSIS CMOS Pads", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpMenu.loadBuiltInLibraryCommand("pads4u");
            }
        });
        return helpMenu;
    }

    public static void aboutCommand() {
        About dialog = new About((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void userManualCommand() {
        ManualViewer dialog = new ManualViewer(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private static void loadBuiltInLibraryCommand(String libName) {
        if (Library.findLibrary(libName) != null) {
            return;
        }
        URL url = LibFile.getLibFile(libName + ".jelib");
        FileMenu.ReadLibrary job = new FileMenu.ReadLibrary(url, FileType.JELIB, null);
    }
}

