/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.compaction.Compaction;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.generator.PadGenerator;
import com.sun.electric.tool.generator.ROMGenerator;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.misc.LayerCoverageJob;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.NetEquivalence;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.parasitic.ParasiticTool;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Maze;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.routing.River;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.FastHenryArc;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.KeyStroke;

public class ToolMenu {
    protected static void addToolMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu toolMenu = new MenuBar.Menu("Tool", 'T');
        menuBar.add(toolMenu);
        MenuBar.Menu drcSubMenu = new MenuBar.Menu("DRC", 'D');
        toolMenu.add(drcSubMenu);
        drcSubMenu.addMenuItem("Check Hierarchically", KeyStroke.getKeyStroke(116, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(false);
            }
        });
        drcSubMenu.addMenuItem("Check Selection Area Hierarchically", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(true);
            }
        });
        MenuBar.Menu spiceSimulationSubMenu = new MenuBar.Menu("Simulation (Spice)", 'S');
        toolMenu.add(spiceSimulationSubMenu);
        spiceSimulationSubMenu.addMenuItem("Write Spice Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.SPICE, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Write CDL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.CDL, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice Listing...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResults();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice for This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResultsThisCell();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice Model...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSpiceModel();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Add Multiplier", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.addMultiplierCommand();
            }
        });
        spiceSimulationSubMenu.addSeparator();
        spiceSimulationSubMenu.addMenuItem("Set Generic Spice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice 2 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_2_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice 3 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_3_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set HSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_H_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set PSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_P_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set GnuCap Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_GC_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set SmartSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_SM_TEMPLATE_KEY);
            }
        });
        MenuBar.Menu verilogSimulationSubMenu = new MenuBar.Menu("Simulation (Verilog)", 'V');
        toolMenu.add(verilogSimulationSubMenu);
        verilogSimulationSubMenu.addMenuItem("Write Verilog Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.VERILOG, true);
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog VCD Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResults();
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog for This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResultsThisCell();
            }
        });
        verilogSimulationSubMenu.addSeparator();
        verilogSimulationSubMenu.addMenuItem("Set Verilog Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Verilog.VERILOG_TEMPLATE_KEY);
            }
        });
        verilogSimulationSubMenu.addSeparator();
        MenuBar.Menu verilogWireTypeSubMenu = new MenuBar.Menu("Set Verilog Wire", 'W');
        verilogWireTypeSubMenu.addMenuItem("Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(0);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("Trireg", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(1);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("Default", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(2);
            }
        });
        verilogSimulationSubMenu.add(verilogWireTypeSubMenu);
        MenuBar.Menu transistorStrengthSubMenu = new MenuBar.Menu("Transistor Strength", 'T');
        transistorStrengthSubMenu.addMenuItem("Weak", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(true);
            }
        });
        transistorStrengthSubMenu.addMenuItem("Normal", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(false);
            }
        });
        verilogSimulationSubMenu.add(transistorStrengthSubMenu);
        MenuBar.Menu netlisters = new MenuBar.Menu("Simulation (Others)");
        toolMenu.add(netlisters);
        netlisters.addMenuItem("Write Maxwell Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.MAXWELL, true);
            }
        });
        netlisters.addMenuItem("Write Tegas Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.TEGAS, true);
            }
        });
        netlisters.addMenuItem("Write SILOS Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.SILOS, true);
            }
        });
        netlisters.addMenuItem("Write PAL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PAL, true);
            }
        });
        netlisters.addSeparator();
        netlisters.addMenuItem("Write IRSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.IRSIM, true);
            }
        });
        netlisters.addMenuItem("Write ESIM/RNL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.ESIM, true);
            }
        });
        netlisters.addMenuItem("Write RSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.RSIM, true);
            }
        });
        netlisters.addMenuItem("Write COSMOS Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.COSMOS, true);
            }
        });
        netlisters.addMenuItem("Write MOSSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.MOSSIM, true);
            }
        });
        netlisters.addSeparator();
        netlisters.addMenuItem("Write FastHenry Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.FASTHENRY, true);
            }
        });
        netlisters.addMenuItem("FastHenry Arc Properties...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FastHenryArc.showFastHenryArcDialog();
            }
        });
        MenuBar.Menu ercSubMenu = new MenuBar.Menu("ERC", 'E');
        toolMenu.add(ercSubMenu);
        ercSubMenu.addMenuItem("Check Wells", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(false);
            }
        });
        ercSubMenu.addMenuItem("Antenna Check", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ERCAntenna();
            }
        });
        MenuBar.Menu nccSubMenu = new MenuBar.Menu("NCC", 'N');
        toolMenu.add(nccSubMenu);
        nccSubMenu.addMenuItem("Schematic and Layout Views of Cell in Current Window", null, 38, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(1);
            }
        });
        nccSubMenu.addMenuItem("Cells from Two Windows", null, 11, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(2);
            }
        });
        MenuBar.Menu networkSubMenu = new MenuBar.Menu("Network", 'e');
        toolMenu.add(networkSubMenu);
        networkSubMenu.addMenuItem("Show Network", KeyStroke.getKeyStroke(75, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Networks", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listNetworksCommand();
            }
        });
        networkSubMenu.addMenuItem("List Connections on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listConnectionsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Exports on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Exports below Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsBelowNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Geometry on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeometryOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Total Wire Lengths on All Networks", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeomsAllNetworksCommand();
            }
        });
        networkSubMenu.addSeparator();
        networkSubMenu.addMenuItem("Show Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showPowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("Validate Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.validatePowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("Redo Network Numbering", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NetworkTool.RenumberJob();
            }
        });
        MenuBar.Menu logEffortSubMenu = new MenuBar.Menu("Logical Effort", 'L');
        logEffortSubMenu.addMenuItem("Optimize for Equal Gate Delays", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.optimizeEqualGateDelaysCommand(true);
            }
        });
        logEffortSubMenu.addMenuItem("Optimize for Equal Gate Delays (no caching)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.optimizeEqualGateDelaysCommand(false);
            }
        });
        logEffortSubMenu.addMenuItem("Print Info for Selected Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.printLEInfoCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Back Annotate Wire Lengths for Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.backAnnotateCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Clear Sizes on Selected Node(s)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.clearSizesNodableCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Clear Sizes in all Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.clearSizesCommand();
            }
        });
        toolMenu.add(logEffortSubMenu);
        MenuBar.Menu routingSubMenu = new MenuBar.Menu("Routing", 'R');
        toolMenu.add(routingSubMenu);
        routingSubMenu.addCheckBox("Enable Auto-Stitching", Routing.isAutoStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableAutoStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Auto-Stitch Now", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(false, true);
            }
        });
        routingSubMenu.addMenuItem("Auto-Stitch Highlighted Now", KeyStroke.getKeyStroke(113, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(true, true);
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addCheckBox("Enable Mimic-Stitching", Routing.isMimicStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableMimicStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Mimic-Stitch Now", KeyStroke.getKeyStroke(112, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MimicStitch.mimicStitch(true);
            }
        });
        routingSubMenu.addMenuItem("Mimic Selected", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.tool.mimicSelected();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("Maze Route", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Maze.mazeRoute();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("River-Route", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                River.riverRoute();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("Unroute", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.unrouteCurrent();
            }
        });
        routingSubMenu.addMenuItem("Get Unrouted Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.getUnroutedArcCommand();
            }
        });
        routingSubMenu.addMenuItem("Copy Routing Topology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.copyRoutingTopology();
            }
        });
        routingSubMenu.addMenuItem("Paste Routing Topology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.pasteRoutingTopology();
            }
        });
        MenuBar.Menu generationSubMenu = new MenuBar.Menu("Generation", 'G');
        toolMenu.add(generationSubMenu);
        generationSubMenu.addMenuItem("Coverage Implants Generator", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, false);
            }
        });
        generationSubMenu.addMenuItem("Pad Frame Generator", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.padFrameGeneratorCommand();
            }
        });
        generationSubMenu.addMenuItem("ROM Generator...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ROMGenerator.generateROM();
            }
        });
        generationSubMenu.addMenuItem("Generate gate layouts (MoCMOS)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new GateLayoutGenerator(MoCMOS.tech);
            }
        });
        if (Technology.getTSMC90Technology() != null) {
            generationSubMenu.addMenuItem("Generate gate layouts (TSMC90)", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new GateLayoutGenerator(Technology.getTSMC90Technology());
                }
            });
        }
        MenuBar.Menu compactionSubMenu = new MenuBar.Menu("Compaction", 'C');
        toolMenu.add(compactionSubMenu);
        compactionSubMenu.addMenuItem("Do Compaction", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Compaction.compactNow();
            }
        });
        toolMenu.addSeparator();
        toolMenu.addMenuItem("List Tools", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listToolsCommand();
            }
        });
        MenuBar.Menu languagesSubMenu = new MenuBar.Menu("Languages");
        languagesSubMenu.addMenuItem("Run Java Bean Shell Script", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.javaBshScriptCommand();
            }
        });
        toolMenu.add(languagesSubMenu);
    }

    public static void optimizeEqualGateDelaysCommand(boolean newAlg) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        LETool letool = LETool.getLETool();
        if (letool == null) {
            System.out.println("Logical Effort tool not found");
            return;
        }
        curEdit.setCell(curEdit.getCell(), VarContext.globalContext);
        letool.optimizeEqualGateDelays(curEdit.getCell(), curEdit.getVarContext(), curEdit, newAlg);
    }

    public static void printLEInfoCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        VarContext context = wnd.getVarContext();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.printResults(ni, context);
        }
    }

    public static void backAnnotateCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        BackAnnotateJob job = new BackAnnotateJob(cell);
        job.startJob();
    }

    public static void clearSizesNodableCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.clearStoredSizesJob(ni);
        }
        System.out.println("Sizes cleared");
    }

    public static void clearSizesCommand() {
        Iterator it = Library.getVisibleLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            LETool.clearStoredSizesJob(lib);
        }
        System.out.println("Sizes cleared");
    }

    public static void showNetworkCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        Cell cell = wnd.getCell();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        highlighter.showNetworks(nets, cell.getUserNetlist(), cell);
        WindowFrame.show3DHighlight(wnd);
        highlighter.finished();
    }

    public static void listNetworksCommand() {
        Cell cell = WindowFrame.getCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.getUserNetlist();
        int total = 0;
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            String netName = net.describe();
            if (netName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("'" + netName + "'");
            boolean connected = false;
            Iterator aIt = net.getArcs();
            while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                if (!connected) {
                    connected = true;
                    infstr.append(", on arcs:");
                }
                infstr.append(" " + ai.describe());
            }
            boolean exported = false;
            Iterator eIt = net.getExports();
            while (eIt.hasNext()) {
                Export pp = (Export)eIt.next();
                if (!exported) {
                    exported = true;
                    infstr.append(", with exports:");
                }
                infstr.append(" " + pp.getName());
            }
            System.out.println(infstr.toString());
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no networks in this cell");
        }
    }

    public static void listConnectionsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network '" + net.describe() + "':");
            int total = 0;
            Iterator nIt = netlist.getNodables();
            while (nIt.hasNext()) {
                PortProto pp;
                Nodable no = (Nodable)nIt.next();
                NodeProto np = no.getProto();
                HashMap<Network, PortProto> portNets = new HashMap<Network, PortProto>();
                Iterator pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp2 = (PortProto)pIt.next();
                    if (pp2 instanceof PrimitivePort && ((PrimitivePort)pp2).isIsolated()) {
                        NodeInst ni = (NodeInst)no;
                        Iterator cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = (Connection)cIt.next();
                            ArcInst ai = con.getArc();
                            Network oNet = netlist.getNetwork(ai, 0);
                            portNets.put(oNet, pp2);
                        }
                        continue;
                    }
                    int width = 1;
                    if (pp2 instanceof Export) {
                        Export e = (Export)pp2;
                        width = netlist.getBusWidth(e);
                    }
                    for (int i = 0; i < width; ++i) {
                        Network oNet = netlist.getNetwork(no, pp2, i);
                        portNets.put(oNet, pp2);
                    }
                }
                if (portNets.size() <= 1 || (pp = (PortProto)portNets.get(net)) == null) continue;
                if (total == 0) {
                    System.out.println("  Connects to:");
                }
                String name = null;
                name = no instanceof NodeInst ? ((NodeInst)no).describe() : no.getName();
                System.out.println("    Node " + name + ", port " + pp.getName());
                ++total;
            }
            if (total != 0) continue;
            System.out.println("  Not connected");
        }
    }

    public static void listExportsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network '" + net.describe() + "':");
            HashSet listedExports = new HashSet();
            System.out.println("  Going up the hierarchy from cell " + cell.describe() + ":");
            ToolMenu.findPortsUp(netlist, net, cell, listedExports);
            System.out.println("  Going down the hierarchy from cell " + cell.describe() + ":");
            ToolMenu.findPortsDown(netlist, net, cell, listedExports);
        }
    }

    public static void listExportsBelowNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network '" + net.describe() + "':");
            ToolMenu.findPortsDown(netlist, net, cell, new HashSet());
        }
    }

    private static void findPortsUp(Netlist netlist, Network net, Cell cell, HashSet listedExports) {
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network ppNet = netlist.getNetwork(pp, i);
                if (ppNet != net || listedExports.contains(pp)) continue;
                listedExports.add(listedExports);
                System.out.println("    Export " + pp.getName() + " in cell " + cell.describe());
                Cell instanceCell = cell.iconView();
                if (instanceCell == null) {
                    instanceCell = cell;
                }
                Iterator uIt = instanceCell.getUsagesOf();
                while (uIt.hasNext()) {
                    NodeUsage nu = (NodeUsage)uIt.next();
                    Cell superCell = nu.getParent();
                    Netlist superNetlist = superCell.getUserNetlist();
                    Iterator nIt = superNetlist.getNodables();
                    while (nIt.hasNext()) {
                        Nodable no = (Nodable)nIt.next();
                        if (no.getProto() != cell) continue;
                        Network superNet = superNetlist.getNetwork(no, pp, i);
                        ToolMenu.findPortsUp(superNetlist, superNet, superCell, listedExports);
                    }
                }
            }
        }
    }

    private static void findPortsDown(Netlist netlist, Network net, Cell cell, HashSet listedExports) {
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            NodeProto subnp = no.getProto();
            if (!(subnp instanceof Cell)) continue;
            Cell subCell = (Cell)subnp;
            Iterator pIt = subCell.getPorts();
            while (pIt.hasNext()) {
                Export pp = (Export)pIt.next();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    Network oNet = netlist.getNetwork(no, pp, i);
                    if (oNet != net || listedExports.contains(pp)) continue;
                    listedExports.add(pp);
                    System.out.println("    Export " + pp.getName() + " in cell " + subCell.describe());
                    Netlist subNetlist = subCell.getUserNetlist();
                    Network subNet = subNetlist.getNetwork(pp, i);
                    ToolMenu.findPortsDown(subNetlist, subNet, subCell, listedExports);
                }
            }
        }
    }

    public static void listGeometryOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        HashSet nets = (HashSet)wnd.getHighlighter().getHighlightedNetworks();
        if (nets.isEmpty()) {
            System.out.println("No network in cell '" + cell.describe() + "' selected");
            return;
        }
        LayerCoverageJob.listGeometryOnNetworks(cell, nets, true);
    }

    public static void listGeomsAllNetworksCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ListGeomsAllNetworksJob job = new ListGeomsAllNetworksJob(cell);
    }

    public static void showPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Netlist netlist = cell.getUserNetlist();
        HashSet<Network> pAndG = new HashSet<Network>();
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (!pp.isPower() && !pp.isGround()) continue;
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(pp, i);
                pAndG.add(net);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.CONPOWER && fun != PrimitiveNode.Function.CONGROUND) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                int width = netlist.getBusWidth(ai);
                for (int i = 0; i < width; ++i) {
                    Network net = netlist.getNetwork(ai, i);
                    pAndG.add(net);
                }
            }
        }
        highlighter.clear();
        it = pAndG.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            highlighter.addNetwork(net, cell);
        }
        highlighter.finished();
        if (pAndG.size() == 0) {
            System.out.println("This cell has no Power or Ground networks");
        }
    }

    public static void validatePowerAndGround() {
        System.out.println("Validating power and ground networks");
        int total = 0;
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator pIt = cell.getPorts();
                while (pIt.hasNext()) {
                    Export pp = (Export)pIt.next();
                    if (pp.isNamedGround() && pp.getCharacteristic() != PortCharacteristic.GND) {
                        System.out.println("Cell " + cell.describe() + ", export " + pp.getName() + ": does not have 'GROUND' characteristic");
                        ++total;
                    }
                    if (!pp.isNamedPower() || pp.getCharacteristic() == PortCharacteristic.PWR) continue;
                    System.out.println("Cell " + cell.describe() + ", export " + pp.getName() + ": does not have 'POWER' characteristic");
                    ++total;
                }
            }
        }
        if (total == 0) {
            System.out.println("No problems found");
        } else {
            System.out.println("Found " + total + " export problems");
        }
    }

    public static void addMultiplierCommand() {
        Cell cell = WindowFrame.needCurCell();
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        AddMultiplier job = new AddMultiplier(ni);
    }

    public static void makeTemplate(Variable.Key templateKey) {
        MakeTemplate job = new MakeTemplate(templateKey);
    }

    public static void getUnroutedArcCommand() {
        User.tool.setCurrentArcProto(Generic.tech.unrouted_arc);
    }

    public static void padFrameGeneratorCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.PADARR, null);
        if (fileName != null) {
            PadGenerator.generate(fileName);
        }
    }

    public static void layerCoverageCommand(Job.Type jobType, int func, boolean test) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        Highlighter highlighter = null;
        if (wnd != null && wnd.getCell() == curCell) {
            highlighter = wnd.getHighlighter();
        }
        LayerCoverageJob job = new LayerCoverageJob(jobType, curCell, func, test, highlighter, null);
    }

    public static void listToolsCommand() {
        System.out.println("Tools in Electric:");
        Iterator it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            StringBuffer infstr = new StringBuffer();
            if (tool.isOn()) {
                infstr.append("On");
            } else {
                infstr.append("Off");
            }
            if (tool.isBackground()) {
                infstr.append(", Background");
            }
            if (tool.isFixErrors()) {
                infstr.append(", Correcting");
            }
            if (tool.isIncremental()) {
                infstr.append(", Incremental");
            }
            if (tool.isAnalysis()) {
                infstr.append(", Analysis");
            }
            if (tool.isSynthesis()) {
                infstr.append(", Synthesis");
            }
            System.out.println(tool.getName() + ": " + infstr.toString());
        }
    }

    public static void javaBshScriptCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.JAVA, null);
        if (fileName != null) {
            EvalJavaBsh.runScript(fileName);
        }
    }

    public static void parasiticCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        Cell cell = wnd.getCell();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            ParasiticTool.getParasiticTool().netwokParasitic(net, cell);
        }
    }

    private static class MakeTemplate
    extends Job {
        private Variable.Key templateKey;

        protected MakeTemplate(Variable.Key templateKey) {
            super("Make template", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            Variable templateVar = cell.getVar(this.templateKey);
            if (templateVar != null) {
                System.out.println("This cell already has a template");
                return false;
            }
            templateVar = cell.newVar(this.templateKey, (Object)"*Undefined");
            if (templateVar != null) {
                templateVar.setDisplay(true);
                TextDescriptor td = templateVar.getTextDescriptor();
                td.setInterior(true);
                td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                System.out.println("Set " + this.templateKey.getName().replaceFirst("ATTR_", "") + " for cell " + cell.describe());
            }
            return true;
        }
    }

    private static class AddMultiplier
    extends Job {
        private NodeInst ni;

        protected AddMultiplier(NodeInst ni) {
            super("Add Spice Multiplier", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.ni.newVar("ATTR_M", (Object)new Double(1.0));
            if (var != null) {
                var.setDisplay(true);
                TextDescriptor td = var.getTextDescriptor();
                td.setOff(-1.5, -1.0);
                td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
            }
            return true;
        }
    }

    public static class ListGeomsAllNetworksJob
    extends Job {
        private Cell cell;

        public ListGeomsAllNetworksJob(Cell cell) {
            super("ListGeomsAllNetworks", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Netlist netlist = this.cell.getNetlist(true);
            ArrayList networks = new ArrayList();
            Iterator it = netlist.getNetworks();
            while (it.hasNext()) {
                networks.add(it.next());
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            it = networks.iterator();
            while (it.hasNext()) {
                Network net = (Network)it.next();
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(net);
                LayerCoverageJob.GeometryOnNetwork geoms = LayerCoverageJob.listGeometryOnNetworksNoJob(this.cell, nets, false);
                if (geoms.getTotalWireLength() == 0.0) continue;
                System.out.println("Network " + net + " has wire length " + geoms.getTotalWireLength());
            }
            return true;
        }
    }

    public static class BackAnnotateJob
    extends Job {
        private Cell cell;

        public BackAnnotateJob(Cell cell) {
            super("BackAnnotate", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        public boolean doIt() {
            NccOptions options;
            NccResult result;
            Cell[] schLayCells = NccUtils.findSchematicAndLayout(this.cell);
            if (schLayCells == null) {
                System.out.println("Could not find schematic and layout cells for " + this.cell.describe());
                return false;
            }
            if (this.cell.getView() == View.LAYOUT) {
                schLayCells[1] = this.cell;
            }
            if ((result = Ncc.compare(schLayCells[0], null, schLayCells[1], null, options = new NccOptions())) == null || !result.topologyMatch()) {
                System.out.println("Ncc failed, can't back-annotate");
                return false;
            }
            int wiresUpdated = 0;
            ArrayList<Network> networks = new ArrayList<Network>();
            HashMap<Network, NodeInst> map = new HashMap<Network, NodeInst>();
            Iterator it = schLayCells[0].getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                Variable var = ni.getVar("ATTR_LEWIRE");
                if (var == null) continue;
                var = ni.getVar("ATTR_L");
                if (var == null) {
                    System.out.println("No attribute L on wire model " + ni.describe() + ", ignoring it.");
                    continue;
                }
                PortInst pi = ni.getPortInst(0);
                if (pi == null) continue;
                Netlist netlist = schLayCells[0].getNetlist(true);
                Network schNet = netlist.getNetwork(pi);
                networks.add(schNet);
                map.put(schNet, ni);
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            it = networks.iterator();
            while (it.hasNext()) {
                Network schNet = (Network)it.next();
                Netlist netlist = schLayCells[0].getNetlist(true);
                NetEquivalence equiv = result.getNetEquivalence();
                HierarchyEnumerator.NetNameProxy proxy = equiv.findEquivalent(VarContext.globalContext, schNet);
                if (proxy == null) {
                    System.out.println("No matching network in layout for " + proxy.toString() + ", ignoring");
                    continue;
                }
                Network layNet = proxy.getNet();
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(layNet);
                LayerCoverageJob.GeometryOnNetwork geoms = LayerCoverageJob.listGeometryOnNetworksNoJob(schLayCells[1], nets, false);
                double length = geoms.getTotalWireLength();
                NodeInst ni = (NodeInst)map.get(schNet);
                ni.updateVar("ATTR_L", (Object)new Double(length));
                ++wiresUpdated;
                System.out.println("Updated wire model " + ni.getName() + " on network " + proxy.toString() + " to: " + length + " lambda");
            }
            System.out.println("Updated " + wiresUpdated + " wire models in " + schLayCells[0].describe() + " from layout " + schLayCells[1].describe());
            return true;
        }
    }
}

