/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractGUITest;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.ElapseTimer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class FakeTestJob
extends Job {
    private List<AbstractTest> list;
    private boolean result;
    private int whichTest;
    private int numPassed;
    private int numFailed;
    private ErrorLogger errorLogger;
    private List<URL> requiredLibraries;
    private static ElapseTimer theTimer;

    public FakeTestJob(AbstractTest test) {
        this(Collections.singletonList(test));
    }

    public FakeTestJob(List<AbstractTest> list) {
        this(list, 0, 0, 0, User.getRegressionPath(), ErrorLogger.newInst(list.get(0).getClass().getName() + " Tests"));
    }

    private FakeTestJob(List<AbstractTest> list, int nextTest, int numPassed, int numFailed, String regressionPath, ErrorLogger errorLogs) {
        super("Test " + (String)(list.size() == 1 ? "" : nextTest + 1 + " of " + list.size() + " (" + numPassed + " passed, " + numFailed + " failed): ") + list.get(nextTest).getFullTestName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.list = list;
        this.numPassed = numPassed;
        this.numFailed = numFailed;
        this.whichTest = nextTest;
        if (nextTest == 0) {
            theTimer = ElapseTimer.createInstance().start();
        }
        System.out.println("\n****************** TEST " + list.get(this.whichTest).getFullTestName());
        this.errorLogger = errorLogs;
        this.errorLogger.disablePopups();
        boolean guiTests = list.get(nextTest) instanceof AbstractGUITest;
        if (guiTests) {
            this.requiredLibraries = new ArrayList<URL>();
            for (AbstractTest t : list) {
                if (!(t instanceof AbstractGUITest)) continue;
                t.setStarterJob(this);
                this.requiredLibraries.addAll(((AbstractGUITest)t).getRequiredLibraries(t.workingDir()));
            }
        }
        this.startJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doIt() throws JobException {
        AbstractGUITest gTest;
        EditingPreferences ep = this.getEditingPreferences();
        AbstractTest test = this.list.get(this.whichTest);
        if (test == null) {
            throw new JobException("Test is null");
        }
        boolean guiTests = test instanceof AbstractGUITest;
        test.setStarterJob(this);
        Setting.SettingChangeBatch restoreBatch = new Setting.SettingChangeBatch();
        Setting.SettingChangeBatch resetBatch = new Setting.SettingChangeBatch();
        for (Map.Entry<Setting, Object> e : this.getDatabase().getSettings().entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            restoreBatch.add(setting, value);
            resetBatch.add(setting, setting.getFactoryValue());
        }
        this.getDatabase().implementSettingChanges(resetBatch);
        try {
            if (guiTests) {
                for (URL libFileURL : this.requiredLibraries) {
                    LibraryFiles.readLibrary(ep, libFileURL, null, FileType.JELIB, false);
                }
            } else {
                Method t = test.getClass().getMethod(test.getFunctionName(), new Class[0]);
                Object o = t.invoke((Object)test, new Object[0]);
                if (o != null && o instanceof Boolean) {
                    this.result = (Boolean)o;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.getDatabase().implementSettingChanges(restoreBatch);
            Job.getUserInterface().saveMessages(null);
        }
        if (!test.isMultiTask() && !guiTests) {
            this.updateTestResult(this.result);
        }
        if (guiTests && !(gTest = (AbstractGUITest)test).phase1()) {
            this.updateTestResult(false);
        }
        return true;
    }

    @Override
    public void terminateOK() {
        AbstractTest test = this.list.get(this.whichTest);
        if (!(test instanceof AbstractGUITest)) {
            return;
        }
        final AbstractGUITest fTest = (AbstractGUITest)test;
        if (fTest.phase2()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FakeTestJob.this.updateTestResult(fTest.phase3());
                }
            });
        } else {
            this.updateTestResult(false);
        }
    }

    void updateTestResult(boolean result) {
        AbstractTest test = this.list.get(this.whichTest);
        String msg = "****************** TEST " + test.getFullTestName() + (result ? " PASSED" : " FAILED");
        System.out.println(msg);
        if (result) {
            ++this.numPassed;
        } else {
            ++this.numFailed;
        }
        if (result) {
            this.errorLogger.logWarning(msg, null, -1);
        } else {
            this.errorLogger.logError(msg, -1);
        }
        ++this.whichTest;
        if (this.whichTest < this.list.size()) {
            new FakeTestJob(this.list, this.whichTest, this.numPassed, this.numFailed, User.getRegressionPath(), this.errorLogger);
            return;
        }
        this.errorLogger.termLogging(true);
        if (this.numPassed + this.numFailed == 1) {
            String message = result ? "Test passed" : "Test failed";
            Job.getUserInterface().showInformationMessage(message, test.getFullTestName());
        } else {
            Object message = "";
            if (this.numPassed > 0) {
                message = (String)message + this.numPassed + " tests passed";
            }
            if (this.numFailed > 0) {
                if (((String)message).length() > 0) {
                    message = (String)message + ", ";
                }
                message = (String)message + this.numFailed + " tests failed";
            }
            theTimer.end();
            message = (String)message + " (took " + theTimer + ")";
            Job.getUserInterface().showInformationMessage((String)message, test.getFullTestName());
        }
    }
}

