/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.EditKeyBindings;
import com.sun.electric.tool.user.dialogs.options.AddedTechnologiesTab;
import com.sun.electric.tool.user.dialogs.options.AntennaRulesTab;
import com.sun.electric.tool.user.dialogs.options.CDLTab;
import com.sun.electric.tool.user.dialogs.options.CIFTab;
import com.sun.electric.tool.user.dialogs.options.CVSTab;
import com.sun.electric.tool.user.dialogs.options.CellModelTab;
import com.sun.electric.tool.user.dialogs.options.CompactionTab;
import com.sun.electric.tool.user.dialogs.options.ComponentMenuTab;
import com.sun.electric.tool.user.dialogs.options.CopyrightTab;
import com.sun.electric.tool.user.dialogs.options.CoverageTab;
import com.sun.electric.tool.user.dialogs.options.DEFTab;
import com.sun.electric.tool.user.dialogs.options.DRCTab;
import com.sun.electric.tool.user.dialogs.options.DXFTab;
import com.sun.electric.tool.user.dialogs.options.DaisTab;
import com.sun.electric.tool.user.dialogs.options.DesignRulesTab;
import com.sun.electric.tool.user.dialogs.options.DisplayControlTab;
import com.sun.electric.tool.user.dialogs.options.EDIFTab;
import com.sun.electric.tool.user.dialogs.options.FastHenryTab;
import com.sun.electric.tool.user.dialogs.options.FrameTab;
import com.sun.electric.tool.user.dialogs.options.GDSTab;
import com.sun.electric.tool.user.dialogs.options.GeneralTab;
import com.sun.electric.tool.user.dialogs.options.GerberTab;
import com.sun.electric.tool.user.dialogs.options.GridAndAlignmentTab;
import com.sun.electric.tool.user.dialogs.options.IconTab;
import com.sun.electric.tool.user.dialogs.options.LEFTab;
import com.sun.electric.tool.user.dialogs.options.LayersTab;
import com.sun.electric.tool.user.dialogs.options.LibraryTab;
import com.sun.electric.tool.user.dialogs.options.LogicalEffortTab;
import com.sun.electric.tool.user.dialogs.options.NCCTab;
import com.sun.electric.tool.user.dialogs.options.NetworkTab;
import com.sun.electric.tool.user.dialogs.options.NewArcsTab;
import com.sun.electric.tool.user.dialogs.options.NewNodesTab;
import com.sun.electric.tool.user.dialogs.options.ParasiticTab;
import com.sun.electric.tool.user.dialogs.options.PlacementTab;
import com.sun.electric.tool.user.dialogs.options.PortsAndExportsTab;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.dialogs.options.PrintingTab;
import com.sun.electric.tool.user.dialogs.options.ProjectManagementTab;
import com.sun.electric.tool.user.dialogs.options.RoutingTab;
import com.sun.electric.tool.user.dialogs.options.SUETab;
import com.sun.electric.tool.user.dialogs.options.SVGTab;
import com.sun.electric.tool.user.dialogs.options.ScaleTab;
import com.sun.electric.tool.user.dialogs.options.SelectionTab;
import com.sun.electric.tool.user.dialogs.options.SiliconCompilerTab;
import com.sun.electric.tool.user.dialogs.options.SimulatorsTab;
import com.sun.electric.tool.user.dialogs.options.SkillTab;
import com.sun.electric.tool.user.dialogs.options.SmartTextTab;
import com.sun.electric.tool.user.dialogs.options.SpiceTab;
import com.sun.electric.tool.user.dialogs.options.SunRouterTab;
import com.sun.electric.tool.user.dialogs.options.TechnologyTab;
import com.sun.electric.tool.user.dialogs.options.TextTab;
import com.sun.electric.tool.user.dialogs.options.ThreeDTab;
import com.sun.electric.tool.user.dialogs.options.ToolbarTab;
import com.sun.electric.tool.user.dialogs.options.UnitsTab;
import com.sun.electric.tool.user.dialogs.options.VerilogTab;
import com.sun.electric.tool.user.dialogs.options.WellCheckTab;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.tests.TestTab;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PreferencesFrame
extends EModelessDialog {
    private JSplitPane splitPane1;
    private JSplitPane splitPane2;
    private JTree optionTree;
    private JButton cancel;
    private JButton ok;
    private Map<Setting, Object> originalContext;
    private Map<Setting, Object> currentContext;
    private EditingPreferences editingPreferences;
    private List<PreferencePanel> optionPanes = new ArrayList<PreferencePanel>();
    private DefaultMutableTreeNode initialDMTN;
    private static PreferencesFrame currentOne;
    private static String currentTabName;
    private static String currentSectionName;
    private static String staClass;

    public static void preferencesCommand() {
        if (currentOne == null) {
            currentOne = new PreferencesFrame(TopLevel.getCurrentJFrame());
        }
        currentOne.setVisible(true);
    }

    public static void updateLayerPreferencesColors() {
        if (currentOne == null) {
            return;
        }
        if (!currentTabName.equals("Layers")) {
            return;
        }
        for (PreferencePanel ti : PreferencesFrame.currentOne.optionPanes) {
            if (!ti.getName().equals(currentTabName)) continue;
            ((LayersTab)ti).cacheLayerInfo(true);
        }
    }

    public static void updateLayersSortingTabs() {
        if (currentOne == null) {
            return;
        }
        for (PreferencePanel ti : PreferencesFrame.currentOne.optionPanes) {
            ti.refresh();
        }
    }

    public static void preferencesCommand(String tabName, String sectionName) {
        currentTabName = tabName;
        currentSectionName = sectionName + " ";
        PreferencesFrame.preferencesCommand();
    }

    public PreferencesFrame(Frame parent) {
        super(parent);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesFrame.this.closeDialog(evt);
            }
        });
        EDatabase database = EDatabase.clientDatabase();
        this.originalContext = database.getSettings();
        this.currentContext = new HashMap<Setting, Object>(this.originalContext);
        this.editingPreferences = UserInterfaceMain.getEditingPreferences();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Categories");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        DefaultMutableTreeNode generalSet = new DefaultMutableTreeNode("General ");
        rootNode.add(generalSet);
        this.addTreeNode(new GeneralTab(this, true), generalSet);
        this.addTreeNode(new SelectionTab(this, true), generalSet);
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top != null && top.getEMenuBar() != null) {
            this.addTreeNode(new EditKeyBindings(top.getEMenuBar(), this, true), generalSet);
        }
        this.addTreeNode(new NewNodesTab(this, true), generalSet);
        this.addTreeNode(new NewArcsTab(this, true), generalSet);
        this.addTreeNode(new ProjectManagementTab(this, true), generalSet);
        this.addTreeNode(new CVSTab(this, true), generalSet);
        this.addTreeNode(new PrintingTab(this, true), generalSet);
        if (Job.getDebug()) {
            this.addTreeNode(new TestTab(this, Boolean.TRUE), generalSet);
        }
        DefaultMutableTreeNode displaySet = new DefaultMutableTreeNode("Display ");
        rootNode.add(displaySet);
        this.addTreeNode(new DisplayControlTab(this, true), displaySet);
        this.addTreeNode(new ComponentMenuTab(this, true), displaySet);
        this.addTreeNode(new LayersTab(this, true), displaySet);
        this.addTreeNode(new ToolbarTab(this, true, this), displaySet);
        this.addTreeNode(new TextTab(this, true), displaySet);
        this.addTreeNode(new SmartTextTab(this, true), displaySet);
        this.addTreeNode(new GridAndAlignmentTab(this, true), displaySet);
        this.addTreeNode(new PortsAndExportsTab(this, true), displaySet);
        this.addTreeNode(new FrameTab(this, true), displaySet);
        this.addTreeNode(ThreeDTab.create3DTab(this, true), displaySet);
        DefaultMutableTreeNode ioSet = new DefaultMutableTreeNode("I/O ");
        rootNode.add(ioSet);
        this.addTreeNode(new CIFTab(this, true), ioSet);
        this.addTreeNode(new GDSTab(this, true), ioSet);
        this.addTreeNode(new EDIFTab(this, true), ioSet);
        this.addTreeNode(new DEFTab(this, true), ioSet);
        this.addTreeNode(new CDLTab(this, true), ioSet);
        this.addTreeNode(new DXFTab(this, true), ioSet);
        this.addTreeNode(new GerberTab(this, true), ioSet);
        this.addTreeNode(new LEFTab(this, true), ioSet);
        this.addTreeNode(new SUETab(this, true), ioSet);
        this.addTreeNode(new SVGTab(this, true), ioSet);
        if (IOTool.hasDais()) {
            this.addTreeNode(new DaisTab(this, true), ioSet);
        }
        if (IOTool.hasSkill()) {
            this.addTreeNode(new SkillTab(this, true), ioSet);
        }
        this.addTreeNode(new LibraryTab(this, true), ioSet);
        this.addTreeNode(new CopyrightTab(this, true), ioSet);
        DefaultMutableTreeNode toolSet = new DefaultMutableTreeNode("Tools ");
        rootNode.add(toolSet);
        this.addTreeNode(new AntennaRulesTab(this, true), toolSet);
        this.addTreeNode(new CompactionTab(this, true), toolSet);
        this.addTreeNode(new CoverageTab(this, true), toolSet);
        this.addTreeNode(new DRCTab(this, true), toolSet);
        this.addTreeNode(new FastHenryTab(this, true), toolSet);
        this.addTreeNode(new LogicalEffortTab(this, true), toolSet);
        this.addTreeNode(new NCCTab(parent, true), toolSet);
        this.addTreeNode(new NetworkTab(this, true), toolSet);
        this.addTreeNode(new ParasiticTab(this, true), toolSet);
        this.addTreeNode(new PlacementTab(this, true), toolSet);
        this.addTreeNode(new RoutingTab(this, true), toolSet);
        this.addTreeNode(new SiliconCompilerTab(this, true), toolSet);
        this.addTreeNode(new SimulatorsTab(this, true), toolSet);
        this.addTreeNode(new SpiceTab(this, true), toolSet);
        this.addTreeNode(new CellModelTab(this, true, CellModelPrefs.spiceModelPrefs), toolSet);
        if (this.getPluginPanel(staClass, this, true) != null) {
            this.addTreeNode(this.getPluginPanel(staClass, this, true), toolSet);
        }
        if (Routing.hasSunRouter()) {
            this.addTreeNode(new SunRouterTab(this, true), toolSet);
        }
        this.addTreeNode(new VerilogTab(this, true), toolSet);
        this.addTreeNode(new CellModelTab(this, true, CellModelPrefs.verilogModelPrefs), toolSet);
        this.addTreeNode(new WellCheckTab(this, true), toolSet);
        DefaultMutableTreeNode techSet = new DefaultMutableTreeNode("Technology ");
        rootNode.add(techSet);
        this.addTreeNode(new AddedTechnologiesTab(this, true), techSet);
        this.addTreeNode(new TechnologyTab(this, true), techSet);
        this.addTreeNode(new DesignRulesTab(this, true), techSet);
        this.addTreeNode(new ScaleTab(this, true), techSet);
        this.addTreeNode(new UnitsTab(this, true), techSet);
        this.addTreeNode(new IconTab(this, true), techSet);
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getNextMatch(currentSectionName, 0, null);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton save = new JButton("Export");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.exportActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)save, gbc);
        JButton restore = new JButton("Import");
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.importActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)restore, gbc);
        JButton reset = new JButton("Reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.resetActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 1, 4);
        leftPanel.add((Component)reset, gbc);
        JButton resetAll = new JButton("Reset All");
        resetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.resetAllActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 1, 4);
        leftPanel.add((Component)resetAll, gbc);
        JLabel explainReset = new JLabel("(Only resets USER Preferences)");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 4, 4, 4);
        leftPanel.add((Component)explainReset, gbc);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.helpActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)help, gbc);
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.applyActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)apply, gbc);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.cancelActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.cancel, gbc);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.ok, gbc);
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.splitPane1 = new JSplitPane(1);
        this.splitPane2 = new JSplitPane(1);
        this.loadOptionPanel();
        this.splitPane1.setLeftComponent(leftPanel);
        this.splitPane2.setRightComponent(this.splitPane1);
        EDialog.recursivelyHighlight(this.optionTree, rootNode, this.initialDMTN, this.optionTree.getPathForRow(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane2, gbc);
        this.finishInitialization();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferencesFrame.this.pack();
            }
        });
    }

    private void addTreeNode(PreferencePanel panel, DefaultMutableTreeNode theSet) {
        this.optionPanes.add(panel);
        String sectionName = (String)theSet.getUserObject();
        String name = panel.getName();
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(name);
        theSet.add(dmtn);
        if (sectionName.equals(currentSectionName) && name.equals(currentTabName)) {
            this.initialDMTN = dmtn;
        }
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private PreferencePanel getPluginPanel(String className, PreferencesFrame frame, boolean modal) {
        try {
            Class<?> panelClass = Class.forName(className);
            Object panel = panelClass.getConstructor(PreferencesFrame.class, Boolean.class).newInstance(frame, modal);
            return (PreferencePanel)panel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void cancelActionPerformed() {
        this.closeDialog(null);
    }

    private void okActionPerformed() {
        for (PreferencePanel ti : this.optionPanes) {
            if (!ti.isInited()) continue;
            ti.term();
        }
        UserInterfaceMain.setEditingPreferences(this.editingPreferences);
        Setting.SettingChangeBatch changeBatch = this.getChanged();
        if (changeBatch.changesForSettings.isEmpty()) {
            this.closeDialog(null);
            return;
        }
        new OKUpdate(this, changeBatch, true);
    }

    private Setting.SettingChangeBatch getChanged() {
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        for (Map.Entry<Setting, Object> e : this.originalContext.entrySet()) {
            Object v;
            Setting setting = e.getKey();
            Object oldVal = e.getValue();
            if (oldVal.equals(v = this.currentContext.get(setting))) continue;
            changeBatch.add(setting, v);
        }
        return changeBatch;
    }

    public Map<Setting, Object> getContext() {
        return this.currentContext;
    }

    public EditingPreferences getEditingPreferences() {
        return this.editingPreferences;
    }

    public void setEditingPreferences(EditingPreferences ep) {
        this.editingPreferences = ep;
    }

    private void applyActionPerformed() {
        for (PreferencePanel ti : this.optionPanes) {
            if (!ti.isInited()) continue;
            ti.term();
        }
        UserInterfaceMain.setEditingPreferences(this.editingPreferences);
    }

    private void resetActionPerformed() {
        for (PreferencePanel ti : this.optionPanes) {
            if (!ti.getName().equals(currentTabName)) continue;
            boolean response = Job.getUserInterface().confirmMessage("Do you really want to reset the " + ti.getName() + " Preferences to their 'factory' state?");
            if (!response) break;
            Pref.delayPrefFlushing();
            boolean inPlace = ti.resetThis();
            Pref.resumePrefFlushing();
            if (!inPlace) {
                ti.reset();
                UserInterfaceMain.setEditingPreferences(this.editingPreferences);
                this.closeDialog(null);
                WindowFrame.repaintAllWindows();
            }
            Setting.SettingChangeBatch changeBatch = this.getChanged();
            if (!changeBatch.changesForSettings.isEmpty()) {
                new OKUpdate(null, changeBatch, false);
            }
            return;
        }
    }

    private void resetAllActionPerformed() {
        boolean response = Job.getUserInterface().confirmMessage("Do you really want to reset all Preferences to their 'factory' state?");
        if (response) {
            Pref.delayPrefFlushing();
            for (PreferencePanel ti : this.optionPanes) {
                ti.reset();
            }
            UserInterfaceMain.setEditingPreferences(this.editingPreferences);
            Pref.resumePrefFlushing();
            this.closeDialog(null);
            WindowFrame.repaintAllWindows();
        }
    }

    private void helpActionPerformed() {
        ManualViewer.showPreferenceHelp(currentSectionName.trim() + "/" + currentTabName);
        this.closeDialog(null);
    }

    private void exportActionPerformed() {
        FileMenu.exportPrefsCommand();
    }

    private void importActionPerformed() {
        FileMenu.importPrefsCommand();
        this.closeDialog(null);
    }

    private void loadOptionPanel() {
        for (PreferencePanel ti : this.optionPanes) {
            JPanel prefs;
            if (!ti.getName().equals(currentTabName)) continue;
            if (!ti.isInited()) {
                ti.init();
                ti.setInited();
            }
            if ((prefs = ti.getUserPreferencesPanel()) == null) {
                this.splitPane1.setRightComponent(null);
            } else {
                JPanel pane = new JPanel();
                pane.setLayout(new GridBagLayout());
                JLabel prefLab = new JLabel(ti.getName() + " USER Preferences");
                prefLab.setForeground(Color.WHITE);
                prefLab.setHorizontalTextPosition(0);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.fill = 2;
                gbc.anchor = 11;
                gbc.weightx = 1.0;
                JPanel backgroundTitle = new JPanel();
                backgroundTitle.setBackground(Color.BLUE);
                backgroundTitle.add(prefLab);
                pane.add((Component)backgroundTitle, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.fill = 1;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                pane.add((Component)prefs, gbc);
                this.splitPane1.setRightComponent(pane);
            }
            JPanel ps = ti.getProjectPreferencesPanel();
            if (ps == null) {
                this.splitPane2.setLeftComponent(null);
            } else {
                JPanel pane = new JPanel();
                pane.setLayout(new GridBagLayout());
                JLabel prefLab = new JLabel(ti.getName() + " PROJECT Preferences");
                prefLab.setForeground(Color.WHITE);
                prefLab.setHorizontalTextPosition(0);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.fill = 2;
                gbc.anchor = 11;
                gbc.weightx = 1.0;
                JPanel backgroundTitle = new JPanel();
                backgroundTitle.setBackground(Color.BLUE);
                backgroundTitle.add(prefLab);
                pane.add((Component)backgroundTitle, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.fill = 1;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                pane.add((Component)ps, gbc);
                this.splitPane2.setLeftComponent(pane);
            }
            return;
        }
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed();
    }

    private void closeDialog(WindowEvent evt) {
        currentOne = null;
        this.setVisible(false);
        this.dispose();
    }

    static {
        currentTabName = "General";
        currentSectionName = "General ";
        staClass = "com.sun.electric.plugins.sctiming.STAOptionsDialog";
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private PreferencesFrame dialog;

        TreeHandler(PreferencesFrame dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (currentTabName.endsWith(" ")) {
                currentSectionName = currentTabName;
            } else {
                this.dialog.loadOptionPanel();
            }
            Point treeLocBefore = this.dialog.optionTree.getLocation();
            SwingUtilities.convertPointToScreen(treeLocBefore, this.dialog.optionTree);
            this.dialog.pack();
            Point treeLocAfter = this.dialog.optionTree.getLocation();
            SwingUtilities.convertPointToScreen(treeLocAfter, this.dialog.optionTree);
            Point dialogLocation = this.dialog.getLocation();
            int newX = dialogLocation.x + treeLocBefore.x - treeLocAfter.x;
            if (newX < 0) {
                newX = 0;
            }
            this.dialog.setLocation(newX, dialogLocation.y);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) {
                        DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)descentPath.getLastPathComponent();
                        currentSectionName = (String)subNode.getUserObject();
                        continue;
                    }
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }

    private static class OKUpdate
    extends Job {
        private transient PreferencesFrame dialog;
        private Setting.SettingChangeBatch changeBatch;
        private boolean issueWarning;
        private transient TechPool oldTechPool;

        private OKUpdate(PreferencesFrame dialog, Setting.SettingChangeBatch changeBatch, boolean issueWarning) {
            super("Update Project Preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.changeBatch = changeBatch;
            this.issueWarning = issueWarning;
            this.oldTechPool = this.getDatabase().getTechPool();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.getDatabase().implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
            this.getDatabase().getEnvironment().saveToPreferences();
            if (this.issueWarning) {
                if (ProjSettings.getLastProjectSettingsFile() != null) {
                    Job.getUserInterface().showInformationMessage("Warning: These changes are only valid for this session of Electric.\nTo save them permanently, use File -> Export -> Project Preferences", "Saving Project Preferences Changes");
                } else {
                    boolean saveAny = false;
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = it.next();
                        if (lib.isHidden() || lib.isChanged()) continue;
                        saveAny = true;
                    }
                    if (saveAny) {
                        int saveSettings;
                        int markCurrent;
                        String defaultOption;
                        Object[] options;
                        Library curLib = Library.getCurrent();
                        if (curLib == null || curLib.isChanged()) {
                            options = new String[]{"Mark All Libs", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[2];
                            markCurrent = 1000;
                            saveSettings = 1;
                        } else {
                            options = new String[]{"Mark All Libs", "Mark Lib \"" + curLib.getName() + "\"", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[0];
                            markCurrent = 1;
                            saveSettings = 2;
                        }
                        int i = JOptionPane.showOptionDialog(this.dialog, "Warning: Changed settings must be saved to Library or Project Preferences file.\nPlease choose which Libraries to mark for saving, or write project preferences file:", "Saving Project Preferences Changes", -1, 2, null, options, defaultOption);
                        if (i == 0) {
                            CircuitChangeJobs.markAllLibrariesForSavingCommand();
                        } else if (i == markCurrent) {
                            CircuitChangeJobs.markCurrentLibForSavingCommand();
                        } else if (i == saveSettings) {
                            ProjSettings.exportSettings();
                        }
                    }
                }
            }
            if (this.dialog != null) {
                this.dialog.closeDialog(null);
            }
            if (this.getDatabase().getTechPool() != this.oldTechPool) {
                CircuitChanges.checkAndRepairCommand(true);
            }
        }
    }
}

