(in-package 'maxima)

(proclaim '(optimize (safety 2)))
(defvar buf (make-string 100))
(defun $hello(target-host) ;; host is a maxima top-level string
  (setq target-host 
       (subseq (string target-host) 1)) ;; convert to lisp-level string
  (setq id (user::pvm-mytid))
  (cond ((not (equal (user::pvm-spawn "maxima-hello_other" 
          (si:getenv "HOST") 1 target-host 1 'psids) 1))
          (princ (list id '|can't start maxima-hello_other on| target-host))
        )
        (t 
	  (user::pvm-bufinfo (user::pvm-recv -1 -1) 'len 'code 'tid)
	  (user::pvm-upkstr 'buf)
	  (princ buf)
	  (user::pvm-upkstr 'buf)
	  (princ buf)
	)
))
