/* list.h

   written by D.R.Maszle
   28 October 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.list.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:15:02
      Author:  @a
   -- SCCS  ---------

*/


#ifndef LIST_INCLUDED

/* ----- Inclusions  */

#include "hungtype.h"

/* ----- Constants  */

/* ----- Enumerations  */

/* ----- Typedefs  */

typedef struct tagLISTELEM {	/* List element record */
  PVOID pData;			  /* User data, to be recast */
  struct tagLISTELEM *pleNext;	  /* Next in the list */

} LISTELEM, *PLISTELEM;  /* tagLISTELEM */


typedef struct tagLIST {	/* List header record */
  PLISTELEM pleHead;		  /* First elem in list */
  PLISTELEM pleTail;		  /* Last elem in list */
  
  int	iSize;			  /* Number of elems in list */
} LIST, *PLIST;   /* tagLIST */

					/* Callback function for ForAllList */
typedef int (*PFI_FORLISTCALLBACK) (PVOID pData, PVOID pUserInfo);

					/* Callback for FreeList() */
typedef void (*PFV_FREELISTCALLBACK) (PVOID pData);

/* ----- Macros  */

#define ListLength(plist)	((plist) ? (plist)->iSize : 0)
 

/* ----- Globals/Externals  */

/* ----- Prototypes  */


int  ForAllList (PLIST plist, PFI_FORLISTCALLBACK pfiForAllData, PVOID pInfo);
void FreeList(PLIST *pplist, PFV_FREELISTCALLBACK pfvFreeData, BOOL bAndData);

PLIST InitList (void);

void QueueListItem (PLIST plist, PVOID pData);

#define LIST_INCLUDED
#endif
