/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <config.h>

#include <stdlib.h>
#include <stdio.h>

#ifdef HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif

#include "wrappers.h"

extern void
die (msg)
     char *msg;
{
  fprintf (stderr, "motti: %s\n", msg);
  exit (1);
}

extern char *
alloc_err_str (err_no, file_name)
     enum motti_errors err_no;
     const char *file_name;
{
  char *str;
  const char *msg[] =
  {
    "can't find map file: %s",
    "invalid map file: %s",
    "can't open display: %s\ntry motti -n for text mode",
    /* Fix me.  */
    "malloc error",
    "can't find color: %s",
    "can't allocate a color: %s"
  };
  const int msg_len[] =
  {
    22, 19, 48, 13, 19, 25
  };
    
  str = (char *) my_malloc ((msg_len[err_no] + file_name == NULL ?
			     strlen (file_name) : 0) * sizeof (char));
  sprintf (str, msg[err_no], file_name);
  return str;
}

extern void *
my_malloc (size)
     size_t size;
{
  void *ptr;
  ptr = malloc(size);
  if (ptr == NULL && size != 0)
    die (alloc_err_str (ERR_MALLOC, ""));
  return ptr;
}

extern void *
my_calloc (nmemb, size)
     size_t nmemb, size;
{
  void *ptr;
  ptr = calloc (nmemb, size);
  if (ptr == NULL && size != 0)
    die (alloc_err_str (ERR_MALLOC, ""));
  return ptr;
}
