/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef GAMEMANAGER
#define GAMEMANAGER
#include "Drawer.h" 
#include "Board.h" 
#include "MottiRulesManager.h"
#include "MenuDrawable.h"
#include "CommandManager.h"
class GameManager
{
public:

	enum GAMESTATE{
		DIALOG_BOX,
		INGAME,
		INGAME_HELP,
		INGAME_SELECT_ACTION,
		INGAME_SAVE_GAME,
		INGAME_SELECT_PLAYERS,
		START_MENU,
		NEW_GAME,
		NEW_LOCAL_GAME,
		NEW_LOCAL_GAME_OPEN,
		OPTION_GAME,
		CONTINUE_GAME,
		NEW_GAME_GENERATE_MAP_SIZE,
		NEW_GAME_GENERATE_MAP_PLAYERS
	
	};


	GameManager(Drawer *dr,Board *b);
	virtual ~GameManager(void);
	void init();
	Player *getActualPlayer();
	Player *getPlayer(int );
	void attack(Player *,int ,int);
	void unattack(Player *,int ,int);
	void defend(Player *,int ,int);
	void undefend(Player *,int ,int);

	void guerilla(Player *,int ,int);
	void unguerilla(Player *,int ,int);

	void endTurn();
	RandomGenerator &getRandomGenerator();
	void manageGame();
	
	
private :	
	Drawer *drawer_;
	Board *board_;
	CommandManager commManager_;
	MottiRulesManager rulesManager_;
	void manageStarMenu(CommandManager::ACTIONKEY KEY);
	void manageNewMenu(CommandManager::ACTIONKEY KEY);
	void manageNewLocalMenu(CommandManager::ACTIONKEY KEY);
	void manageNewLocalGenerateMapSize(CommandManager::ACTIONKEY KEY);
	void manageNewLocalGenerateMapPls(CommandManager::ACTIONKEY KEY);
	void manageNewLocalOMenu(CommandManager::ACTIONKEY KEY);
	void manageMenu(CommandManager::ACTIONKEY KEY);
	void manageInGameSave(CommandManager::ACTIONKEY KEY);
	void manageInGame(CommandManager::ACTIONKEY KEY);
	void manageInGameHelp(CommandManager::ACTIONKEY KEY);
	void manageInGameSelectAction(CommandManager::ACTIONKEY KEY);
	void manageInGameSelectPlayer(CommandManager::ACTIONKEY KEY);
	void setStringBoxEle(CommandManager::ACTIONKEY KEY,int index);
	void transitionStarMenu();
	void transitionNewMenu();
	void transitionNewLocalMenu();
	void transitionNewLocalOpenMenu();
	void transitionInNameHelp();
	void transitionInGameSelect();
	void transitionInGameSelectPlayer();
	void transitionMapSize();
	void transitionMapPlayers();
	void transitionInGameSave(CommandManager::ACTIONKEY KEY);
	std::vector<std::string> listDir(std::string direrc);
	GAMESTATE actualState_;
	GAMESTATE previousState_;
	void setStarMenu();
	void setNewMenu();
	void setNewLocalMenu();
	void setNewLocalOpenMenu();
	void setInGameHelp();
	void setInGameSave();
	void setInGameSelectAction();
	void setInGameSelectPlayer();
	void setMapSize();
	void setMapPlayer();
	int actualIndexMenu_;
	MenuDrawable *myMenu_;
	MessageBoxDrawable *meesBox_;
	std::string actualDir_;
	void decIndexMenu();
	void incIndexMenu();
	bool isGameOldFormat(std::string pp);
	bool isGameSavedFormat(std::string filename);
	bool isDir(std::string);
	std::vector<BoxElement *> listLabelDir(std::string direrc);
	bool filterMottiSavedGame_;
	bool filterMottiMap_;
	bool firstTime_;

	int xsizeGen;
	int ysizeGen;
	int playersGen;

};

#endif

