#!BPY
"""
Name: 'Polierdi Platonici'
Blender: 248
Group: 'Add'
Tip: 'Create platonici.'
"""

__author__ = ["Stefano Selleri"]
__url__ = ("http://wiki.blender.org/index.php/Scripts/Manual/Add/Poliedri_Platonici")
__version__ = "248 - 2008-10"

__bpydoc__ = """\

A script to generate the five Platonic Polyhedrons.

and to rotate them freely along their principal axis.

Many Object types can be created.

Simple platonic objects.

Also much more Complex objects.

Numerical input for precise object creation.

Slider input for experimenting.

This script can add several useful primitive objects to Blender
.\n\
"""
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright ((C) 2001 Stefano Selleri
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------
#
# Poliedri platonici in BLENDER
#
# (C) 2001 Stefano Selleri
#
#     Un ringraziamento a Martin (Theeth) che mi
#     ha spiegato un po' di cose.
#
#     Un altro a tHe-IcemAn per lo stimolo a
#     mettere tutto in matrici
#
#     A me il Perl piace tanto di piu'...
#
######################################################
# Vers. 0.0.0 17 Gennaio 2002 
# Vers. 0.0.2 22 Gennaio 2002 + Matrici e cicli
######################################################

# Importazioni e moduli
import Blender
from Blender import NMesh
from Blender.Draw import *
from Blender.BGL import * 
import math
from math import *

# Definizione del Poliedro
Tn=Create(2)
Tl=Create(1.0)

# Rotazione Poliedrica
Trat=Create(0)
Tran=Create(1)
Trav=Create(0.0)

# Rotazione alla Blender
Trx=Create(0.0)
Try=Create(0.0)
Trz=Create(0.0)

# Matrici di Definizione vertici
VertsT = [[-0.5,+0.5,0.,0.],
          [-0.28867513459481,-0.28867513459481,0.577350269189635,0.],
          [-0.20412414523193,-0.20412414523193,-0.20412414523193,0.6123724356957]]
FacesT = [[0,0,1,2],[2,1,2,0],[1,3,3,3]]

VertsC = [[-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5],
          [-0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5],
          [-0.5,-0.5,-0.5,-0.5,0.5,0.5,0.5,0.5]]
FacesC = [[0,0,0,0,1,1,2,2,3,3,4,4],
          [3,2,1,5,2,6,3,7,0,4,5,6],
          [2,1,5,4,6,5,7,6,4,7,6,7]]

VertsO = [[0.,-0.5,0.5,0.5,-0.5,0.],
          [0.,-0.5,-0.5,0.5,0.5,0.],
          [-0.70710678118655,0.,0.,0.,0.,0.70710678118655]]
FacesO = [[0,0,0,0,2,3,4,1],
          [2,3,4,1,5,5,5,5],
          [1,2,3,4,1,2,3,4]]

VertsD = [[-0.5,0.5,0.80901699437495,0.,-0.80901699437495,
           -0.80901699437495,0.,+0.80901699437495,+1.30901699437495,+1.30901699437495,
           0.80901699437495,0.,-0.80901699437495,-1.30901699437495,-1.30901699437495,
           0.,0.80901699437495,0.5,-0.5,-0.80901699437495,],
          [-0.68819096023559,-0.68819096023559,0.26286555605957,0.85065080835204,0.26286555605957,
           -1.11351636441161,-1.37638192047117,-1.11351636441161,-0.42532540417602,0.42532540417602,
           1.11351636441161,1.37638192047117,1.11351636441161,0.42532540417602,-0.42532540417602,
           -0.85065080835204,-0.26286555605957,0.68819096023559,0.68819096023559,-0.26286555605957,],
          [-1.11351636441161,-1.11351636441161,-1.11351636441161,-1.11351636441161,-1.11351636441161,
           -0.26286555605957,0.26286555605957,-0.26286555605957,0.26286555605957,-0.26286555605957,
           0.26286555605957,-0.26286555605957,0.26286555605957,-0.26286555605957,0.26286555605957,
           1.11351636441161,1.11351636441161,1.11351636441161,1.11351636441161,1.11351636441161]]
FacesD = [[0,0,0,0,0,0,1,1,1, 2, 2, 2, 3, 3, 3,4, 4, 4,16,16,16,17,17,17,18,18,18,19,19,19,15,15,15,17,17,17],
          [4,3,2,1,7,6,2,9,8, 3,11,10, 4,13,12,0, 5,14,15, 6, 7,16, 8, 9,17,10,11,18,12,13,19,14, 5,18,19,15],
          [3,2,1,7,6,5,9,8,7,11,10, 9,13,12,11,5,14,13, 6, 7, 8, 8, 9,10,10,11,12,12,13,14,14, 5, 6,19,15,16]]

VertsI = [[0.,-0.5,0.5,0.80901699437495,0.,-0.80901699437495,
           0.,0.80901699437495,0.5,-0.5,-0.80901699437495,0.],
          [0.,-0.68819096023559,-0.68819096023559,0.26286555605957,0.85065080835204,0.26286555605957,
           -0.85065080835204,-0.26286555605957,0.68819096023559,0.68819096023559,-0.26286555605957,0.],
          [-0.95105651629515,-0.42532540417602,-0.42532540417602,-0.42532540417602,-0.42532540417602,-0.42532540417602,
           0.42532540417602,0.42532540417602,0.42532540417602,0.42532540417602,0.42532540417602,0.95105651629515]]
FacesI = [[0,0,0,0,0,1,2,3,4, 5,2,3,4, 5, 1, 6, 7, 8, 9,10],
          [2,3,4,5,1,2,3,4,5, 1,7,8,9,10, 6, 7, 8, 9,10, 6],
          [1,2,3,4,5,6,7,8,9,10,6,7,8, 9,10,11,11,11,11,11]]
	  
# Matrici di Rotazione
Axis   = [[4,4,3,10,6],[3,6,6,15,15],[4,3,4,6,10]]
MaxAN  = 4

# Ragazzi, che pazienza che ci vuole...
AxisTT = [[0.,1.91063323624902,1.91063323624902,1.91063323624902],
          [0.95531661812451,0.95531661812451,0.95531661812451,0.0],
          [3.14159265358979,1.23095941734077,1.23095941734077,1.23095941734077]]
AxisTP = [[0.,1.57079632679490,3.66519142918809,5.75958653158129],
          [1.57079632679490,3.66519142918809,5.75958653158129,0.],
          [0.,-1.57079632679490,0.52359877559830,2.61799387799149]]

AxisCT = [[0.95531661812451,0.95531661812451,0.95531661812451,0.95531661812451,0.,0.],
          [0.78539816339745,0.78539816339745,0.78539816339745,0.78539816339745,1.57079632679490,1.57079632679490],
          [0.,1.57079632679490,1.57079632679490,0.,0.,0.]]
AxisCP = [[0.78539816339745,2.35619449019234,3.92699081698724,5.49778714378214,0.,0.],
          [0.,1.57079632679490,3.14159265358979,4.71238898038469,0.78539816339745,2.35619449019234],
          [0.,0.,1.57079632679490,0.,0.,0.]]

AxisOT = [[0.,1.57079632679490,1.57079632679490,0.,0.,0.],
          [0.7853981633974,0.7853981633974,0.7853981633974,0.7853981633974,1.57079632679490,1.57079632679490],
          [0.61547970867039,0.61547970867039,0.61547970867039,0.61547970867039,0.,0.]]
AxisOP = [[0.,0.78539816339745,2.35619449019234,0.,0.,0.],
          [0.78539816339745,2.35619449019234,3.92699081698724,5.49778714378214,0.,1.57079632679490],
          [0.,1.57079632679490,3.14159265358979,4.71238898038469,0.,0.]]

AxisDT = [[0.65235813978437,0.65235813978437,0.65235813978437,0.65235813978437,0.65235813978437,
           1.38208579601133,1.38208579601133,1.38208579601133,1.38208579601133,1.38208579601133,
           0.,0.,0.,0.,0.],
          [0.55357435889705,0.55357435889705,0.55357435889705,0.55357435889705,0.55357435889705,
           1.01722196789785,1.01722196789785,1.01722196789785,1.01722196789785,1.01722196789785,
           1.57079632679490,1.57079632679490,1.57079632679490,1.57079632679490,1.57079632679490],
          [0.,1.10714871779409,1.10714871779409,1.10714871779409,1.10714871779409,1.10714871779409,
           0.,0.,0.,0.,0.,0.,0.,0.,0.]]

AxisDP = [[-1.57079632679490,-0.31415926535898,0.94247779607694,2.19911485751286,3.45575191894877,
           -1.57079632679490,-0.31415926535898,0.94247779607694,2.19911485751286,3.45575191894877,
           0.,0.,0.,0.,0.],
          [1.57079632679490,2.82743338823081,4.08407044966673,5.34070751110265,6.59734457253857,
           -1.57079632679490,-0.31415926535898,0.94247779607694,2.19911485751286,3.45575191894877,
           -1.25663706143592,0.,1.25663706143592,2.51327412287183,3.76991118430775],
          [0.,1.57079632679490,2.82743338823081,4.08407044966673,5.34070751110265,6.59734457253857,
           0.,0.,0.,0.,0.,0.,0.,0.,0.]]

AxisIT = [[0.,1.10714871779409,1.10714871779409,1.10714871779409,1.10714871779409,1.10714871779409,
           0.,0.,0.,0.,0.,0.,0.,0.,0.],
          [0.55357435889705,0.55357435889705,0.55357435889705,0.55357435889705,0.55357435889705,
           1.01722196789785,1.01722196789785,1.01722196789785,1.01722196789785,1.01722196789785,
           1.57079632679490,1.57079632679490,1.57079632679490,1.57079632679490,1.57079632679490],
          [0.65235813978431,0.65235813978431,0.65235813978431,0.65235813978431,0.65235813978431,
           1.38208579601134,1.38208579601134,1.38208579601134,1.38208579601134,1.38208579601134,
           0.,0.,0.,0.,0.]]
AxisIP = [[0.,-1.57079632679490,-0.31415926535898,0.94247779607694,2.19911485751286,3.45575191894877,
           0.,0.,0.,0.,0.,0.,0.,0.,0.],
          [-1.57079632679490,-0.31415926535898,0.94247779607694,2.19911485751286,3.45575191894877,
           1.57079632679490,2.82743338823081,4.08407044966673,5.34070751110265,6.59734457253857,
           -1.25663706143592,0.,1.25663706143592,2.51327412287183,3.76991118430775],
          [1.57079632679490,2.82743338823081,4.08407044966673,5.34070751110265,6.59734457253857,
           1.57079632679490,2.82743338823081,4.08407044966673,5.34070751110265,6.59734457253857,
           0.,0.,0.,0.,0.]]

#
# Il corpo principale...
#
def polyhedron(n,l,rx,ry,rz):
    me = NMesh.GetRaw()
    nverts = 0
    
    # Crea
    if (n==1):
        nv = 4
        nf = 4
        setpoly(me,nv,nf,VertsT,FacesT)
        theta = AxisTT[Trat.val][Tran.val-1]
        phi   = AxisTP[Trat.val][Tran.val-1]
        
    if (n==2):
        nv=8
        nf=12
        setpoly(me,nv,nf,VertsC,FacesC)
        theta = AxisCT[Trat.val][Tran.val-1]
        phi   = AxisCP[Trat.val][Tran.val-1]
        
    if (n==3):
        nv=6
        nf=8
        setpoly(me,nv,nf,VertsO,FacesO)
        theta = AxisOT[Trat.val][Tran.val-1]
        phi   = AxisOP[Trat.val][Tran.val-1]
        
    if (n==4):
        nv=20
        nf=36
        setpoly(me,nv,nf,VertsD,FacesD)
        theta = AxisDT[Trat.val][Tran.val-1]
        phi   = AxisDP[Trat.val][Tran.val-1]
        
    if (n==5):
        nv=12
        nf=20
        setpoly(me,nv,nf,VertsI,FacesI)
        theta = AxisIT[Trat.val][Tran.val-1]
        phi   = AxisIP[Trat.val][Tran.val-1]
        
    # Rotazione Poliedrica
    alpha = Trav.val*3.14159265358979/180
    
    ct    = cos(theta)
    st    = sin(theta)

    cp    = cos(phi)
    sp    = sin(phi)

    ca    = cos(alpha)
    sa    = sin(alpha)

    for i in range(0,nv):
        x1a    = me.verts[i].co[0]
        x2a    = me.verts[i].co[1]
        x3a    = me.verts[i].co[2]

        # Rotazione dell'asse z sull'asse di rotazione
        x1b = x1a*ct*cp+x2a*ct*sp-x3a*st
        x2b = -x1a*sp+x2a*cp
        x3b = x1a*st*cp+x2a*st*sp+x3a*ct 
        # Rotazione di alfa
        x1c = x1b*ca-x2b*sa
        x2c = x1b*sa+x2b*ca
        x3c =               x3b
        # Riallineamento dell'asse z
        me.verts[i].co[0] = x1c*ct*cp-x2c*sp+x3c*st*cp
        me.verts[i].co[1] = x1c*ct*sp+x2c*cp+x3c*st*sp
        me.verts[i].co[2] = -x1c*st         +x3c*ct  

    obj = NMesh.PutRaw(me)

    # Ridimensiona
    obj.SizeX=l
    obj.SizeY=l
    obj.SizeZ=l

    # Rotazione alla Blender
    obj.RotX=rx*3.14159265358979/180
    obj.RotY=ry*3.14159265358979/180
    obj.RotZ=rz*3.14159265358979/180
    
    Blender.Redraw()

def draw():
    global Tn,Tl,Trat,Tran,Trav,Trx,Try,Trz,MaxAN
    glClear(GL_COLOR_BUFFER_BIT)
    #Titolone
    glRasterPos2d(8, 283)
    Text("Plato Polyhedrons")
    glRasterPos2d(8, 263)
    Text("(C) Jan. 2002 Stefano Selleri <a.k.a. S68>")
    #
    glRasterPos2d(8, 243)
    Text("Basics:")
    Tn=Slider("Polyhedron type  : ", 4, 10, 220, 340, 18,Tn.val, 1, 5,0,
              "1=Tetrahedron, 2=Exahedron(cube), 3=octahedron, 4=dodecahedron, 5=icosahedron")
    Tl=Slider("Polyhedron side  : ", 2, 10, 200, 340, 18, Tl.val, 0.0, 10.0,0,
              "Side of a edge, in Blender Units")
    #
    glRasterPos2d(8, 183)
    Text("Rotation around a symmetry axis:")
    Trat=Slider("Axis Type      : ", 4, 10, 160, 340, 18, Trat.val, 0, 2,0,
                "0=A0 (vertex), 1=A1 (edge), 2=A2 (face)")
    Tran=Slider("Axis Number    : ", 2, 10, 140, 340, 18, Tran.val, 1, MaxAN,0,
                "Axis number within its family")
    Trav=Slider("Rotation Angle : ", 2, 10, 120, 340, 18, Trav.val, 0.0, 360.0,0,
                "Rotation, in degrees, around the axis")
    #
    glRasterPos2d(8, 103)
    Text("Additional rotation (Blender standard):")
    Trx=Slider("Axis X rotation : ", 2, 10, 80, 340, 18, Trx.val, 0.0, 180.0)
    Try=Slider("Axis Y rotation : ", 2, 10, 60, 340, 18, Try.val, 0.0, 360.0)
    Trz=Slider("Axis Z rotation : ", 2, 10, 40, 340, 18, Trz.val, 0.0, 360.0)
  
    #Exit button
    Button("Exit", 1, 60, 10, 80, 19)
    #Create Button
    Button("Create", 3, 140, 10, 80, 19)

def setpoly(me,nv,nf,Verts,Faces):
    for i in range (0,nv):
        v = NMesh.Vert(Verts[0][i],Verts[1][i],Verts[2][i])
        me.verts.append(v)
        
    for i in range (0,nf):
        f=NMesh.Face()
        f.v.append(me.verts[Faces[0][i]])  
        f.v.append(me.verts[Faces[1][i]])  
        f.v.append(me.verts[Faces[2][i]])
        f.smooth=0
        me.faces.append(f)
        
def event(evt, val):	
      if (evt== QKEY and not val): Exit()

def bevent(evt):
      global Tn,Tl,Trat,Tran,Trav,Trx,Try,Trz,MaxAN
      if   (evt== 1): Exit()
      elif (evt== 3):
          polyhedron(Tn.val,Tl.val,Trx.val,Try.val,Trz.val)
          Blender.Redraw()
      elif (evt== 4):
          MaxAN=Axis[Trat.val][Tn.val-1]
          if (Tran.val>MaxAN):
              Tran.val=MaxAN
          Blender.Redraw()

Register(draw, event, bevent)
