#!BPY
""" Released under the Blender Artistic Licence (BAL)
Name: 'Render Pick Camera'
Blender: 248
Group: 'Render'
Tooltip: 'Fast-switch current cam.'
"""
__author__ = "pat"
__version__ = "1.1a - 01/10/05 -"
__email__ = ('Author, pat:psycho3d*de')
__url__ = ("Author's website, www.psycho3d.de")
__bpydoc__ ="""\
This script gives you a list of the cams in your current scene for easier rendering of different views.

Hotkeys:<br>
   [Q]uit
"""
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008 pat:psycho3d*de
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

import Blender as b
from Blender.BGL import *
from Blender.Draw import *

menutext = "Camera%t|*** update list ***"
list = Create(1)

sce = b.Scene.GetCurrent()
camlist = []


def updateList():
	global menutext, camlist, sce
	
	sce = b.Scene.GetCurrent()
	camlist = []
	menutext = "Camera%t|*** update list ***"
	
	oblist = sce.objects
	i=len(oblist)
	while i > 0:
		i -= 1
		if oblist[i].getType() == "Camera":
			camlist.append(oblist[i])
			menutext += "|%s" % oblist[i].getName()
	Redraw()

def renderCams():
	global sce
	if list.val >= 2:
		sce.setCurrentCamera(camlist[list.val - 2])
		sce.getRenderingContext().render()
	else:
		PupMenu("Error%t|Please update list and choose camera!")


def gui():
	global list
	col = b.Window.Theme.Get()[0].get("buts").back
	glClearColor(col[0]/255., col[1]/255., col[2]/255., col[3]/255.)
	glClear(GL_COLOR_BUFFER_BIT)
	PushButton("Exit", 1, 10, 10, 100, 20)
	PushButton("Render", 5, 120, 10, 100, 20, "Renders the selected cam")
	list = Menu(menutext, 2, 10, 40, 210, 20, list.val)

def event(evt, val):
  if (evt == QKEY and not val): Exit()
	
def bevent(evt):
	if (evt == 1): Exit()
	elif (evt == 2):
		if (list.val) == 1: updateList()
	elif (evt == 5): renderCams()

Register(gui, event, bevent)
updateList()