/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_data_ScriptTagProxy({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.data.DataProxy","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='docClass'>Ext.data.DataProxy</a><div class='subclass '><strong>Ext.data.ScriptTagProxy</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy' target='_blank'>ScriptTagProxy.js</a></div></pre><div class='doc-contents'><p>An implementation of <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> that reads a data object from a URL which may be in a domain\nother than the originating domain of the running page.<br></p>\n\n<p>\n<b>Note that if you are retrieving data from a page that is in a domain that is NOT the same as the originating domain\nof the running page, you must use this class, rather than HttpProxy.</b><br>\n<p>\nThe content passed back from a server resource requested by a ScriptTagProxy <b>must</b> be executable JavaScript\nsource code because it is used as the source inside a &lt;script> tag.<br>\n<p>\nIn order for the browser to process the returned data, the server must wrap the data object\nwith a call to a callback function, the name of which is passed as a parameter by the ScriptTagProxy.\nBelow is a Java example for a servlet which returns data for either a ScriptTagProxy, or an HttpProxy\ndepending on whether the callback name was passed:\n<p>\n<pre><code>boolean scriptTag = false;\nString cb = request.getParameter(\"callback\");\nif (cb != null) {\n    scriptTag = true;\n    response.setContentType(\"text/javascript\");\n} else {\n    response.setContentType(\"application/x-json\");\n}\nWriter out = response.getWriter();\nif (scriptTag) {\n    out.write(cb + \"(\");\n}\nout.print(dataBlock.toJsonString());\nif (scriptTag) {\n    out.write(\");\");\n}\n</code></pre>\n<p>Below is a PHP example to do the same thing:</p>\n<pre><code>$callback = $_REQUEST['callback'];\n\n// Create the output object.\n$output = array('a' => 'Apple', 'b' => 'Banana');\n\n//start output\nif ($callback) {\n    header('Content-Type: text/javascript');\n    echo $callback . '(' . json_encode($output) . ');';\n} else {\n    header('Content-Type: application/x-json');\n    echo json_encode($output);\n}\n</code></pre>\n<p>Below is the ASP.Net code to do the same thing:</p>\n<pre><code>String jsonString = \"{success: true}\";\nString cb = Request.Params.Get(\"callback\");\nString responseString = \"\";\nif (!String.IsNullOrEmpty(cb)) {\n    responseString = cb + \"(\" + jsonString + \")\";\n} else {\n    responseString = jsonString;\n}\nResponse.Write(responseString);\n</code></pre>\n\n</p></p></p></p></div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-api' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-cfg-api' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-cfg-api' class='name expandable'>api</a><span> : Object</span></div><div class='description'><div class='short'>Specific urls to call on CRUD action methods \"read\", \"create\", \"update\" and \"destroy\". ...</div><div class='long'><p>Specific urls to call on CRUD action methods \"read\", \"create\", \"update\" and \"destroy\".\nDefaults to:</p>\n\n<pre><code>api: {\n    read    : undefined,\n    create  : undefined,\n    update  : undefined,\n    destroy : undefined\n}\n</code></pre>\n\n\n<p>The url is built based upon the action being executed <tt>[load|create|save|destroy]</tt>\nusing the commensurate <tt><a href=\"#!/api/Ext.data.DataProxy-cfg-api\" rel=\"Ext.data.DataProxy-cfg-api\" class=\"docClass\">api</a></tt> property, or if undefined default to the\nconfigured <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>.<a href=\"#!/api/Ext.data.Store-cfg-url\" rel=\"Ext.data.Store-cfg-url\" class=\"docClass\">url</a>.</p>\n\n\n<br>\n\n\n<p>For example:</p>\n\n\n<pre><code>api: {\n    load :    '/controller/load',\n    create :  '/controller/new',  // Server MUST return idProperty of new record\n    save :    '/controller/update',\n    destroy : '/controller/destroy_action'\n}\n\n// Alternatively, one can use the object-form to specify each API-action\napi: {\n    load: {url: 'read.php', method: 'GET'},\n    create: 'create.php',\n    destroy: 'destroy.php',\n    save: 'update.php'\n}\n</code></pre>\n\n\n<p>If the specific URL for a given CRUD action is undefined, the CRUD action request\nwill be directed to the configured <tt><a href=\"#!/api/Ext.data.Connection-cfg-url\" rel=\"Ext.data.Connection-cfg-url\" class=\"docClass\">url</a></tt>.</p>\n\n\n<br><p><b>Note</b>: To modify the URL for an action dynamically the appropriate API\n\n\n<p>property should be modified before the action is requested using the corresponding before\naction event.  For example to modify the URL associated with the load action:</p>\n\n<pre><code>// modify the url for the action\nmyStore.on({\n    beforeload: {\n        fn: function (store, options) {\n            // use <tt><a href=\"#!/api/Ext.data.HttpProxy-method-setUrl\" rel=\"Ext.data.HttpProxy-method-setUrl\" class=\"docClass\">setUrl</a></tt> to change the URL for *just* this request.\n            store.proxy.setUrl('changed1.php');\n\n            // set optional second parameter to true to make this URL change\n            // permanent, applying this URL for all subsequent requests.\n            store.proxy.setUrl('changed1.php', true);\n\n            // Altering the proxy API should be done using the public\n            // method <tt><a href=\"#!/api/Ext.data.DataProxy-method-setApi\" rel=\"Ext.data.DataProxy-method-setApi\" class=\"docClass\">setApi</a></tt>.\n            store.proxy.setApi('read', 'changed2.php');\n\n            // Or set the entire API with a config-object.\n            // When using the config-object option, you must redefine the <b>entire</b>\n            // API -- not just a specific action of it.\n            store.proxy.setApi({\n                read    : 'changed_read.php',\n                create  : 'changed_create.php',\n                update  : 'changed_update.php',\n                destroy : 'changed_destroy.php'\n            });\n        }\n    }\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-callbackParam' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-cfg-callbackParam' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-cfg-callbackParam' class='name expandable'>callbackParam</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The name of the parameter to pass to the server which tells\nthe server the name of the callback function s...</div><div class='long'><p>(Optional) The name of the parameter to pass to the server which tells\nthe server the name of the callback function set up by the load call to process the returned data object.\nDefaults to \"callback\".<p>The server-side processing must read this parameter value, and generate\njavascript output which calls this named function passing the data object as its only parameter.</p>\n</p><p>Defaults to: <code>&quot;callback&quot;</code></p></div></div></div><div id='cfg-doRequest' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-cfg-doRequest' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-cfg-doRequest' class='name expandable'>doRequest</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Abstract method that should be implemented in all subclasses. ...</div><div class='long'><p>Abstract method that should be implemented in all subclasses.  <b>Note:</b> Should only be used by custom-proxy developers.\n(e.g.: <a href=\"#!/api/Ext.data.HttpProxy-method-doRequest\" rel=\"Ext.data.HttpProxy-method-doRequest\" class=\"docClass\">HttpProxy.doRequest</a>,\n<a href=\"#!/api/Ext.data.DirectProxy-method-doRequest\" rel=\"Ext.data.DirectProxy-method-doRequest\" class=\"docClass\">DirectProxy.doRequest</a>).</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-nocache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-cfg-nocache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-cfg-nocache' class='name expandable'>nocache</a><span> : Boolean</span></div><div class='description'><div class='short'>(optional) Defaults to true. ...</div><div class='long'><p>(optional) Defaults to true. Disable caching by adding a unique parameter\nname to the request.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-onRead' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-cfg-onRead' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-cfg-onRead' class='name expandable'>onRead</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Abstract method that should be implemented in all subclasses. ...</div><div class='long'><p>Abstract method that should be implemented in all subclasses.  <b>Note:</b> Should only be used by custom-proxy developers.  Callback for read <a href=\"#!/api/Ext.data.Api-property-actions\" rel=\"Ext.data.Api-property-actions\" class=\"docClass\">action</a>.</p>\n</div></div></div><div id='cfg-onWrite' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-cfg-onWrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-cfg-onWrite' class='name expandable'>onWrite</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Abstract method that should be implemented in all subclasses. ...</div><div class='long'><p>Abstract method that should be implemented in all subclasses.  <b>Note:</b> Should only be used by custom-proxy developers.  Callback for <i>create, update and destroy</i> <a href=\"#!/api/Ext.data.Api-property-actions\" rel=\"Ext.data.Api-property-actions\" class=\"docClass\">actions</a>.</p>\n</div></div></div><div id='cfg-restful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-cfg-restful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-cfg-restful' class='name expandable'>restful</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to false. ...</div><div class='long'><p>Defaults to <tt>false</tt>.  Set to <tt>true</tt> to operate in a RESTful manner.</p>\n\n\n<br><p> Note: this parameter will automatically be set to <tt>true</tt> if the\n\n\n<p><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> it is plugged into is set to <code>restful: true</code>. If the\nStore is RESTful, there is no need to set this option on the proxy.</p></p>\n\n<br><p>RESTful implementations enable the serverside framework to automatically route\n\n\n<p>actions sent to one url based upon the HTTP method, for example:</p>\n\n<pre><code>store: new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({\n    restful: true,\n    proxy: new <a href=\"#!/api/Ext.data.HttpProxy\" rel=\"Ext.data.HttpProxy\" class=\"docClass\">Ext.data.HttpProxy</a>({url:'/users'}); // all requests sent to /users\n    ...\n)}\n</code></pre>\n\n\n<p>If there is no <code><a href=\"#!/api/Ext.data.DataProxy-cfg-api\" rel=\"Ext.data.DataProxy-cfg-api\" class=\"docClass\">api</a></code> specified in the configuration of the proxy,\nall requests will be marshalled to a single RESTful url (/users) so the serverside\nframework can inspect the HTTP Method and act accordingly:</p>\n\n<pre><u>Method</u>   <u>url</u>        <u>action</u>\nPOST     /users     create\nGET      /users     read\nPUT      /users/23  update\nDESTROY  /users/23  delete\n</pre>\n\n\n<p></p></p>\n\n<p>If set to <tt>true</tt>, a <a href=\"#!/api/Ext.data.Record-property-phantom\" rel=\"Ext.data.Record-property-phantom\" class=\"docClass\">non-phantom</a> record's\n<a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">id</a> will be appended to the url. Some MVC (e.g., Ruby on Rails,\nMerb and Django) support segment based urls where the segments in the URL follow the\nModel-View-Controller approach:\n<pre><code>someSite.com/controller/action/id\n</code></pre>\nWhere the segments in the url are typically:<div class=\"mdetail-params\"><ul>\n<li>The first segment : represents the controller class that should be invoked.</li>\n<li>The second segment : represents the class function, or method, that should be called.</li>\n<li>The third segment : represents the ID (a variable typically passed to the method).</li>\n</ul></div></p>\n\n\n<br><p>Refer to <code><a href=\"#!/api/Ext.data.DataProxy-cfg-api\" rel=\"Ext.data.DataProxy-cfg-api\" class=\"docClass\">api</a></code> for additional information.</p>\n\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-timeout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-cfg-timeout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-cfg-timeout' class='name expandable'>timeout</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>(optional) The number of milliseconds to wait for a response. ...</div><div class='long'><p>(optional) The number of milliseconds to wait for a response. Defaults to 30 seconds.</p>\n<p>Defaults to: <code>30000</code></p></div></div></div><div id='cfg-url' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-cfg-url' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-cfg-url' class='name not-expandable'>url</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The URL from which to request the data object.</p>\n</div><div class='long'><p>The URL from which to request the data object.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.ScriptTagProxy-method-constructor' class='name expandable'>Ext.data.ScriptTagProxy</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.data.ScriptTagProxy\" rel=\"Ext.data.ScriptTagProxy\" class=\"docClass\">Ext.data.ScriptTagProxy</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>A configuration object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.ScriptTagProxy\" rel=\"Ext.data.ScriptTagProxy\" class=\"docClass\">Ext.data.ScriptTagProxy</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-abort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-method-abort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-method-abort' class='name expandable'>abort</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Abort the current server request. ...</div><div class='long'><p>Abort the current server request.</p>\n</div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-buildUrl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-buildUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-buildUrl' class='name expandable'>buildUrl</a>( <span class='pre'>action, record</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>buildUrl\nSets the appropriate url based upon the action being executed. ...</div><div class='long'><p>buildUrl\nSets the appropriate url based upon the action being executed.  If restful is true, and only a single record is being acted upon,\nurl will be built Rails-style, as in \"/controller/action/32\".  restful will aply iff the supplied record is an\ninstance of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> rather than an Array of them.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The api action being executed [read|create|update|destroy]</p>\n</div></li><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>/<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>The record or Array of Records being acted upon.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>url</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys the proxy by purging any event listeners and cancelling any active requests. ...</div><div class='long'><p>Destroys the proxy by purging any event listeners and cancelling any active requests.</p>\n</div></div></div><div id='method-doRequest' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-method-doRequest' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-method-doRequest' class='name expandable'>doRequest</a>( <span class='pre'>action, rs, params, reader, callback, scope, arg</span> )</div><div class='description'><div class='short'>HttpProxy implementation of DataProxy#doRequest ...</div><div class='long'><p>HttpProxy implementation of DataProxy#doRequest</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rs</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>/<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]<div class='sub-desc'><p>If action is <tt>read</tt>, rs will be null</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>An object containing properties which are to be used as HTTP parameters\nfor the request to the remote server.</p>\n</div></li><li><span class='pre'>reader</span> : <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Ext.data.DataReader</a><div class='sub-desc'><p>The Reader object which converts the data\nobject into a block of Ext.data.Records.</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function into which to pass the block of Ext.data.Records.\nThe function must be passed <ul>\n<li>The Record block object</li>\n<li>The \"arg\" argument from the load function</li>\n<li>A boolean success indicator</li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the callback function is executed. Defaults to the browser window.</p>\n</div></li><li><span class='pre'>arg</span> : Object<div class='sub-desc'><p>An optional argument which is passed to the callback as its second parameter.</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-isApiAction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-isApiAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-isApiAction' class='name expandable'>isApiAction</a>( <span class='pre'>action</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the specified action is defined as a unique action in the api-config. ...</div><div class='long'><p>Returns true if the specified action is defined as a unique action in the api-config.\nrequest.  If all API-actions are routed to unique urls, the xaction parameter is unecessary.  However, if no api is defined\nand all Proxy actions are routed to DataProxy#url, the server-side will require the xaction parameter to perform a switch to\nthe corresponding code for CRUD action.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>CREATE READ UPDATE or DESTROY</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-load' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-load' class='name expandable'>load</a>( <span class='pre'>params, reader, callback, scope, arg</span> )<strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Deprecated load method using old method signature. ...</div><div class='long'><p><b>Deprecated</b> load method using old method signature. See {@doRequest} for preferred method.</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        \n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>reader</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>arg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onRead' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-method-onRead' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-method-onRead' class='name expandable'>onRead</a>( <span class='pre'>action, trans, res</span> )<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Callback for read actions ...</div><div class='long'><p>Callback for read actions</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|read|update|destroy]</p>\n</div></li><li><span class='pre'>trans</span> : Object<div class='sub-desc'><p>The request transaction object</p>\n</div></li><li><span class='pre'>res</span> : Object<div class='sub-desc'><p>The server response</p>\n</div></li></ul></div></div></div><div id='method-onWrite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-method-onWrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-method-onWrite' class='name expandable'>onWrite</a>( <span class='pre'>action, trans, res</span> )<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Callback for write actions ...</div><div class='long'><p>Callback for write actions</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|read|update|destroy]</p>\n</div></li><li><span class='pre'>trans</span> : Object<div class='sub-desc'><p>The request transaction object</p>\n</div></li><li><span class='pre'>res</span> : Object<div class='sub-desc'><p>The server response</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-request' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-request' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-request' class='name expandable'>request</a>( <span class='pre'>action, rs, params, reader, callback, scope, options</span> )</div><div class='description'><div class='short'>All proxy actions are executed through this method. ...</div><div class='long'><p>All proxy actions are executed through this method.  Automatically fires the \"before\" + action event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Name of the action</p>\n</div></li><li><span class='pre'>rs</span> : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>/<a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>[]/null<div class='sub-desc'><p>Will be null when action is 'load'</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>reader</span> : <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Ext.data.DataReader</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the callback function is executed. Defaults to the Proxy object.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>Any options specified for the action (e.g. see <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">Ext.data.Store.load</a>.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setApi' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-method-setApi' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-method-setApi' class='name expandable'>setApi</a>( <span class='pre'>api, url</span> )</div><div class='description'><div class='short'>Redefines the Proxy's API or a single action of an API. ...</div><div class='long'><p>Redefines the Proxy's API or a single action of an API. Can be called with two method signatures.</p>\n\n\n<p>If called with an object as the only parameter, the object should redefine the <b>entire</b> API, e.g.:</p>\n\n\n<pre><code>proxy.setApi({\n    read    : '/users/read',\n    create  : '/users/create',\n    update  : '/users/update',\n    destroy : '/users/destroy'\n});\n</code></pre>\n\n\n<p>If called with two parameters, the first parameter should be a string specifying the API action to\nredefine and the second parameter should be the URL (or function if using DirectProxy) to call for that action, e.g.:</p>\n\n\n<pre><code>proxy.setApi(Ext.data.Api.actions.read, '/users/new_load_url');\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>api</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>An API specification object, or the name of an action.</p>\n</div></li><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The URL (or function if using DirectProxy) to call for the action.</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-beforeload' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-event-beforeload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-event-beforeload' class='name expandable'>beforeload</a>( <span class='pre'>this, params</span> )</div><div class='description'><div class='short'>Fires before a request to retrieve a data object. ...</div><div class='long'><p>Fires before a request to retrieve a data object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : DataProxy<div class='sub-desc'><p>The proxy for the request</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>The params object passed to the <a href=\"#!/api/Ext.data.DataProxy-method-request\" rel=\"Ext.data.DataProxy-method-request\" class=\"docClass\">request</a> function</p>\n</div></li></ul></div></div></div><div id='event-beforewrite' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-event-beforewrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-event-beforewrite' class='name expandable'>beforewrite</a>( <span class='pre'>this, action, rs, params</span> )</div><div class='description'><div class='short'>Fires before a request is generated for one of the actions Ext.data.Api.actions.create|update|destroy\n\n\nIn addition t...</div><div class='long'><p>Fires before a request is generated for one of the actions Ext.data.Api.actions.create|update|destroy</p>\n\n\n<p>In addition to being fired through the DataProxy instance that raised the event, this event is also fired\nthrough the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> <i>class</i> to allow for centralized processing of beforewrite events from <b>all</b>\nDataProxies by attaching a listener to the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> class itself.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : DataProxy<div class='sub-desc'><p>The proxy for the request</p>\n</div></li><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|update|destroy]</p>\n</div></li><li><span class='pre'>rs</span> : Record/Record[]<div class='sub-desc'><p>The Record(s) to create|update|destroy.</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>The request <code>params</code> object.  Edit <code>params</code> to add parameters to the request.</p>\n</div></li></ul></div></div></div><div id='event-exception' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-event-exception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-event-exception' class='name expandable'>exception</a>( <span class='pre'>this, type, action, options, response, arg</span> )</div><div class='description'><div class='short'>Fires if an exception occurs in the Proxy during a remote request. ...</div><div class='long'><p>Fires if an exception occurs in the Proxy during a remote request. This event is relayed\nthrough a corresponding <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>.<a href=\"#!/api/Ext.data.Store-event-exception\" rel=\"Ext.data.Store-event-exception\" class=\"docClass\">exception</a>,\nso any Store instance may observe this event.</p>\n\n\n<p>In addition to being fired through the DataProxy instance that raised the event, this event is also fired\nthrough the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> <i>class</i> to allow for centralized processing of exception events from <b>all</b>\nDataProxies by attaching a listener to the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> class itself.</p>\n\n\n<p>This event can be fired for one of two reasons:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li>remote-request <b>failed</b> : <div class=\"sub-desc\">\nThe server did not return status === 200.\n</div></li>\n<li>remote-request <b>succeeded</b> : <div class=\"sub-desc\">\nThe remote-request succeeded but the reader could not read the response.\nThis means the server returned data, but the configured Reader threw an\nerror while reading the response.  In this case, this event will be\nraised and the caught error will be passed along into this event.\n</div></li>\n</ul></div>\n\n\n<br><p>This event fires with two different contexts based upon the 2nd\n\n\n<p>parameter <tt>type [remote|response]</tt>.  The first four parameters\nare identical between the two contexts -- only the final two parameters\ndiffer.</p></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : DataProxy<div class='sub-desc'><p>The proxy that sent the request</p>\n</div></li><li><span class='pre'>type</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value of this parameter will be either <tt>'response'</tt> or <tt>'remote'</tt>.</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><b><tt>'response'</tt></b> : <div class=\"sub-desc\">\n<p>An <b>invalid</b> response from the server was returned: either 404,\n500 or the response meta-data does not match that defined in the DataReader\n(e.g.: root, idProperty, successProperty).</p>\n</div></li>\n<li><b><tt>'remote'</tt></b> : <div class=\"sub-desc\">\n<p>A <b>valid</b> response was returned from the server having\nsuccessProperty === false.  This response might contain an error-message\nsent from the server.  For example, the user may have failed\nauthentication/authorization or a database validation error occurred.</p>\n</div></li>\n</ul></div>\n\n</div></li><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Name of the action (see <a href=\"#!/api/Ext.data.Api-property-actions\" rel=\"Ext.data.Api-property-actions\" class=\"docClass\">Ext.data.Api.actions</a>.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options for the action that were specified in the <a href=\"#!/api/Ext.data.DataProxy-method-request\" rel=\"Ext.data.DataProxy-method-request\" class=\"docClass\">request</a>.</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The value of this parameter depends on the value of the <code>type</code> parameter:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><b><tt>'response'</tt></b> : <div class=\"sub-desc\">\n<p>The raw browser response object (e.g.: XMLHttpRequest)</p>\n</div></li>\n<li><b><tt>'remote'</tt></b> : <div class=\"sub-desc\">\n<p>The decoded response object sent from the server.</p>\n</div></li>\n</ul></div>\n\n</div></li><li><span class='pre'>arg</span> : Mixed<div class='sub-desc'><p>The type and value of this parameter depends on the value of the <code>type</code> parameter:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><b><tt>'response'</tt></b> : Error<div class=\"sub-desc\">\n<p>The JavaScript Error object caught if the configured Reader could not read the data.\nIf the remote request returns success===false, this parameter will be null.</p>\n</div></li>\n<li><b><tt>'remote'</tt></b> : Record/Record[]<div class=\"sub-desc\">\n<p>This parameter will only exist if the <tt>action</tt> was a <b>write</b> action\n(Ext.data.Api.actions.create|update|destroy).</p>\n</div></li>\n</ul></div>\n\n</div></li></ul></div></div></div><div id='event-load' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-event-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-event-load' class='name expandable'>load</a>( <span class='pre'>this, o, options</span> )</div><div class='description'><div class='short'>Fires before the load method's callback is called. ...</div><div class='long'><p>Fires before the load method's callback is called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : DataProxy<div class='sub-desc'><p>The proxy for the request</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The request transaction object</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The callback's <tt>options</tt> property as passed to the <a href=\"#!/api/Ext.data.DataProxy-method-request\" rel=\"Ext.data.DataProxy-method-request\" class=\"docClass\">request</a> function</p>\n</div></li></ul></div></div></div><div id='event-loadexception' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.ScriptTagProxy'>Ext.data.ScriptTagProxy</span><br/><a href='source/ScriptTagProxy.html#Ext-data-ScriptTagProxy-event-loadexception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.ScriptTagProxy-event-loadexception' class='name expandable'>loadexception</a>( <span class='pre'>this, options, arg, e</span> )</div><div class='description'><div class='short'>Deprecated in favor of 'exception' event. ...</div><div class='long'><p><b>Deprecated</b> in favor of 'exception' event.\nFires if an exception occurs in the Proxy during data loading.  This event can be fired for one of two reasons:</p>\n\n<ul><li><b>The load call timed out.</b>  This means the load callback did not execute within the time limit\nspecified by <a href=\"#!/api/Ext.data.ScriptTagProxy-cfg-timeout\" rel=\"Ext.data.ScriptTagProxy-cfg-timeout\" class=\"docClass\">timeout</a>.  In this case, this event will be raised and the\nfourth parameter (read error) will be null.</li>\n<li><b>The load succeeded but the reader could not read the response.</b>  This means the server returned\ndata, but the configured Reader threw an error while reading the data.  In this case, this event will be\nraised and the caught error will be passed along as the fourth parameter of this event.</li></ul>\n\n\n<p>Note that this event is also relayed through <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>, so you can listen for it directly\non any Store instance.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The loading options that were specified (see <a href=\"#!/api/Ext.data.ScriptTagProxy-event-load\" rel=\"Ext.data.ScriptTagProxy-event-load\" class=\"docClass\">load</a> for details).  If the load\ncall timed out, this parameter will be null.</p>\n</div></li><li><span class='pre'>arg</span> : Object<div class='sub-desc'><p>The callback's arg object passed to the <a href=\"#!/api/Ext.data.ScriptTagProxy-event-load\" rel=\"Ext.data.ScriptTagProxy-event-load\" class=\"docClass\">load</a> function</p>\n</div></li><li><span class='pre'>e</span> : Error<div class='sub-desc'><p>The JavaScript Error object caught if the configured Reader could not read the data.\nIf the remote request returns success: false, this parameter will be null.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.data.DataProxy-event-loadexception' rel='Ext.data.DataProxy-event-loadexception' class='docClass'>Ext.data.DataProxy.loadexception</a></p></div></div></div><div id='event-write' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.DataProxy' rel='Ext.data.DataProxy' class='defined-in docClass'>Ext.data.DataProxy</a><br/><a href='source/DataProxy.html#Ext-data-DataProxy-event-write' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.DataProxy-event-write' class='name expandable'>write</a>( <span class='pre'>this, action, data, response, rs, options</span> )</div><div class='description'><div class='short'>Fires before the request-callback is called\n\n\nIn addition to being fired through the DataProxy instance that raised t...</div><div class='long'><p>Fires before the request-callback is called</p>\n\n\n<p>In addition to being fired through the DataProxy instance that raised the event, this event is also fired\nthrough the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> <i>class</i> to allow for centralized processing of write events from <b>all</b>\nDataProxies by attaching a listener to the <a href=\"#!/api/Ext.data.DataProxy\" rel=\"Ext.data.DataProxy\" class=\"docClass\">Ext.data.DataProxy</a> class itself.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : DataProxy<div class='sub-desc'><p>The proxy that sent the request</p>\n</div></li><li><span class='pre'>action</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>[Ext.data.Api.actions.create|upate|destroy]</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>The data object extracted from the server-response</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The decoded response from server</p>\n</div></li><li><span class='pre'>rs</span> : Record/Record[]<div class='sub-desc'><p>The Record(s) from Store</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The callback's <tt>options</tt> property as passed to the <a href=\"#!/api/Ext.data.DataProxy-method-request\" rel=\"Ext.data.DataProxy-method-request\" class=\"docClass\">request</a> function</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.data.DataProxy"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"ScriptTagProxy.html#Ext-data-ScriptTagProxy","filename":"ScriptTagProxy.js"}],"linenr":1,"members":{"property":[],"cfg":[{"tagname":"cfg","owner":"Ext.data.DataProxy","meta":{},"name":"api","id":"cfg-api"},{"tagname":"cfg","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"callbackParam","id":"cfg-callbackParam"},{"tagname":"cfg","owner":"Ext.data.DataProxy","meta":{},"name":"doRequest","id":"cfg-doRequest"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"nocache","id":"cfg-nocache"},{"tagname":"cfg","owner":"Ext.data.DataProxy","meta":{"protected":true},"name":"onRead","id":"cfg-onRead"},{"tagname":"cfg","owner":"Ext.data.DataProxy","meta":{"protected":true},"name":"onWrite","id":"cfg-onWrite"},{"tagname":"cfg","owner":"Ext.data.DataProxy","meta":{},"name":"restful","id":"cfg-restful"},{"tagname":"cfg","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"timeout","id":"cfg-timeout"},{"tagname":"cfg","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"url","id":"cfg-url"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"abort","id":"method-abort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{"private":true},"name":"buildUrl","id":"method-buildUrl"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"doRequest","id":"method-doRequest"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{},"name":"isApiAction","id":"method-isApiAction"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{"deprecated":{"text":""}},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.data.ScriptTagProxy","meta":{"protected":true},"name":"onRead","id":"method-onRead"},{"tagname":"method","owner":"Ext.data.ScriptTagProxy","meta":{"protected":true},"name":"onWrite","id":"method-onWrite"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{},"name":"request","id":"method-request"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.data.DataProxy","meta":{},"name":"setApi","id":"method-setApi"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.data.DataProxy","meta":{},"name":"beforeload","id":"event-beforeload"},{"tagname":"event","owner":"Ext.data.DataProxy","meta":{},"name":"beforewrite","id":"event-beforewrite"},{"tagname":"event","owner":"Ext.data.DataProxy","meta":{},"name":"exception","id":"event-exception"},{"tagname":"event","owner":"Ext.data.DataProxy","meta":{},"name":"load","id":"event-load"},{"tagname":"event","owner":"Ext.data.ScriptTagProxy","meta":{},"name":"loadexception","id":"event-loadexception"},{"tagname":"event","owner":"Ext.data.DataProxy","meta":{},"name":"write","id":"event-write"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.data.ScriptTagProxy","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.data.ScriptTagProxy","mixins":[],"mixedInto":[]});