=begin comment

Fastly API

Via the Fastly API you can perform any of the operations that are possible within the management console,  including creating services, domains, and backends, configuring rules or uploading your own application code, as well as account operations such as user administration and billing reports. The API is organized into collections of endpoints that allow manipulation of objects related to Fastly services and accounts. For the most accurate and up-to-date API reference content, visit our [Developer Hub](https://www.fastly.com/documentation/reference/api/) 

The version of the API Spec document: 1.0.0
Contact: oss@fastly.com

=end comment

=cut

#
# NOTE: This class is auto generated.
# Do not edit the class manually.
#
package WebService::Fastly::Object::AutomationTokenResponse;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON::MaybeXS qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use WebService::Fastly::Object::AutomationToken;
use WebService::Fastly::Object::AutomationTokenResponseAllOf;
use WebService::Fastly::Object::ReadOnlyCustomerId;
use WebService::Fastly::Object::ReadOnlyId;
use WebService::Fastly::Object::Timestamps;

use base ("Class::Accessor", "Class::Data::Inheritable");

#
#
#
# NOTE: This class is auto generated. Do not edit the class manually.
#

=begin comment

Fastly API

Via the Fastly API you can perform any of the operations that are possible within the management console,  including creating services, domains, and backends, configuring rules or uploading your own application code, as well as account operations such as user administration and billing reports. The API is organized into collections of endpoints that allow manipulation of objects related to Fastly services and accounts. For the most accurate and up-to-date API reference content, visit our [Developer Hub](https://www.fastly.com/documentation/reference/api/) 

The version of the API Spec document: 1.0.0
Contact: oss@fastly.com

=end comment

=cut

#
# NOTE: This class is auto generated.
# Do not edit the class manually.
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('openapi_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {});
__PACKAGE__->mk_classdata('class_documentation' => {});
__PACKAGE__->mk_classdata('openapi_nullable' => {});

# new plain object
sub new {
    my ($class, %args) = @_;

    my $self = bless {}, $class;

    $self->init(%args);

    return $self;
}

# initialize the object
sub init
{
    my ($self, %args) = @_;

    foreach my $attribute (keys %{$self->attribute_map}) {
        my $args_key = $self->attribute_map->{$attribute};
        $self->$attribute( $args{ $args_key } );
    }
}

# return perl hash
sub to_hash {
    my $self = shift;
    my $_hash = decode_json(JSON()->new->allow_blessed->convert_blessed->encode($self));

    return $_hash;
}

# used by JSON for serialization
sub TO_JSON {
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
    }

    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use openapi_types to deserialize the data
    while ( my ($_key, $_type) = each %{$self->openapi_types} ) {
        my $_json_attribute = $self->attribute_map->{$_key};
        my $_is_nullable = ($self->openapi_nullable->{$_key} || 'false') eq 'true';
        if ($_type =~ /^array\[(.+)\]$/i) { # array
            my $_subclass = $1;
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize($_subclass, $_element, $_is_nullable);
            }
            $self->{$_key} = \@_array;
        } elsif ($_type =~ /^hash\[string,(.+)\]$/i) { # hash
            my $_subclass = $1;
            my %_hash = ();
            while (my($_key, $_element) = each %{$hash->{$_json_attribute}}) {
                $_hash{$_key} = $self->_deserialize($_subclass, $_element, $_is_nullable);
            }
            $self->{$_key} = \%_hash;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute}, $_is_nullable);
        } else {
            $log->debugf("Warning: %s (%s) does not exist in input hash\n", $_key, $_json_attribute);
        }
    }

    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data, $is_nullable) = @_;
    $log->debugf("deserializing %s with %s",Dumper($data), $type);

    if (!(defined $data) && $is_nullable) {
        return undef;
    }
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $_instance = eval "WebService::Fastly::Object::$type->new()";
        return $_instance->from_hash($data);
    }
}


__PACKAGE__->class_documentation({description => '',
                                  class => 'AutomationTokenResponse',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'name' => {
        datatype => 'string',
        base_name => 'name',
        description => 'The name of the token.',
        format => '',
        read_only => 'false',
            },
    'role' => {
        datatype => 'string',
        base_name => 'role',
        description => '',
        format => '',
        read_only => 'false',
            },
    'services' => {
        datatype => 'ARRAY[string]',
        base_name => 'services',
        description => '(Optional) The service IDs of the services the token will have access to. Separate service IDs with a space. If no services are specified, the token will have access to all services on the account. ',
        format => '',
        read_only => 'false',
            },
    'scope' => {
        datatype => 'string',
        base_name => 'scope',
        description => 'A space-delimited list of authorization scope.',
        format => '',
        read_only => 'false',
            },
    'expires_at' => {
        datatype => 'string',
        base_name => 'expires_at',
        description => '(optional) A UTC time-stamp of when the token will expire.',
        format => '',
        read_only => 'false',
            },
    'created_at' => {
        datatype => 'string',
        base_name => 'created_at',
        description => 'A UTC time-stamp of when the token was created.',
        format => '',
        read_only => 'false',
            },
    'deleted_at' => {
        datatype => 'DateTime',
        base_name => 'deleted_at',
        description => 'Date and time in ISO 8601 format.',
        format => 'date-time',
        read_only => 'true',
            },
    'updated_at' => {
        datatype => 'DateTime',
        base_name => 'updated_at',
        description => 'Date and time in ISO 8601 format.',
        format => 'date-time',
        read_only => 'true',
            },
    'id' => {
        datatype => 'ReadOnlyId',
        base_name => 'id',
        description => '',
        format => '',
        read_only => 'false',
            },
    'customer_id' => {
        datatype => 'ReadOnlyCustomerId',
        base_name => 'customer_id',
        description => '',
        format => '',
        read_only => 'false',
            },
    'ip' => {
        datatype => 'string',
        base_name => 'ip',
        description => 'The IP address of the client that last used the token.',
        format => '',
        read_only => 'false',
            },
    'user_agent' => {
        datatype => 'string',
        base_name => 'user_agent',
        description => 'The User-Agent header of the client that last used the token.',
        format => '',
        read_only => 'false',
            },
    'sudo_expires_at' => {
        datatype => 'string',
        base_name => 'sudo_expires_at',
        description => '',
        format => '',
        read_only => 'true',
            },
    'last_used_at' => {
        datatype => 'DateTime',
        base_name => 'last_used_at',
        description => 'A UTC time-stamp of when the token was last used.',
        format => 'date-time',
        read_only => 'true',
            },
});

__PACKAGE__->openapi_types( {
    'name' => 'string',
    'role' => 'string',
    'services' => 'ARRAY[string]',
    'scope' => 'string',
    'expires_at' => 'string',
    'created_at' => 'string',
    'deleted_at' => 'DateTime',
    'updated_at' => 'DateTime',
    'id' => 'ReadOnlyId',
    'customer_id' => 'ReadOnlyCustomerId',
    'ip' => 'string',
    'user_agent' => 'string',
    'sudo_expires_at' => 'string',
    'last_used_at' => 'DateTime'
} );

__PACKAGE__->attribute_map( {
    'name' => 'name',
    'role' => 'role',
    'services' => 'services',
    'scope' => 'scope',
    'expires_at' => 'expires_at',
    'created_at' => 'created_at',
    'deleted_at' => 'deleted_at',
    'updated_at' => 'updated_at',
    'id' => 'id',
    'customer_id' => 'customer_id',
    'ip' => 'ip',
    'user_agent' => 'user_agent',
    'sudo_expires_at' => 'sudo_expires_at',
    'last_used_at' => 'last_used_at'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});

__PACKAGE__->openapi_nullable( {
    'deleted_at' => 'true',
    'updated_at' => 'true',
} );


1;
