# Generated by default/object.tt
package Paws::Amplify::AutoBranchCreationConfig;
  use Moose;
  has BasicAuthCredentials => (is => 'ro', isa => 'Str', request_name => 'basicAuthCredentials', traits => ['NameInRequest']);
  has BuildSpec => (is => 'ro', isa => 'Str', request_name => 'buildSpec', traits => ['NameInRequest']);
  has EnableAutoBuild => (is => 'ro', isa => 'Bool', request_name => 'enableAutoBuild', traits => ['NameInRequest']);
  has EnableBasicAuth => (is => 'ro', isa => 'Bool', request_name => 'enableBasicAuth', traits => ['NameInRequest']);
  has EnablePerformanceMode => (is => 'ro', isa => 'Bool', request_name => 'enablePerformanceMode', traits => ['NameInRequest']);
  has EnablePullRequestPreview => (is => 'ro', isa => 'Bool', request_name => 'enablePullRequestPreview', traits => ['NameInRequest']);
  has EnvironmentVariables => (is => 'ro', isa => 'Paws::Amplify::EnvironmentVariables', request_name => 'environmentVariables', traits => ['NameInRequest']);
  has Framework => (is => 'ro', isa => 'Str', request_name => 'framework', traits => ['NameInRequest']);
  has PullRequestEnvironmentName => (is => 'ro', isa => 'Str', request_name => 'pullRequestEnvironmentName', traits => ['NameInRequest']);
  has Stage => (is => 'ro', isa => 'Str', request_name => 'stage', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Amplify::AutoBranchCreationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Amplify::AutoBranchCreationConfig object:

  $service_obj->Method(Att1 => { BasicAuthCredentials => $value, ..., Stage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Amplify::AutoBranchCreationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->BasicAuthCredentials

=head1 DESCRIPTION

Describes the automated branch creation configuration.

=head1 ATTRIBUTES


=head2 BasicAuthCredentials => Str

The basic authorization credentials for the autocreated branch.


=head2 BuildSpec => Str

The build specification (build spec) for the autocreated branch.


=head2 EnableAutoBuild => Bool

Enables auto building for the autocreated branch.


=head2 EnableBasicAuth => Bool

Enables basic authorization for the autocreated branch.


=head2 EnablePerformanceMode => Bool

Enables performance mode for the branch.

Performance mode optimizes for faster hosting performance by keeping
content cached at the edge for a longer interval. When performance mode
is enabled, hosting configuration or code changes can take up to 10
minutes to roll out.


=head2 EnablePullRequestPreview => Bool

Enables pull request previews for the autocreated branch.


=head2 EnvironmentVariables => L<Paws::Amplify::EnvironmentVariables>

The environment variables for the autocreated branch.


=head2 Framework => Str

The framework for the autocreated branch.


=head2 PullRequestEnvironmentName => Str

The Amplify environment name for the pull request.


=head2 Stage => Str

Describes the current stage for the autocreated branch.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Amplify>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

