#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   * Fix incorrect assumption that Win32 is missing sys/time.h
#     in all cases.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- ulib/uuid/uuid.h.new	Tue Jan  2 06:08:23 2024
+++ ulib/uuid/uuid.h	Tue Jan  2 14:48:25 2024
@@ -35,8 +35,10 @@
 #ifndef _UUID_UUID_H
 #define _UUID_UUID_H
 
+#include "config.h"
+
 #include <sys/types.h>
-#ifndef _WIN32
+#if ! defined(_WIN32) && defined(HAVE_SYS_TIME_H)
 #include <sys/time.h>
 #endif
 #include <time.h>

