/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_1;

import org.jdom.Element;
import org.jdom.Namespace;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.WcsDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class WcsRequest {
    protected static final Namespace wcsNS = Namespace.getNamespace("http://www.opengis.net/wcs");
    protected static final Namespace gmlNS = Namespace.getNamespace("gml", "http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    private Request.Operation operation;
    private String version;
    private WcsDataset dataset;

    WcsRequest(Request.Operation operation, String version, WcsDataset dataset) {
        this.operation = operation;
        this.version = version;
        this.dataset = dataset;
        if (operation == null) {
            throw new IllegalArgumentException("Non-null operation required.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Request.Operation getOperation() {
        return this.operation;
    }

    public String getVersion() {
        return this.version;
    }

    public WcsDataset getDataset() {
        return this.dataset;
    }

    protected Element genCoverageOfferingBriefElem(String elemName, String covName, String covLabel, String covDescription, GridCoordSystem gridCoordSys) {
        Element briefElem = new Element(elemName, wcsNS);
        if (covDescription != null && !covDescription.equals("")) {
            briefElem.addContent(new Element("description", wcsNS).addContent(covDescription));
        }
        briefElem.addContent(new Element("name", wcsNS).addContent(covName));
        briefElem.addContent(new Element("label", wcsNS).addContent(covLabel));
        briefElem.addContent(this.genLonLatEnvelope(gridCoordSys));
        return briefElem;
    }

    protected Element genLonLatEnvelope(GridCoordSystem gcs) {
        Element lonLatEnvelopeElem = new Element("lonLatEnvelope", wcsNS);
        lonLatEnvelopeElem.setAttribute("srsName", "urn:ogc:def:crs:OGC:1.3:CRS84");
        LatLonRect llbb = gcs.getLatLonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        String firstPosition = llpt.getLongitude() + " " + llpt.getLatitude();
        double lon = llpt.getLongitude() + llbb.getWidth();
        String secondPosition = lon + " " + urpt.getLatitude();
        lonLatEnvelopeElem.addContent(new Element("pos", gmlNS).addContent(firstPosition));
        lonLatEnvelopeElem.addContent(new Element("pos", gmlNS).addContent(secondPosition));
        if (gcs.hasTimeAxis()) {
            lonLatEnvelopeElem.addContent(new Element("timePosition", gmlNS).addContent(gcs.getDateRange().getStart().toDateTimeStringISO()));
            lonLatEnvelopeElem.addContent(new Element("timePosition", gmlNS).addContent(gcs.getDateRange().getEnd().toDateTimeStringISO()));
        }
        return lonLatEnvelopeElem;
    }
}

