/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.AreaOpImage;
import javax.media.jai.ColorModelFactory;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRecycler;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;

public abstract class OpImage
extends PlanarImage {
    public static final int OP_COMPUTE_BOUND = 1;
    public static final int OP_IO_BOUND = 2;
    public static final int OP_NETWORK_BOUND = 3;
    private static final int LAYOUT_MASK_ALL = 1023;
    protected transient TileCache cache;
    protected Object tileCacheMetric;
    private transient TileScheduler scheduler = JAI.getDefaultInstance().getTileScheduler();
    private boolean isSunTileScheduler = false;
    protected boolean cobbleSources;
    private boolean isDisposed = false;
    private boolean isCachedTileRecyclingEnabled = false;
    protected TileRecycler tileRecycler;
    private RasterFormatTag[] formatTags = null;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector, Map map) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RenderedImage renderedImage;
        ImageLayout imageLayout2 = imageLayout;
        if (vector != null) {
            OpImage.checkSourceVector(vector, true);
        }
        RenderedImage renderedImage2 = renderedImage = vector != null && vector.size() > 0 && vector.firstElement() instanceof RenderedImage ? (RenderedImage)vector.firstElement() : null;
        if (renderedImage != null) {
            if (imageLayout == null) {
                imageLayout2 = imageLayout = new ImageLayout(renderedImage);
                imageLayout2.unsetValid(512);
            } else {
                imageLayout2 = new ImageLayout(imageLayout.getMinX(renderedImage), imageLayout.getMinY(renderedImage), imageLayout.getWidth(renderedImage), imageLayout.getHeight(renderedImage), imageLayout.getTileGridXOffset(renderedImage), imageLayout.getTileGridYOffset(renderedImage), imageLayout.getTileWidth(renderedImage), imageLayout.getTileHeight(renderedImage), imageLayout.getSampleModel(renderedImage), null);
            }
            if (imageLayout.isValid(512) && imageLayout.getColorModel(null) == null) {
                imageLayout2.setColorModel(null);
            } else if (imageLayout2.getSampleModel(null) != null) {
                object4 = imageLayout2.getSampleModel(null);
                object3 = imageLayout.getColorModel(null);
                if (object3 != null) {
                    if (JDKWorkarounds.areCompatibleDataModels((SampleModel)object4, (ColorModel)object3)) {
                        imageLayout2.setColorModel((ColorModel)object3);
                    } else if (imageLayout.getSampleModel(null) == null) {
                        imageLayout2.setColorModel((ColorModel)object3);
                        object2 = ((ColorModel)object3).createCompatibleSampleModel(imageLayout2.getTileWidth(null), imageLayout2.getTileHeight(null));
                        imageLayout2.setSampleModel((SampleModel)object2);
                    }
                }
                if (!imageLayout2.isValid(512) && !OpImage.setColorModelFromFactory((SampleModel)object4, vector, map, imageLayout2) && (object2 = renderedImage.getColorModel()) != null && JDKWorkarounds.areCompatibleDataModels((SampleModel)object4, (ColorModel)object2)) {
                    if (object2 != null && object2 instanceof IndexColorModel && map != null && map.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL) && ((Boolean)map.get(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)).booleanValue()) {
                        object = PlanarImage.getDefaultColorModel(((SampleModel)object4).getDataType(), ((ColorModel)object2).getNumComponents());
                        SampleModel sampleModel = object != null ? ((ColorModel)object).createCompatibleSampleModel(imageLayout2.getTileWidth(null), imageLayout2.getTileHeight(null)) : RasterFactory.createPixelInterleavedSampleModel(((SampleModel)object4).getDataType(), imageLayout2.getTileWidth(null), imageLayout2.getTileHeight(null), ((ColorModel)object2).getNumComponents());
                        imageLayout2.setSampleModel(sampleModel);
                        if (object != null) {
                            imageLayout2.setColorModel((ColorModel)object);
                        }
                    } else {
                        imageLayout2.setColorModel((ColorModel)object2);
                    }
                }
            } else if (imageLayout2.getSampleModel(null) == null) {
                imageLayout2.setColorModel(imageLayout.getColorModel(renderedImage));
            }
        } else if (imageLayout2 != null && (imageLayout2 = (ImageLayout)imageLayout.clone()).getColorModel(null) != null && imageLayout2.getSampleModel(null) == null) {
            int n;
            int n2 = imageLayout2.getTileWidth(null);
            if (n2 == 0) {
                n2 = 512;
            }
            if ((n = imageLayout2.getTileHeight(null)) == 0) {
                n = 512;
            }
            object2 = imageLayout2.getColorModel(null).createCompatibleSampleModel(n2, n);
            imageLayout2.setSampleModel((SampleModel)object2);
        }
        if (imageLayout2 != null && !imageLayout2.isValid(512) && imageLayout2.getSampleModel(null) != null && !OpImage.setColorModelFromFactory(imageLayout2.getSampleModel(null), vector, map, imageLayout2)) {
            object4 = null;
            object3 = imageLayout2.getSampleModel(null);
            if (renderedImage != null && renderedImage.getColorModel() != null && renderedImage.getColorModel() instanceof IndexColorModel && map != null && map.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL) && ((Boolean)map.get(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)).booleanValue()) {
                object2 = (IndexColorModel)renderedImage.getColorModel();
                object4 = PlanarImage.getDefaultColorModel(((SampleModel)object3).getDataType(), ((ColorModel)object2).getNumComponents());
                object = object4 != null ? ((ColorModel)object4).createCompatibleSampleModel(((SampleModel)object3).getWidth(), ((SampleModel)object3).getHeight()) : RasterFactory.createPixelInterleavedSampleModel(((SampleModel)object3).getDataType(), ((SampleModel)object3).getWidth(), ((SampleModel)object3).getHeight(), ((ColorModel)object2).getNumComponents());
                imageLayout2.setSampleModel((SampleModel)object);
            } else {
                object4 = ImageUtil.getCompatibleColorModel(imageLayout2.getSampleModel(null), map);
            }
            if (object4 != null) {
                imageLayout2.setColorModel((ColorModel)object4);
            }
        }
        if (imageLayout != null && imageLayout2 != null && !imageLayout.isValid(192) && (object4 = JAI.getDefaultTileSize()) != null) {
            if (!imageLayout.isValid(64)) {
                if (imageLayout2.getTileWidth(null) <= 0) {
                    imageLayout2.setTileWidth(((Dimension)object4).width);
                } else {
                    int n = PlanarImage.XToTileX(imageLayout2.getMinX(null) + imageLayout2.getWidth(null) - 1, imageLayout2.getTileGridXOffset(null), imageLayout2.getTileWidth(null)) - PlanarImage.XToTileX(imageLayout2.getMinX(null), imageLayout2.getTileGridXOffset(null), imageLayout2.getTileWidth(null)) + 1;
                    if (n <= 1 && imageLayout2.getWidth(null) >= 2 * ((Dimension)object4).width) {
                        imageLayout2.setTileWidth(((Dimension)object4).width);
                    }
                }
            }
            if (!imageLayout.isValid(128)) {
                if (imageLayout2.getTileHeight(null) <= 0) {
                    imageLayout2.setTileHeight(((Dimension)object4).height);
                } else {
                    int n = PlanarImage.YToTileY(imageLayout2.getMinY(null) + imageLayout2.getHeight(null) - 1, imageLayout2.getTileGridYOffset(null), imageLayout2.getTileHeight(null)) - PlanarImage.YToTileY(imageLayout2.getMinY(null), imageLayout2.getTileGridYOffset(null), imageLayout2.getTileHeight(null)) + 1;
                    if (n <= 1 && imageLayout2.getHeight(null) >= 2 * ((Dimension)object4).height) {
                        imageLayout2.setTileHeight(((Dimension)object4).height);
                    }
                }
            }
        }
        if ((imageLayout == null || !imageLayout.isValid(64)) && imageLayout2.isValid(68) && imageLayout2.getTileWidth(null) > imageLayout2.getWidth(null)) {
            imageLayout2.setTileWidth(imageLayout2.getWidth(null));
        }
        if ((imageLayout == null || !imageLayout.isValid(128)) && imageLayout2.isValid(136) && imageLayout2.getTileHeight(null) > imageLayout2.getHeight(null)) {
            imageLayout2.setTileHeight(imageLayout2.getHeight(null));
        }
        return imageLayout2;
    }

    private static boolean setColorModelFromFactory(SampleModel sampleModel, Vector vector, Map map, ImageLayout imageLayout) {
        ColorModelFactory colorModelFactory;
        ColorModel colorModel;
        boolean bl = false;
        if (map != null && map.containsKey(JAI.KEY_COLOR_MODEL_FACTORY) && (colorModel = (colorModelFactory = (ColorModelFactory)map.get(JAI.KEY_COLOR_MODEL_FACTORY)).createColorModel(sampleModel, vector, map)) != null && JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout.setColorModel(colorModel);
            bl = true;
        }
        return bl;
    }

    public OpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl) {
        super(OpImage.layoutHelper(imageLayout, vector, map), vector, map);
        if (map != null) {
            Object v;
            Class<Object> clazz;
            Object v2;
            Object v3 = map.get(JAI.KEY_TILE_CACHE);
            if (v3 != null && v3 instanceof TileCache && ((TileCache)v3).getMemoryCapacity() > 0L) {
                this.cache = (TileCache)v3;
            }
            if ((v2 = map.get(JAI.KEY_TILE_SCHEDULER)) != null && v2 instanceof TileScheduler) {
                this.scheduler = (TileScheduler)v2;
            }
            try {
                clazz = Class.forName("com.sun.media.jai.util.SunTileScheduler");
                this.isSunTileScheduler = clazz.isInstance(this.scheduler);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tileCacheMetric = map.get(JAI.KEY_TILE_CACHE_METRIC);
            clazz = map.get(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED);
            if (clazz instanceof Boolean) {
                this.isCachedTileRecyclingEnabled = (Boolean)((Object)clazz);
            }
            if ((v = map.get(JAI.KEY_TILE_RECYCLER)) instanceof TileRecycler) {
                this.tileRecycler = (TileRecycler)v;
            }
        }
        this.cobbleSources = bl;
    }

    protected static Vector vectorize(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage3"));
        }
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.addElement(renderedImage);
        return vector;
    }

    protected static Vector vectorize(RenderedImage renderedImage, RenderedImage renderedImage2) {
        if (renderedImage == null || renderedImage2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage3"));
        }
        Vector<RenderedImage> vector = new Vector<RenderedImage>(2);
        vector.addElement(renderedImage);
        vector.addElement(renderedImage2);
        return vector;
    }

    protected static Vector vectorize(RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3) {
        if (renderedImage == null || renderedImage2 == null || renderedImage3 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage3"));
        }
        Vector<RenderedImage> vector = new Vector<RenderedImage>(3);
        vector.addElement(renderedImage);
        vector.addElement(renderedImage2);
        vector.addElement(renderedImage3);
        return vector;
    }

    static Vector checkSourceVector(Vector vector, boolean bl) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage2"));
        }
        if (bl) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (vector.get(n2) == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("OpImage3"));
                }
                ++n2;
            }
        }
        return vector;
    }

    public TileCache getTileCache() {
        return this.cache;
    }

    public void setTileCache(TileCache tileCache) {
        if (this.cache != null) {
            this.cache.removeTiles(this);
        }
        this.cache = tileCache;
    }

    protected Raster getTileFromCache(int n, int n2) {
        return this.cache != null ? this.cache.getTile(this, n, n2) : null;
    }

    protected void addTileToCache(int n, int n2, Raster raster) {
        if (this.cache != null) {
            this.cache.add(this, n, n2, raster, this.tileCacheMetric);
        }
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public Raster getTile(int n, int n2) {
        Raster raster = null;
        if (n >= this.getMinTileX() && n <= this.getMaxTileX() && n2 >= this.getMinTileY() && n2 <= this.getMaxTileY() && (raster = this.getTileFromCache(n, n2)) == null) {
            try {
                raster = this.scheduler.scheduleTile(this, n, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.cache != null) {
                    this.cache.flush();
                    System.gc();
                }
                raster = this.scheduler.scheduleTile(this, n, n2);
            }
            this.addTileToCache(n, n2, raster);
        }
        return raster;
    }

    public Raster computeTile(int n, int n2) {
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
        Rectangle rectangle = this.getTileRect(n, n2);
        int n3 = this.getNumSources();
        if (this.cobbleSources) {
            Object object;
            Raster[] rasterArray = new Raster[n3];
            int n4 = 0;
            while (n4 < n3) {
                PlanarImage planarImage = this.getSource(n4);
                object = this.mapDestRect(rectangle, n4);
                rasterArray[n4] = object != null && ((Rectangle)object).isEmpty() ? null : planarImage.getData((Rectangle)object);
                ++n4;
            }
            this.computeRect(rasterArray, writableRaster, rectangle);
            int n5 = 0;
            while (n5 < n3) {
                PlanarImage planarImage;
                object = rasterArray[n5];
                if (object != null && (planarImage = this.getSourceImage(n5)).overlapsMultipleTiles(((Raster)object).getBounds())) {
                    this.recycleTile((Raster)object);
                }
                ++n5;
            }
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[n3];
            int n6 = 0;
            while (n6 < n3) {
                planarImageArray[n6] = this.getSource(n6);
                ++n6;
            }
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        String string = this.getClass().getName();
        throw new RuntimeException(string + " " + JaiI18N.getString("OpImage0"));
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        String string = this.getClass().getName();
        throw new RuntimeException(string + " " + JaiI18N.getString("OpImage1"));
    }

    public Point[] getTileDependencies(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = this.getTileRect(n, n2);
        if (rectangle.isEmpty()) {
            return null;
        }
        PlanarImage planarImage = this.getSource(n3);
        Rectangle rectangle2 = this.mapDestRect(rectangle, n3);
        int n4 = planarImage.XToTileX(rectangle2.x);
        int n5 = planarImage.XToTileX(rectangle2.x + rectangle2.width - 1);
        int n6 = planarImage.YToTileY(rectangle2.y);
        int n7 = planarImage.YToTileY(rectangle2.y + rectangle2.height - 1);
        n4 = Math.max(n4, planarImage.getMinTileX());
        n5 = Math.min(n5, planarImage.getMaxTileX());
        n6 = Math.max(n6, planarImage.getMinTileY());
        n7 = Math.min(n7, planarImage.getMaxTileY());
        int n8 = n5 - n4 + 1;
        int n9 = n7 - n6 + 1;
        if (n8 <= 0 || n9 <= 0) {
            return null;
        }
        Point[] pointArray = new Point[n9 * n8];
        int n10 = 0;
        int n11 = n6;
        while (n11 <= n7) {
            int n12 = n4;
            while (n12 <= n5) {
                pointArray[n10++] = new Point(n12, n11);
                ++n12;
            }
            ++n11;
        }
        return pointArray;
    }

    public Raster[] getTiles(Point[] pointArray) {
        Raster[] rasterArray;
        block9: {
            int n;
            int n2;
            boolean[] blArray;
            int n3;
            block10: {
                int n4;
                if (pointArray == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                }
                n3 = pointArray.length;
                rasterArray = new Raster[n3];
                blArray = new boolean[n3];
                int n5 = this.getMinTileX();
                int n6 = this.getMaxTileX();
                int n7 = this.getMinTileY();
                int n8 = this.getMaxTileY();
                n2 = 0;
                int n9 = 0;
                while (n9 < n3) {
                    n4 = pointArray[n9].x;
                    n = pointArray[n9].y;
                    if (n4 >= n5 && n4 <= n6 && n >= n7 && n <= n8) {
                        rasterArray[n9] = this.getTileFromCache(n4, n);
                        if (rasterArray[n9] == null) {
                            blArray[n9] = true;
                            ++n2;
                        }
                    }
                    ++n9;
                }
                if (n2 <= 0) break block9;
                if (n2 != n3) break block10;
                rasterArray = this.scheduler.scheduleTiles(this, pointArray);
                if (this.cache == null || this.cache == null) break block9;
                n4 = 0;
                while (n4 < n3) {
                    this.cache.add(this, pointArray[n4].x, pointArray[n4].y, rasterArray[n4], this.tileCacheMetric);
                    ++n4;
                }
                break block9;
            }
            Point[] pointArray2 = new Point[n2];
            n2 = 0;
            n = 0;
            while (n < n3) {
                if (blArray[n]) {
                    pointArray2[n2++] = pointArray[n];
                }
                ++n;
            }
            Raster[] rasterArray2 = this.scheduler.scheduleTiles(this, pointArray2);
            n2 = 0;
            int n10 = 0;
            while (n10 < n3) {
                if (blArray[n10]) {
                    rasterArray[n10] = rasterArray2[n2++];
                    this.addTileToCache(pointArray[n10].x, pointArray[n10].y, rasterArray[n10]);
                }
                ++n10;
            }
        }
        return rasterArray;
    }

    private static TileComputationListener[] prependListener(TileComputationListener[] tileComputationListenerArray, TileComputationListener tileComputationListener) {
        if (tileComputationListenerArray == null) {
            return new TileComputationListener[]{tileComputationListener};
        }
        TileComputationListener[] tileComputationListenerArray2 = new TileComputationListener[tileComputationListenerArray.length + 1];
        tileComputationListenerArray2[0] = tileComputationListener;
        System.arraycopy(tileComputationListenerArray, 0, tileComputationListenerArray2, 1, tileComputationListenerArray.length);
        return tileComputationListenerArray2;
    }

    public TileRequest queueTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        TileComputationListener[] tileComputationListenerArray = this.getTileComputationListeners();
        if (!this.isSunTileScheduler) {
            TCL tCL = new TCL(this);
            tileComputationListenerArray = OpImage.prependListener(tileComputationListenerArray, tCL);
        }
        return this.scheduler.scheduleTiles(this, pointArray, tileComputationListenerArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        this.scheduler.cancelTiles(tileRequest, pointArray);
    }

    public void prefetchTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (pointArray == null) {
            return;
        }
        this.scheduler.prefetchTiles(this, pointArray);
    }

    public Point2D mapDestPoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.mapDestRect(rectangle, n);
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.mapSourceRect(rectangle, n);
        if (rectangle2 == null) {
            return null;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    public abstract Rectangle mapSourceRect(Rectangle var1, int var2);

    public abstract Rectangle mapDestRect(Rectangle var1, int var2);

    public int getOperationComputeType() {
        return 1;
    }

    public boolean computesUniqueTiles() {
        return true;
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.cache != null) {
            Raster[] rasterArray;
            if (this.isCachedTileRecyclingEnabled && this.tileRecycler != null && (rasterArray = this.cache.getTiles(this)) != null) {
                int n = rasterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.tileRecycler.recycleTile(rasterArray[n2]);
                    ++n2;
                }
            }
            this.cache.removeTiles(this);
        }
        super.dispose();
    }

    public boolean hasExtender(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this instanceof AreaOpImage) {
            return ((AreaOpImage)this).getBorderExtender() != null;
        }
        if (this instanceof GeometricOpImage) {
            return ((GeometricOpImage)this).getBorderExtender() != null;
        }
        return false;
    }

    public static int getExpandedNumBands(SampleModel sampleModel, ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            return colorModel.getNumComponents();
        }
        return sampleModel.getNumBands();
    }

    protected synchronized RasterFormatTag[] getFormatTags() {
        if (this.formatTags == null) {
            RenderedImage[] renderedImageArray = new RenderedImage[this.getNumSources()];
            if (renderedImageArray.length > 0) {
                this.getSources().toArray(renderedImageArray);
            }
            this.formatTags = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        }
        return this.formatTags;
    }

    public TileRecycler getTileRecycler() {
        return this.tileRecycler;
    }

    protected final WritableRaster createTile(int n, int n2) {
        return this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
    }

    protected void recycleTile(Raster raster) {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.tileRecycler != null) {
            this.tileRecycler.recycleTile(raster);
        }
    }

    private class TCL
    implements TileComputationListener {
        OpImage opImage;

        private TCL(OpImage opImage2) {
            this.opImage = opImage2;
        }

        public void tileComputed(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Raster raster) {
            if (planarImage == this.opImage) {
                OpImage.this.addTileToCache(n, n2, raster);
            }
        }

        public void tileCancelled(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2) {
        }

        public void tileComputationFailure(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Throwable throwable) {
        }
    }
}

