/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;

public class BufrDataDump {
    private PrintStream out;
    private Indent indent = new Indent(2);

    public BufrDataDump(String filename, OutputStream os) throws IOException {
        this.out = new PrintStream(os);
        this.out.format("Dump %s%n", filename);
        this.indent.setIndentLevel(0);
        try {
            this.scanBufrFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scanBufrFile(String filename) throws Exception {
        int count = 0;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                Message m = scan.next();
                if (m == null) continue;
                this.out.format("%sMessage %d header=%s%n", this.indent, count++, m.getHeader());
                this.processBufrMessageAsDataset(scan, m);
            }
            Object var7_6 = null;
            if (raf == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (raf == null) throw throwable;
            raf.close();
            throw throwable;
        }
        raf.close();
    }

    private void processBufrMessageAsDataset(MessageScanner scan, Message m) throws Exception {
        byte[] mbytes = scan.getMessageBytes(m);
        NetcdfFile ncfile = NetcdfFile.openInMemory("test", mbytes, "ucar.nc2.iosp.bufr.BufrIosp");
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        SequenceDS obs = (SequenceDS)ncd.findVariable("obs");
        StructureDataIterator sdataIter = obs.getStructureIterator(-1);
        this.extractFirst(sdataIter, new Extract());
    }

    private void extractFirst(StructureDataIterator sdataIter, Extract result) throws IOException {
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            for (StructureMembers.Member m : sdata.getMembers()) {
                if (m.getName().equals("Buoy/platform identifier")) {
                    result.platformId = sdata.convertScalarDouble(m);
                    continue;
                }
                if (m.getDataType() != DataType.SEQUENCE) continue;
                ArraySequence data = (ArraySequence)sdata.getArray(m);
                this.extractNested(data.getStructureDataIterator(), result);
            }
        }
    }

    private void extractNested(StructureDataIterator sdataIter, Extract result) throws IOException {
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            for (StructureMembers.Member m : sdata.getMembers()) {
                if (m.getName().equals("Year")) {
                    result.year = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Month")) {
                    result.month = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Day")) {
                    result.day = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Hour")) {
                    result.hour = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Minute")) {
                    result.min = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Second")) {
                    result.sec = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Time increment")) {
                    result.incr = sdata.convertScalarInt(m);
                    continue;
                }
                if (m.getName().equals("Short time increment")) {
                    result.incrS = sdata.convertScalarInt(m);
                    continue;
                }
                if (!m.getName().equals("Water column height")) continue;
                result.value = sdata.getArray(m);
                this.out.format("%s%n", result.toString());
            }
        }
    }

    private void writeSequence(StructureDS s, StructureDataIterator sdataIter) throws IOException {
        this.indent.incr();
        int count = 0;
        while (sdataIter.hasNext()) {
            this.out.format("%sSequence %s count=%d%n", this.indent, s.getShortName(), count++);
            StructureData sdata = sdataIter.next();
            this.indent.incr();
            for (StructureMembers.Member m : sdata.getMembers()) {
                ArrayStructure data;
                StructureDS sds;
                Variable v = s.findVariable(m.getName());
                if (m.getDataType().isString() || m.getDataType().isNumeric()) {
                    this.writeVariable((VariableDS)v, sdata.getArray(m));
                    continue;
                }
                if (m.getDataType() == DataType.STRUCTURE) {
                    sds = (StructureDS)v;
                    data = (ArrayStructure)sdata.getArray(m);
                    this.writeSequence(sds, data.getStructureDataIterator());
                    continue;
                }
                if (m.getDataType() != DataType.SEQUENCE) continue;
                sds = (SequenceDS)v;
                data = (ArraySequence)sdata.getArray(m);
                this.writeSequence(sds, ((ArraySequence)data).getStructureDataIterator());
            }
            this.indent.decr();
        }
        this.indent.decr();
    }

    private void writeVariable(VariableDS v, Array mdata) throws IOException {
        int count = 0;
        String name = v.getShortName();
        String units = v.getUnitsString();
        this.out.format("%svar='%s' units='%s' : ", this.indent, name, units);
        mdata.resetLocalIterator();
        while (mdata.hasNext()) {
            if (count++ > 0) {
                this.out.format(",", new Object[0]);
            }
            if (v.getDataType().isNumeric()) {
                double val = mdata.nextDouble();
                if (v.isMissing(val)) {
                    this.out.format("missing", new Object[0]);
                    continue;
                }
                this.out.format("%s", Double.toString(val));
                continue;
            }
            this.out.format("%s", mdata.next());
        }
        this.out.format("%n", new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        new BufrDataDump("D:/work/michelle/TimeIncr.bufr", System.out);
    }

    private class Extract {
        double platformId;
        int year;
        int month;
        int day;
        int hour;
        int min;
        int sec;
        int incr;
        int incrS;
        Array value;

        private Extract() {
        }

        public String toString() {
            return "Extract{platformId=" + this.platformId + ", year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", min=" + this.min + ", sec=" + this.sec + ", incr=" + this.incr + ", incrS=" + this.incrS + ", value=" + this.value + '}';
        }
    }
}

