/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.JPEGDecodeParam;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.NoMarkStream;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private static final Object LOCK = new Object();
    private Raster theTile = null;

    public JPEGImage(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        Object object;
        if (inputStream.markSupported()) {
            inputStream = new NoMarkStream(inputStream);
        }
        Object object2 = null;
        Object object3 = LOCK;
        synchronized (object3) {
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
            try {
                object2 = jPEGImageDecoder.decodeAsBufferedImage();
            }
            catch (ImageFormatException imageFormatException) {
                object = JaiI18N.getString("JPEGImageDecoder1");
                this.sendExceptionToListener((String)object, (Exception)((Object)imageFormatException));
            }
            catch (IOException iOException) {
                String string = JaiI18N.getString("JPEGImageDecoder1");
                this.sendExceptionToListener(string, iOException);
            }
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = ((BufferedImage)object2).getWidth();
        this.tileHeight = this.height = ((BufferedImage)object2).getHeight();
        if ((imageDecodeParam == null || imageDecodeParam instanceof JPEGDecodeParam && ((JPEGDecodeParam)imageDecodeParam).getDecodeToCSM()) && !(((BufferedImage)object2).getSampleModel() instanceof ComponentSampleModel)) {
            int n = -1;
            int n2 = ((BufferedImage)object2).getSampleModel().getNumBands();
            if (n2 == 1) {
                n = 10;
            } else if (n2 == 3) {
                n = 5;
            } else if (n2 == 4) {
                n = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            object = new BufferedImage(this.width, this.height, n);
            ((BufferedImage)object).getWritableTile(0, 0).setRect(((BufferedImage)object2).getWritableTile(0, 0));
            ((BufferedImage)object).releaseWritableTile(0, 0);
            object2 = object;
        }
        this.sampleModel = ((BufferedImage)object2).getSampleModel();
        this.colorModel = ((BufferedImage)object2).getColorModel();
        this.theTile = ((BufferedImage)object2).getWritableTile(0, 0);
    }

    public synchronized Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.theTile;
    }

    private void sendExceptionToListener(String string, Exception exception) {
        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
    }
}

