/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;

@XmlType(name="CylindricalCSType")
@XmlRootElement(name="CylindricalCS")
public class DefaultCylindricalCS
extends AbstractCS
implements CylindricalCS {
    private static final long serialVersionUID = -8290402732390917907L;

    private DefaultCylindricalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultCylindricalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    protected DefaultCylindricalCS(CylindricalCS cylindricalCS) {
        super(cylindricalCS);
    }

    public static DefaultCylindricalCS castOrCopy(CylindricalCS cylindricalCS) {
        return cylindricalCS == null || cylindricalCS instanceof DefaultCylindricalCS ? (DefaultCylindricalCS)cylindricalCS : new DefaultCylindricalCS(cylindricalCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(axisDirection, false)) {
            return 1;
        }
        if (!Units.isAngular(unit) && !Units.isLinear(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends CylindricalCS> getInterface() {
        return CylindricalCS.class;
    }

    @Override
    public DefaultCylindricalCS forConvention(AxesConvention axesConvention) {
        return (DefaultCylindricalCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 2: {
                return new DefaultPolarCS(map, coordinateSystemAxisArray);
            }
            case 3: {
                return new DefaultCylindricalCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultCylindricalCS.unexpectedDimension(map, coordinateSystemAxisArray, 2);
    }

    private DefaultCylindricalCS() {
    }
}

