import QtQuick
import QtQuick.Layouts
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 200
    height: 200
    property bool effectsOn: true
    property real blurFactor: 1
    property string themeString: "LIGHT"
    property bool sobelOn: false
    property bool orthoOn: false
    property bool muted: true
    property int fps: 0
    property int fpsA: 0
    property color highlightColor: "RED"

    ColumnLayout {
        id: names
        x: 7
        y: 34
        layoutDirection: Qt.RightToLeft
        Text {
            id: themeLabel
            color: "#46a0f9"
            text: qsTr("THEME")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }

        Text {
            id: effectsLabel
            color: "#46a0f9"
            text: qsTr("EFFECTS")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel1
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel1
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }

        Text {
            id: sobelLabel
            color: "#46a0f9"
            text: qsTr("SOBEL")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel2
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel2
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }

        Text {
            id: orthoLabel
            color: "#46a0f9"
            text: qsTr("ORTHO")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel3
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel3
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }

        Text {
            id: muteLabel
            color: "#46a0f9"
            text: qsTr("MUTE")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel5
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel5
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }

        Text {
            id: fpsLabel
            color: "#46a0f9"
            text: qsTr("FPS")
            font.pixelSize: 18
            horizontalAlignment: Text.AlignRight
            DesignEffect {
                id: designEffectDisplayReadoutLabel4
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutLabel4
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: "#46a0f9"
                    }
                ]
            }
        }
    }

    ColumnLayout {
        id: status
        x: 90
        y: 34
        Text {
            id: themeName
            color: root.highlightColor
            text: root.themeString
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }

        Text {
            id: effectsStatus
            color: root.highlightColor
            text: root.effectsOn ? "ON" : "OFF"
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme1
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme1
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }

        Text {
            id: sobelStatus
            color: root.highlightColor
            text: root.sobelOn ? "ON" : "OFF"
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme4
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme4
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }

        Text {
            id: orthoStatus
            color: root.highlightColor
            text: root.orthoOn ? "ON" : "OFF"
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme6
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme6
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }

        Text {
            id: muteStatus
            color: root.highlightColor
            text: root.muted ? "ON" : "OFF"
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme12
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme12
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }

        Text {
            id: fpsStatus
            color: root.highlightColor
            text: "Ø " + root.fpsA + " | " + root.fps
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme13
                visible: root.effectsOn
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme13
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: root.highlightColor
                    }
                ]
            }
        }
    }
}
