import QtQuick
import QtQuick3D
Node {
    property int arrowCount: 4

    PrincipledMaterial {
        id: dangerArrow_material
        baseColor: "#ffcc0100"
        roughness: 0.5
        emissiveFactor: Qt.vector3d(0.9, 0.00162438, 0)
        alphaMode: PrincipledMaterial.Opaque
    }

    Model {
        id: dangerArrow_1
        scale.x: 1.5
        source: "meshes/dangerArrow_1.mesh"
        materials: [
            dangerArrow_material
        ]
    }
    Model {
        id: dangerArrow_2
        source: "meshes/dangerArrow_2.mesh"
        visible: arrowCount > 1
        materials: [
            dangerArrow_material
        ]
    }
    Model {
        id: dangerArrow_3
        source: "meshes/dangerArrow_3.mesh"
        visible: arrowCount > 2
        materials: [
            dangerArrow_material
        ]
    }
    Model {
        id: dangerArrow_4
        source: "meshes/dangerArrow_4.mesh"
        visible: arrowCount > 3
        materials: [
            dangerArrow_material
        ]
    }
}
