import QtQuick
import QtQuick3D
Node {
    id: armature
    property real end: 0
    property real lane: 0
    scale.z: 10
    scale.y: 10
    scale.x: 10
    Model {
        id: bendingplane
        skeleton: qmlskeleton
        inverseBindPoses: [
            Qt.matrix4x4(-2.8213e-07, 1, -7.54979e-08, 1.69278e-06, -7.12148e-15, -7.54979e-08, -1, 4.27289e-14, -1, -2.8213e-07, 2.13002e-14, 6, 0, 0, 0, 1),
            Qt.matrix4x4(-2.8213e-07, 1, -7.54979e-08, -1.78998e-06, -7.12148e-15, -7.54979e-08, -1, 2, -1, -2.8213e-07, 2.13002e-14, -6.91677, 0, 0, 0, 1)
        ]
        source: "meshes/bendingplane.mesh"

        PrincipledMaterial {
            id: bendingplane_material
            baseColor: "#cdcddc"
            opacityMap: vertical3
            metalness: 0.5
            roughness: 1
            alphaMode: PrincipledMaterial.Opaque

            Texture {
                id: vertical3
                source: "maps/vertical-3.png"
            }
        }
        materials: [
            bendingplane_material
        ]
    }
    Skeleton {
        id: qmlskeleton
        Joint {
            id: bone
            x: 6
            y: 0
            z: 0
            rotation: Qt.quaternion(0.5, -0.5, -0.5, 0.5)
            scale.y: 1
            index: 0
            skeletonRoot: qmlskeleton
        }
        Joint {
            id: bone_001
            x: end
            y: 0
            z: lane
            rotation: Qt.quaternion(0.5, -0.5, -0.5, 0.5)
            scale.y: 1
            index: 1
            skeletonRoot: qmlskeleton
        }
    }
}
