/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick 3D.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick3D

Item {
    id: root

    property Node controlledObject: null

    property real speed: 0.1

    property bool xInvert: true
    property bool yInvert: false

    property alias acceptedButtons: dragHandler.acceptedButtons

    implicitWidth: parent.width
    implicitHeight: parent.height

    DragHandler {
        id: dragHandler

        target: null

        onCentroidChanged: {
            mouseMoved(Qt.vector2d(centroid.position.x, centroid.position.y));
        }

        onActiveChanged: {
            if (active)
                mousePressed(Qt.vector2d(centroid.position.x, centroid.position.y));
            else
                mouseReleased(Qt.vector2d(centroid.position.x, centroid.position.y));
        }
    }

    TapHandler {
        onTapped: root.forceActiveFocus()
    }

    function mousePressed(newPos) {
        root.forceActiveFocus()
        status.currentPos = newPos
        status.lastPos = newPos
        status.useMouse = true;
    }

    function mouseReleased(newPos) {
        status.useMouse = false;
    }

    function mouseMoved(newPos) {
        status.currentPos = newPos;
    }

    Timer {
        id: updateTimer
        interval: 16
        repeat: true
        running: status.useMouse
        onTriggered: {
            status.processInput()
        }
    }

    QtObject {
        id: status

        property bool useMouse: false

        property vector2d lastPos: Qt.vector2d(0, 0)
        property vector2d currentPos: Qt.vector2d(0, 0)

        function processInput() {
            if (controlledObject == undefined || !useMouse)
                return;

            // Get the delta
            var delta = Qt.vector2d(lastPos.x - currentPos.x, lastPos.y - currentPos.y);

            var rotVector = controlledObject.eulerRotation;

            // rotate x
            var rotateX = delta.x * (xInvert ? -speed : speed)
            rotVector.y += rotateX;

            // rotate y
            var rotateY = delta.y * (yInvert ? speed : -speed)

            if (rotVector.x + rotateY <= 15.23 && rotVector.x + rotateY >= -70.0)
                rotVector.x += rotateY;

            controlledObject.setEulerRotation(rotVector);
            lastPos = currentPos;
        }
    }
}

/*##^##
Designer {
    D{i:0;height:1080;width:1920}
}
##^##*/
