import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
Node {
    id: rootNode

    Model {
        id: internalChargingCable
        x: -3.62646
        y: 3.39142
        z: -0.205271
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/internalChargingCable.mesh"

        DefaultMaterial {
            id: aluminium_001_material
            lighting: DefaultMaterial.FragmentLighting
            emissiveFactor.z: 1
            emissiveFactor.y: 1
            emissiveMap: pulse
            emissiveFactor.x: 1
            diffuseMap: pulse
            diffuseColor: "#ffffff"

            Texture {
                id: pulse
                source: "../../../images/pulse.jpg"
                positionU: 14.3
                positionV: 1
                scaleV: 20
                scaleU: 1
            }
        }

        DefaultMaterial {
            id: black_paint_001_material
            specularAmount: 1
            diffuseColor: "#62487e"
        }
        materials: [
            aluminium_001_material,
            black_paint_001_material
        ]
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 1000
                running: true
                loops: -1
                to: 1000
                from: 0
            }
        ]
        startFrame: 0
        enabled: true
        endFrame: 1000

        KeyframeGroup {
            target: pulse
            property: "positionV"

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 1000
            }
        }
    }
}
