VARYING vec2 vTexCoord;
VARYING vec4 vColor;

vec2 rotate(vec2 v, float a) {

	float s = sin(a);

	float c = cos(a);

	mat2 m = mat2(c, -s, s, c);

	return m * v;

}

VARYING vec3 worldPos;
VARYING vec3 localPos;
vec3 windN;

VARYING float debugFloat = 0.0;
	
const float PI = 3.14159265359;

float Get2DNoise(float value1, float value2)
{
    vec2 uv = vec2(value1, value2);

    vec2 p = floor(uv);
    vec2 f = fract(uv);
    f = f * f * (3.0 - 2.0 * f); // Smoothstep interpolation

    float n = p.x + p.y * 57.0;
    return mix(mix(fract(sin(n) * 43758.5453), fract(sin(n + 1.0) * 43758.5453), f.x),
               mix(fract(sin(n + 57.0) * 43758.5453), fract(sin(n + 58.0) * 43758.5453), f.x), f.y);
}


// This wind force calculation follows NaughtyDog's presentation on the tech of Uncharted 4
// https://advances.realtimerendering.com/other/2016/naughty_dog/NaughtyDog_TechArt_Final.pdf

float unchartedWind(vec3 dir, vec3 pivotWS, float timeOffset, float noiseRes, float speed, float gust, float intensity){
	float noise = Get2DNoise(dot(dir,pivotWS)/noiseRes, time);
	float animation = sin(speed * time + timeOffset);
	return intensity * animation * noise + gust;
}

void MAIN()
{
	vTexCoord = UV0;
	vColor = COLOR;
	vec2 animCenter = (vTexCoord * 2.0 - 1.0);
	localPos = VERTEX;
	worldPos = (MODEL_MATRIX * vec4(VERTEX, 1.0)).xyz;
	
	
	float mask = mix(smoothstep(heightMask.x,heightMask.y,worldPos.y),mix(vTexCoord.y,1.0-vTexCoord.y,-constrain),abs(constrain));
	
	windN = normalize(windDirection);
	
	//Add initial wind for the entire object
	worldPos += windN * unchartedWind(windN,worldPos, mask, noiseResolution, windSpeed, windGust,windIntensity)*mask;
	
	//Add detail wind for elements such as leaves in a tree
	float subAnimMask = animCenter.x > 0.0 ? animCenter.x * abs(animCenter.y) : abs(animCenter.x) * animCenter.y;
	worldPos += windN * unchartedWind(windN,worldPos, subAnimMask, noiseResolution, windSpeed,windGust,windIntensity)*subAnimMask * subAnimation;
	
	//Add shockwave wind
	vec3 ShockDir = worldPos-shockposition;
	float shockRadius = length(ShockDir) - shockScale*50.0;
	float shockMask = smoothstep(shockLength,0.0,shockRadius);
	shockMask *= smoothstep(-shockLength,0.0,shockRadius);
	shockMask *= mask;
	debugFloat = shockMask;
	ShockDir = normalize(ShockDir);
	worldPos += unchartedWind(ShockDir,worldPos, shockMask, shockResolution, shockSpeed, shockGust,shockIntensity)*shockMask;
	
	
	//VAR_WORLD_POSITION  = worldPos;
	
	POSITION  =  VIEWPROJECTION_MATRIX * vec4(worldPos, 1.0);
}