VARYING vec2 vTexCoord;
VARYING vec4 vColor;
VARYING vec3 vViewDir;
VARYING vec3 vViewNormal;
vec4 rainTex = vec4(1.0);
float a = 1.0;
vec2 fUV = vec2(0.0);

vec3 blend_rnm(vec3 n1, vec3 n2)
{
    vec3 t = n1.xyz*vec3( 2,  2, 2) + vec3(-1, -1,  0);
    vec3 u = n2.xyz*vec3(-2, -2, 2) + vec3( 1,  1, -1);
    vec3 r = t*dot(t, u) - u*t.z;
    return normalize(r);
}

void MAIN(){
	vec3 splashUVSource = VAR_WORLD_NORMAL*0.5+0.5;
	vec2 splashUV = mix(splashUVSource.xy,vec2(1.0-splashUVSource.z,splashUVSource.y),abs(VAR_WORLD_NORMAL.x));
	float viewMask = abs(vViewDir.y);
	splashUV.xy = mix(splashUV.xy,splashUVSource.xz,viewMask);
	rainTex = texture(rainmap, splashUV.xy);
	float fresnel = abs(dot(normalize(vViewDir),normalize(VAR_WORLD_NORMAL)));
	
	a = mix(rainTex.r,rainTex.g,abs(VAR_WORLD_NORMAL.y))*vColor.a*fresnel;
	if(a <= 0.0){discard;}

	BASE_COLOR = baseColor;
	SPECULAR_AMOUNT = 1.0;
	ROUGHNESS = 0.05;
	METALNESS = 0.0;
	NORMAL = normalize(VAR_WORLD_NORMAL);
	fUV.x = cross(vViewDir,VAR_WORLD_NORMAL).y;
	fUV.y = VAR_WORLD_NORMAL.y;
}

void POST_PROCESS()
{	
	vec2 screenPos = gl_FragCoord.xy/textureSize(SCREEN_TEXTURE, 0);
	vec2 screenCoord = vec2(screenPos);
	
	screenPos.x = fUV.x > 0.0 ? mix(screenPos.x, 1.0,fUV.x) : mix(screenPos.x, 0.0,-fUV.x);
	screenPos.y = fUV.y > 0.0 ? mix(screenPos.y, 1.0,fUV.y) : mix(screenPos.y, 0.0,-fUV.y);
	
	if (FRAMEBUFFER_Y_UP < 0.0) // effectively: if not OpenGL
        screenPos.y = 1.0 - screenPos.y;
	
    vec4 refraction = texture(SCREEN_TEXTURE, screenPos);
	
	COLOR_SUM = vec4((DIFFUSE.rgb+SPECULAR+refraction.rgb),a);
}