import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Model {
    id: rain
    source: "#Rectangle"
    scale.z: 1
    scale.y: 6.1252
    scale.x: 8.28989
    eulerRotation.z: 13.26956
    eulerRotation.y: 0
    eulerRotation.x: -14.57804
    materials: rectMaterial5
    DefaultMaterial {
        id: rectMaterial5
        diffuseMap: texture1
        diffuseColor: "#f9f9f9"

        Texture {
            id: texture1
            source: "img/rain.png"
            positionV: 1
            scaleV: 3
            scaleU: 4
            tilingModeVertical: Texture.Repeat
            tilingModeHorizontal: Texture.Repeat
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: true
                loops: -1
                duration: 1000
                to: 1000
                from: 0
            }
        ]
        enabled: true
        endFrame: 1000
        startFrame: 0

        KeyframeGroup {
            target: texture1
            property: "positionV"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 1000
                value: 1 + (rainctrl.value * 2)
            }
        }
    }
}
