import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Model {
    id: trunk
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/trunk.mesh"
    property bool isOpen: true
    z: 1320.29395
    eulerRotation.x: -90
    DefaultMaterial {
        id: defaultMaterial7
        opacity: 0.5
        diffuseColor: "#060606"
    }
    
    DefaultMaterial {
        id: cubeMaterial7

        Texture {
            id: element10
            source: "trunk.png"
        }
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseMap: element10
        diffuseColor: "#7b8f91"
    }
    
    DefaultMaterial {
        id: defaultMaterial6
        opacity: 0
        diffuseColor: "#fdfdfd"
    }

    Model {
        id: cube
        source: "asset_imports/Quick3DAssets/CarLights/meshes/trunklights.mesh"
        materials: rearLightMat

        RearLightMat {
            id: rearLightMat
            lightOn: (drivelight.checked) ? 1.0 : 0.0
            turnOn: (turnleftlight.checked) ? 1.0 : 0.0
            brakeOn: (brakelight.checked) ? 1.0 : 0.0
        }
    }
    states: [
        State {
            name: "closed"
            when: !trunk.isOpen

            PropertyChanges {
                target: trunk
                eulerRotation.z: 0
                eulerRotation.y: 0
                eulerRotation.x: -90
            }
        },
        State {
            name: "open"
            when: trunk.isOpen

            PropertyChanges {
                target: trunk
                eulerRotation.z: 0
                eulerRotation.y: 0
                eulerRotation.x: -140
            }
        }
    ]
    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.x"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }
    materials: [cubeMaterial7, defaultMaterial6, defaultMaterial7]
}


