import QtQuick 2.15
import QtQuick3D 1.15

Node {
    id: rootNode

    Model {
        id: door_front_right
        x: 361.778
        y: 306.167
        z: -341.674
        eulerRotation.x: -90
        source: "meshes/door_front_right.mesh"

        DefaultMaterial {
            id: body_material
            diffuseColor: "#ff091114"
        }

        DefaultMaterial {
            id: chrome_material
            diffuseColor: "#ffcccccc"
        }

        DefaultMaterial {
            id: black_m_material
            diffuseColor: "#ff2c2c2c"
        }

        DefaultMaterial {
            id: int_material
            diffuseColor: "#ff030303"
        }

        DefaultMaterial {
            id: glass_material
            diffuseColor: "#ffcccccc"
        }

        DefaultMaterial {
            id: blue_material
            diffuseColor: "#ff006bb7"
        }

        DefaultMaterial {
            id: d_glass_material
            diffuseColor: "#ff000000"
            opacity: 0.55
        }
        materials: [
            body_material,
            chrome_material,
            black_m_material,
            int_material,
            glass_material,
            blue_material,
            d_glass_material
        ]
    }

    Model {
        id: door_rear_left
        x: -347.924
        y: 337.4
        z: 92.2482
        eulerRotation.x: -90
        source: "meshes/door_rear_left.mesh"
        materials: [
            black_m_material,
            int_material,
            body_material,
            d_glass_material
        ]
    }

    Model {
        id: door_rear_right
        x: 364.382
        y: 294.705
        z: 91.3009
        eulerRotation.x: -90
        source: "meshes/door_rear_right.mesh"
        materials: [
            int_material,
            black_m_material,
            body_material,
            d_glass_material
        ]
    }

    Model {
        id: trunk
        x: -1.49012e-06
        y: 564.022
        z: 493.911
        eulerRotation.x: -90
        source: "meshes/trunk.mesh"

        DefaultMaterial {
            id: black_material
            diffuseColor: "#ff000000"
        }

        DefaultMaterial {
            id: glass_tex2_material
            diffuseMap: Texture {
                source: "maps/Map3.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }
        }

        DefaultMaterial {
            id: red_material
            diffuseColor: "#ff8e0000"
        }
        materials: [
            body_material,
            black_material,
            glass_material,
            black_m_material,
            d_glass_material,
            glass_tex2_material,
            red_material
        ]
    }

    Model {
        id: body
        x: 8.76279
        y: 270.72
        z: -828.201
        eulerRotation.x: -90
        source: "meshes/body.mesh"

        DefaultMaterial {
            id: int2_material
            diffuseColor: "#ff0d0d0d"
        }

        DefaultMaterial {
            id: engine_material
            diffuseColor: "#ff050505"
        }

        DefaultMaterial {
            id: black_m_tex1_material
            diffuseMap: Texture {
                source: "maps/Map3.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }
            normalMap: Texture {
                source: "maps/Map3.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }        }

        DefaultMaterial {
            id: gum_001_material
            diffuseColor: "#ff212121"
        }
        materials: [
            body_material,
            int2_material,
            engine_material,
            glass_tex2_material,
            int_material,
            d_glass_material,
            black_material,
            black_m_material,
            black_m_tex1_material,
            gum_001_material,
            chrome_material
        ]
    }

    Model {
        id: hood
        x: 7.45058e-07
        y: 406.42
        z: -488.062
        eulerRotation.x: -90
        source: "meshes/hood.mesh"
        materials: [
            body_material
        ]
    }

    Model {
        id: door_front_left
        x: -348.529
        y: 287.392
        z: -343.59
        eulerRotation.x: -90
        source: "meshes/door_front_left.mesh"
        materials: [
            body_material,
            glass_material,
            blue_material,
            chrome_material,
            black_m_material,
            int_material,
            d_glass_material
        ]
    }

    Model {
        id: tire_rear_right
        x: 333.658
        y: 132.8
        z: 551.481
        eulerRotation.x: -90
        source: "meshes/tire_rear_right.mesh"

        DefaultMaterial {
            id: tire_material
            diffuseMap: Texture {
                source: "maps/tyre.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }
            emissiveMap: Texture {
                source: "maps/tyre.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }
            opacityMap: Texture {
                source: "maps/tyre.jpg"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }        }

        DefaultMaterial {
            id: silver_material
            diffuseColor: "#ff202020"
        }

        DefaultMaterial {
            id: gum_material
            diffuseColor: "#ff1d1d1d"
        }
        materials: [
            tire_material,
            silver_material,
            chrome_material,
            gum_001_material,
            gum_material
        ]
    }

    Model {
        id: tire_front_right
        x: 333.658
        y: 132.8
        z: -521.514
        eulerRotation.x: -90
        source: "meshes/tire_front_right.mesh"
        materials: [
            tire_material,
            silver_material,
            chrome_material,
            gum_material,
            gum_001_material
        ]
    }

    Model {
        id: tire_rear_left
        x: -322.882
        y: 132.8
        z: 551.481
        eulerRotation.x: -90
        source: "meshes/tire_rear_left.mesh"
        materials: [
            tire_material,
            silver_material,
            chrome_material,
            gum_001_material,
            gum_material
        ]
    }

    Model {
        id: tire_front_left
        x: -322.882
        y: 132.8
        z: -521.514
        eulerRotation.x: -90
        source: "meshes/tire_front_left.mesh"
        materials: [
            tire_material,
            silver_material,
            chrome_material,
            gum_material
        ]
    }
}
