# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   t1.tcl
# Author: Richard Schwaninger
# Date:   02/09/1996
# System: chiron.standalone
# RCS:    $Id: prof1.tcl,v 1.1 1996/10/30 10:08:53 /SW/app Exp /SW/app $

# [endfold]

# - INSTRUCTIONS --------------------------------------------
# This is a very basic and very useless example that shows 
# how to modify your source code for profiling.

# The first step is always to source the file tprof.tcl 
# (NOTE: you have to modify this file before you use it,
# it needs some pathes set correctly).

# At the spot profiling should start insert the statement
# 'tprof start'. To end profiling and write the sampled data 
# to disk use 'tprof end <filename>'

# you may start and stop profiling everywhere you find 
# convenient, even multiple times in the same script.
# (Note: profiling is either on or off, no overlapping)

# You may replace the statement 'tprof start' with 
# 'tprof start -commands' to include C level commands
# in the output.

# **** (1) ***
source ./tprof.tcl

proc f0 { } {
   set b 0
   for {set i 0} {$i<10} {incr i} {
      set b [expr $b+1.0-1.0+1.0-1.0+1.0-1.0+1.0-1.0+1.0-1.0]
   }
}
proc f1 { a } {
   set x 0
   f0
   foreach i $a {
      incr x [expr [f2 $i] + [f3 $i]]
   }
   return $x
}

proc f2 { i } {
   f0
   return [expr 2* $i]
}

proc f3 { a } {

   f0
   return [expr 3*$a]
}

# **** (2) ***
tprof start
# tprof start -commands
foreach i { 1 2 3 4 5 6 7 8 9 10 11 12 } {
   set ret [f1 {1 2 3 4 5 6 7 8 9}]
}
# **** (3) ***
tprof end "user1.tprof"
exit

# EOF
