# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   tprof.tcl
# Author: Richard Schwaninger
# Date:   16/09/1996
# System: chiron.standalone
# RCS:    $Id: tprof.tcl,v 1.2 1996/12/17 14:49:41 /SW/app Exp /SW/app $

# [endfold]

# [[ Doku ]]

# code to use to create profile data. Just insert a 
#      'source tprof.tcl'
# at the beginning of your program and then do a
#      'tprof start'
# at the point where you want to start profiling and a
#      'tprof end <fname>
# at the end. <fname> denotes a filename to write profiling data into.

# If you use 'tprof start -commands' then you also get
# an indication on how much time the internal C commands used up. This
# may or may not be helpfull...

# [endfold]

# [[ pathname to tclX ]]

# *** CAUTION ***
# you have to modify the following path for your own installation.
# You may use your own tclX library (available from the neosoft
# archive) or you may use the one provided in 
#         ??/SW/exe/<yourplatform>/libtclx7.6.so.
# (you should use one that is compatible with your version of tclsh/wish)
# You may also use a tclsh with tclX compiled in.

load /SW/exe/linux/libtclx7.6.so

# [endfold]
# [[ tprof ]]

proc tprof { cmd args } {
   switch $cmd {
      "start" {
	 if { [catch {
	    eval profile $args on
	 } err ]!=0 } {
	    error "tprof start: Cannot start profiling\n$err"
	 }
      }
      "end" {
	 profile off xx
	 set fn [lindex $args 0]
	 set fp [open $fn "w"]
	 puts $fp "#! tprof"
	 puts $fp "# tprof2.2 tclx-[infox version]"
	 puts $fp "# [clock seconds] [id process] [id host] [id user] $fn"
	 global argv0 argv
	 puts $fp "# $argv0 $argv"
	 puts $fp "#."
	 foreach i [array names xx] {
	    if { [lsearch $i tprof]>=0 } {
	       continue
	    }
	    puts $fp "$i|$xx($i)"
	 }
	 puts $fp "# eof"
	 close $fp
      }
      "default" {
	 error "tprof: unknown subcommand '$cmd'"
      }
   }
}

# [endfold]
	 

# EOF
