/*
 * C functions that are to be called by server-side JavaScript need
 * this .h file.
 *
 * Copyright (c) 1996
 * Netscape Communications Corporation
 * All rights reserved
 * 
 */

#ifndef _lwccall_h_
#define _lwccall_h_

#define LIVEWIRE_CCALLDATA_UNKNOWN 0
#define LIVEWIRE_CCALLDATA_NULL 1
#define LIVEWIRE_CCALLDATA_INTEGER 2
#define LIVEWIRE_CCALLDATA_DOUBLE 3
#define LIVEWIRE_CCALLDATA_STRING 4
#define LIVEWIRE_CCALLDATA_BOOLEAN 5

struct LivewireCCallData {
    int tag; /* from above LIVEWIRE_CCALLDATA_* */
    union {
        int i; /* integer or boolean */
        double d; /* double */
        char* s; /* string */
    } u;
    void (*freeString)(char*);
};

/*
 *
 * your function should conform to this
 *
 */
typedef void 
(*LivewireUserCFunction)( int argc, struct LivewireCCallData argv[], 
    struct LivewireCCallData *result);

/*
 *
 * Notes:
 * 
 * Ignore freeString in the data passed to you. It will always be zero.
 * 
 * Do not modify string memory passed to you. However, it is okay to
 * return it as the return value.
 * 
 * If you return a string value and want a callback so you can release
 * memory allocated for the string, set the structure member freeString.
 * You can set freeString for other data types; however, nothing will
 * happen.
 * 
 * As a return values, UNKNOWN and NULL are equivalent.
 * 
 * If you are using C++, be sure to do something like this:
 * 
 *     extern "C" {
 *         #include "lwccall.h"
 *     }
 * 
 * For more info, see notes in lwccall.c.
 *
 */
#endif /* _lwccall_h_ */
