-- ============================================================
--   Database name  :  WORKNET                                 
--   DBMS name      :  INFORMIX SQL 5.01                       
-- ============================================================

-- ============================================================
--   Database name  :  WORKNET                                 
-- ============================================================
create database WORKNET
with log;

-- ============================================================
--   Table : ADVERTISER                                        
-- ============================================================
create table ADVERTISER
(
    ADVID               VARCHAR(20)           not null,
    ADVNAME             VARCHAR(30)                   ,
    ADDR1               VARCHAR(40)                   ,
    ADDR2               VARCHAR(40)                   ,
    CITY                VARCHAR(25)                   ,
    STATE               CHAR(2)                       ,
    POSTALCODE          VARCHAR(10)                   ,
    COUNTRY             VARCHAR(30)                      ,
    EMAIL               VARCHAR(30)                   ,
    PHONE               VARCHAR(18)                   ,
    FAX                 VARCHAR(18)                   ,
    CONTACTNAME         VARCHAR(50)                   ,
    CONTACTPHONE        VARCHAR(18)                   ,
    CONTACTFAX          VARCHAR(18)                   ,
    CONTACTEMAIL        VARCHAR(40)                   ,
    ADURL               VARCHAR(40)                   ,
    ADTEXT              VARCHAR(100)                  ,
    GIFURL              VARCHAR(40)                   ,
    ACTIVE              CHAR(1)                       ,
    primary key (ADVID) constraint pk_advertiser
);

-- ============================================================
--   Table : SALARYTYPE                                        
-- ============================================================
create table SALARYTYPE
(
    SALARYTYPE          INTEGER                       ,
    DESCRIPTOR          VARCHAR(20)                   
);

-- ============================================================
--   Table : EDUCTYPE                                          
-- ============================================================
create table EDUCTYPE
(
    EDUCTYPE            VARCHAR(5)                    ,
    DESCRIPTOR          VARCHAR(20)                   
);

-- ============================================================
--   Table : MATCHQUERY                                        
-- ============================================================
create table MATCHQUERY
(
    CLIENTID            VARCHAR(20)                   ,
    JOBID               INTEGER                       ,
    SCORE               INTEGER                       ,
    TIMESTAMP           DATETIME      Year to Minute                
);

-- ============================================================
--   Table : SEEKER                                            
-- ============================================================
create table SEEKER
(
    USERID              VARCHAR(20)           not null,
    PASSWORD            VARCHAR(20)           not null,
    FIRST_NAME          VARCHAR(20)                   ,
    LAST_NAME           VARCHAR(30)                   ,
    EMAIL               VARCHAR(30)                   ,
    URL                 VARCHAR(40)                   ,
    ADDR1               VARCHAR(40)                   ,
    ADDR2               VARCHAR(40)                   ,
    CITY                VARCHAR(25)                   ,
    STATE               CHAR(2)                       ,
    POSTALCODE          VARCHAR(10)                   ,
    COUNTRY             VARCHAR(30)                   ,
    PHONE               VARCHAR(18)                   ,
    FAX                 VARCHAR(18)                   ,
    LCITY               VARCHAR(30)                   ,
    LSTATE              VARCHAR(2)                    ,
    LCOUNTRY            VARCHAR(30)                   ,
    SALARYLOW           INTEGER                       ,
    EDUCATION           VARCHAR(5)                    ,
    YEARSEXP            INTEGER                       ,
    SKILLS              VARCHAR(200)                  ,
    COVLET              VARCHAR(200)                  ,
    PERSONAL            VARCHAR(200)                  ,
    DAYSINACTIVE        INTEGER                       ,
    primary key (USERID) constraint pk_seeker
);

-- ============================================================
--   Table : EMPLOYER                                          
-- ============================================================
create table EMPLOYER
(
    EMPID               VARCHAR(20)           not null,
    PASSWORD            VARCHAR(20)           not null,
    BUSNAME             VARCHAR(40)                   ,
    EMAIL               VARCHAR(30)                   ,
    URL                 VARCHAR(40)                   ,
    BUSPHONE            VARCHAR(18)                   ,
    BUSFAX              VARCHAR(18)                   ,
    ADDR1               VARCHAR(40)                   ,
    ADDR2               VARCHAR(40)                   ,
    CITY                VARCHAR(25)                   ,
    STATE               CHAR(2)                       ,
    POSTALCODE          VARCHAR(10)                   ,
    COUNTRY             VARCHAR(30)                   ,
    CONTACTNAME         VARCHAR(50)                   ,
    CONTACTPHONE        VARCHAR(18)                   ,
    CONTACTFAX          VARCHAR(18)                   ,
    CONTACTEMAIL        VARCHAR(40)                   ,
    DESC                VARCHAR(200)                  ,
    ACTIVE              CHAR(1)                       ,
    ADSOK               CHAR(1)                       ,
    CREDITCARDNO        VARCHAR(16)                   ,
    EXPDATE             DATE                          ,
    CARDTYPE            VARCHAR(4)                    ,
    PONUM               VARCHAR(15)                   ,
    PAYMETHOD           CHAR(1)                       ,
    primary key (EMPID) constraint pk_employer
);

-- ============================================================
--   Table : PAST_JOBS                                         
-- ============================================================
create table PAST_JOBS
(
    USERID              VARCHAR(20)           not null,
    JOBNO               INTEGER               not null,
    TITLE               VARCHAR(40)                   ,
    STARTDATE           DATE                          ,
    ENDDATE             DATE                          ,
    DESC                VARCHAR(200)                  ,
    REASONLEFT          VARCHAR(200)                  ,
    primary key (USERID, JOBNO) constraint pk_past_jobs
);

-- ============================================================
--   Table : JOBS                                              
-- ============================================================
create table JOBS
(
    EMPID               VARCHAR(20)           not null,
    JOBID               INTEGER               not null,
    MINEDUC             VARCHAR(5)                    ,
    MINYEARSEXP         INTEGER                       ,
    SKILLS              VARCHAR(200)                  ,
    TITLE               VARCHAR(60)                   ,
    SALARYLOW           INTEGER                       ,
    SALARYHIGH          INTEGER                       ,
    DESC                VARCHAR(200)                  ,
    LCOUNTRY            VARCHAR(30)                   ,
    LCITY               VARCHAR(30)                   ,
    LSTATE              VARCHAR(2)                    ,
    CONTACTNAME         VARCHAR(50)                   ,
    CONTACTEMAIL        VARCHAR(40)                   ,
    primary key (EMPID, JOBID) constraint pk_jobs
);

alter table PAST_JOBS
    add constraint foreign key (USERID)
       references SEEKER (USERID) constraint fk1_past_jobs;

alter table JOBS
    add constraint foreign key (EMPID)
       references EMPLOYER (EMPID) constraint fk1_jobs;

load from "seeker.unl" insert into seeker;
load from "employer.unl" insert into employer;
load from "jobs.unl" insert into jobs;
load from "advert.unl" insert into advertiser;
load from "eductype.unl" insert into eductype;
load from "saltype.unl" insert into salarytype;

grant resource to public;