/* This function reads a file that contains document properties.  The
format of the file must be such that each line contains one property=value
pair.  E.g.  

text="green"
vlink="red"
bgcolor="blue"

etc...

*/

function dynBody( filename )
{

var resultstr = "";

configFile = new File(filename);

if(configFile.open("r")) {

	while (!configFile.eof()) {
		prop = configFile.readln();
		resultstr += " " + prop;
	}
	configFile.close();
} // end if

// if the string is still blank, set some defaults (which are site-dependent)
if (resultstr == "")
	resultstr = " text=\"#112244\" bgcolor=\"#f0eac0\" background=\"/worknet/pics/dirtwhi2.jpg\" "

return resultstr;

} // END dynBody()


//
//========================================================
//

/* cursorObj is a cursor on a table that contains two fields - the first is the value,
and the second is a text descriptor to be output in the list box that is associated with
each value.
*/

function dynSelect( listname, size, multiple, handlerText, selectValue, cursorObj)  {

// BEGIN

selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (" " + handlerText + ">\n");

//Write out the options array

write("<OPTION VALUE=\"\">\n");  // Give one blank option at the beginning.

while(cursorObj.next()) {

   // Dynamically construct each option statement based upon the single field in the table
   // and the value for each record.

	write("<OPTION VALUE=\"" + cursorObj[0] + "\"" + ((selectValue == (cursorObj[0] + "")) ? " SELECTED " : "")   + ">" + cursorObj[1] + "\n");

} // End while loop

//Close the SELECT block
write("</SELECT>\n");

} // END 



function stateList( listname, size, multiple, handlerText, selectValue ) {

selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (" " + handlerText + ">\n");

//Write out the options array

write("<OPTION VALUE=\"\">\n");	// write out one "blank" option

write("<OPTION VALUE=AL " + ((selectValue == "AL") ? "SELECTED" : "")   + ">AL\n");
write("<OPTION VALUE=AK " + ((selectValue == "AK") ? "SELECTED" : "")   + ">AK\n");
write("<OPTION VALUE=AR " + ((selectValue == "AR") ? "SELECTED" : "")   + ">AR\n");
write("<OPTION VALUE=AZ " + ((selectValue == "AZ") ? "SELECTED" : "")   + ">AZ\n");
write("<OPTION VALUE=CA " + ((selectValue == "CA") ? "SELECTED" : "")   + ">CA\n");
write("<OPTION VALUE=CO " + ((selectValue == "CO") ? "SELECTED" : "")   + ">CO\n");
write("<OPTION VALUE=CT " + ((selectValue == "CT") ? "SELECTED" : "")   + ">CT\n");
write("<OPTION VALUE=DE " + ((selectValue == "DE") ? "SELECTED" : "")   + ">DE\n");
write("<OPTION VALUE=FL " + ((selectValue == "FL") ? "SELECTED" : "")   + ">FL\n");
write("<OPTION VALUE=GA " + ((selectValue == "GA") ? "SELECTED" : "")   + ">GA\n");

write("<OPTION VALUE=HI " + ((selectValue == "HI") ? "SELECTED" : "")   + ">HI\n");
write("<OPTION VALUE=IA " + ((selectValue == "IA") ? "SELECTED" : "")   + ">IA\n");
write("<OPTION VALUE=ID " + ((selectValue == "ID") ? "SELECTED" : "")   + ">ID\n");
write("<OPTION VALUE=IL " + ((selectValue == "IL") ? "SELECTED" : "")   + ">IL\n");
write("<OPTION VALUE=IN " + ((selectValue == "IN") ? "SELECTED" : "")   + ">IN\n");
write("<OPTION VALUE=KS " + ((selectValue == "KS") ? "SELECTED" : "")   + ">KS\n");
write("<OPTION VALUE=KY " + ((selectValue == "KY") ? "SELECTED" : "")   + ">KY\n");
write("<OPTION VALUE=LA " + ((selectValue == "LA") ? "SELECTED" : "")   + ">LA\n");
write("<OPTION VALUE=MA " + ((selectValue == "MA") ? "SELECTED" : "")   + ">MA\n");
write("<OPTION VALUE=MD " + ((selectValue == "MD") ? "SELECTED" : "")   + ">MD\n");

write("<OPTION VALUE=ME " + ((selectValue == "ME") ? "SELECTED" : "")   + ">ME\n");
write("<OPTION VALUE=MI " + ((selectValue == "MI") ? "SELECTED" : "")   + ">MI\n");
write("<OPTION VALUE=MN " + ((selectValue == "MN") ? "SELECTED" : "")   + ">MN\n");
write("<OPTION VALUE=MO " + ((selectValue == "MO") ? "SELECTED" : "")   + ">MO\n");
write("<OPTION VALUE=MS " + ((selectValue == "MS") ? "SELECTED" : "")   + ">MS\n");
write("<OPTION VALUE=MT " + ((selectValue == "MT") ? "SELECTED" : "")   + ">MT\n");
write("<OPTION VALUE=NC " + ((selectValue == "NC") ? "SELECTED" : "")   + ">NC\n");
write("<OPTION VALUE=ND " + ((selectValue == "ND") ? "SELECTED" : "")   + ">ND\n");
write("<OPTION VALUE=NE " + ((selectValue == "NE") ? "SELECTED" : "")   + ">NE\n");
write("<OPTION VALUE=NH " + ((selectValue == "NH") ? "SELECTED" : "")   + ">NH\n");

write("<OPTION VALUE=NJ " + ((selectValue == "NJ") ? "SELECTED" : "")   + ">NJ\n");
write("<OPTION VALUE=NM " + ((selectValue == "NM") ? "SELECTED" : "")   + ">NM\n");
write("<OPTION VALUE=NV " + ((selectValue == "NV") ? "SELECTED" : "")   + ">NV\n");
write("<OPTION VALUE=NY " + ((selectValue == "NY") ? "SELECTED" : "")   + ">NY\n");
write("<OPTION VALUE=OH " + ((selectValue == "OH") ? "SELECTED" : "")   + ">OH\n");
write("<OPTION VALUE=OK " + ((selectValue == "OK") ? "SELECTED" : "")   + ">OK\n");
write("<OPTION VALUE=OR " + ((selectValue == "OR") ? "SELECTED" : "")   + ">OR\n");
write("<OPTION VALUE=PA " + ((selectValue == "PA") ? "SELECTED" : "")   + ">PA\n");
write("<OPTION VALUE=RI " + ((selectValue == "RI") ? "SELECTED" : "")   + ">RI\n");
write("<OPTION VALUE=SC " + ((selectValue == "SC") ? "SELECTED" : "")   + ">SC\n");

write("<OPTION VALUE=SD " + ((selectValue == "SC") ? "SELECTED" : "")   + ">SD\n");
write("<OPTION VALUE=TN " + ((selectValue == "TN") ? "SELECTED" : "")   + ">TN\n");
write("<OPTION VALUE=TX " + ((selectValue == "TX") ? "SELECTED" : "")   + ">TX\n");
write("<OPTION VALUE=UT " + ((selectValue == "UT") ? "SELECTED" : "")   + ">UT\n");
write("<OPTION VALUE=VA " + ((selectValue == "VA") ? "SELECTED" : "")   + ">VA\n");
write("<OPTION VALUE=VT " + ((selectValue == "VT") ? "SELECTED" : "")   + ">VT\n");
write("<OPTION VALUE=WA " + ((selectValue == "WA") ? "SELECTED" : "")   + ">WA\n");
write("<OPTION VALUE=WI " + ((selectValue == "WI") ? "SELECTED" : "")   + ">WI\n");
write("<OPTION VALUE=WV " + ((selectValue == "WV") ? "SELECTED" : "")   + ">WV\n");
write("<OPTION VALUE=WY " + ((selectValue == "WY") ? "SELECTED" : "")   + ">WY\n");

write("<OPTION VALUE=DC " + ((selectValue == "DC") ? "SELECTED" : "")   + ">D.C.\n");

//Close the SELECT block
write("</SELECT>\n");



}  // END stateList()


// =============================================================


function stateListFull( listname, size, multiple, handlerText, selectValue ) {

selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

debug("state list full selectValue = ", selectValue);
// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (" " + handlerText + ">\n");

//Write out the options array

write("<OPTION VALUE=\"\">pick a state\n");

write("<OPTION VALUE=AL " + ((selectValue == "AL") ? "SELECTED" : "")   + ">Alabama\n");
write("<OPTION VALUE=AK " + ((selectValue == "AK") ? "SELECTED" : "")   + ">Alaska\n");
write("<OPTION VALUE=AZ " + ((selectValue == "AZ") ? "SELECTED" : "")   + ">Arizona\n");
write("<OPTION VALUE=AR " + ((selectValue == "AR") ? "SELECTED" : "")   + ">Arkansas\n");
write("<OPTION VALUE=CA " + ((selectValue == "CA") ? "SELECTED" : "")   + ">California\n");
write("<OPTION VALUE=CO " + ((selectValue == "CO") ? "SELECTED" : "")   + ">Colorado\n");
write("<OPTION VALUE=CT " + ((selectValue == "CT") ? "SELECTED" : "")   + ">Connecticut\n");
write("<OPTION VALUE=DE " + ((selectValue == "DE") ? "SELECTED" : "")   + ">Delaware\n");
write("<OPTION VALUE=FL " + ((selectValue == "FL") ? "SELECTED" : "")   + ">Flordia\n");
write("<OPTION VALUE=GA " + ((selectValue == "GA") ? "SELECTED" : "")   + ">Georgia\n");

write("<OPTION VALUE=HI " + ((selectValue == "HI") ? "SELECTED" : "")   + ">Hawaii\n");
write("<OPTION VALUE=ID " + ((selectValue == "ID") ? "SELECTED" : "")   + ">Idaho\n");
write("<OPTION VALUE=IL " + ((selectValue == "IL") ? "SELECTED" : "")   + ">Illinois\n");
write("<OPTION VALUE=IN " + ((selectValue == "IN") ? "SELECTED" : "")   + ">Indiana\n");
write("<OPTION VALUE=IA " + ((selectValue == "IA") ? "SELECTED" : "")   + ">Iowa\n");
write("<OPTION VALUE=KS " + ((selectValue == "KS") ? "SELECTED" : "")   + ">Kansas\n");
write("<OPTION VALUE=KY " + ((selectValue == "KY") ? "SELECTED" : "")   + ">Kentucky\n");
write("<OPTION VALUE=LA " + ((selectValue == "LA") ? "SELECTED" : "")   + ">Louisiana\n");
write("<OPTION VALUE=MD " + ((selectValue == "MD") ? "SELECTED" : "")   + ">Maryland\n");
write("<OPTION VALUE=MA " + ((selectValue == "MA") ? "SELECTED" : "")   + ">Massachusetts\n");

write("<OPTION VALUE=ME " + ((selectValue == "ME") ? "SELECTED" : "")   + ">Maine\n");
write("<OPTION VALUE=MI " + ((selectValue == "MI") ? "SELECTED" : "")   + ">Michigan\n");
write("<OPTION VALUE=MN " + ((selectValue == "MN") ? "SELECTED" : "")   + ">Minnesota\n");
write("<OPTION VALUE=MS " + ((selectValue == "MS") ? "SELECTED" : "")   + ">Mississippi\n");
write("<OPTION VALUE=MO " + ((selectValue == "MO") ? "SELECTED" : "")   + ">Missouri\n");
write("<OPTION VALUE=MT " + ((selectValue == "MT") ? "SELECTED" : "")   + ">Montana\n");
write("<OPTION VALUE=NC " + ((selectValue == "NC") ? "SELECTED" : "")   + ">North Carolina\n");
write("<OPTION VALUE=ND " + ((selectValue == "ND") ? "SELECTED" : "")   + ">North Dakota\n");
write("<OPTION VALUE=NE " + ((selectValue == "NE") ? "SELECTED" : "")   + ">Nebraska\n");
write("<OPTION VALUE=NV " + ((selectValue == "NV") ? "SELECTED" : "")   + ">Nevada\n");

write("<OPTION VALUE=NH " + ((selectValue == "NH") ? "SELECTED" : "")   + ">New Hampshire\n");
write("<OPTION VALUE=NJ " + ((selectValue == "NJ") ? "SELECTED" : "")   + ">New Jersey\n");
write("<OPTION VALUE=NM " + ((selectValue == "NM") ? "SELECTED" : "")   + ">New Mexico\n");
write("<OPTION VALUE=NY " + ((selectValue == "NY") ? "SELECTED" : "")   + ">New York\n");
write("<OPTION VALUE=OH " + ((selectValue == "OH") ? "SELECTED" : "")   + ">Ohio\n");
write("<OPTION VALUE=OK " + ((selectValue == "OK") ? "SELECTED" : "")   + ">Oklahoma\n");
write("<OPTION VALUE=OR " + ((selectValue == "OR") ? "SELECTED" : "")   + ">Oregon\n");
write("<OPTION VALUE=PA " + ((selectValue == "PA") ? "SELECTED" : "")   + ">Pennsylvania\n");
write("<OPTION VALUE=RI " + ((selectValue == "RI") ? "SELECTED" : "")   + ">Rhode Island\n");
write("<OPTION VALUE=SC " + ((selectValue == "SC") ? "SELECTED" : "")   + ">South Carolina\n");

write("<OPTION VALUE=SD " + ((selectValue == "SD") ? "SELECTED" : "")   + ">South Dakota\n");
write("<OPTION VALUE=TN " + ((selectValue == "TN") ? "SELECTED" : "")   + ">Tennessee\n");
write("<OPTION VALUE=TX " + ((selectValue == "TX") ? "SELECTED" : "")   + ">Texas\n");
write("<OPTION VALUE=UT " + ((selectValue == "UT") ? "SELECTED" : "")   + ">Utah\n");
write("<OPTION VALUE=VT " + ((selectValue == "VT") ? "SELECTED" : "")   + ">Vermont\n");
write("<OPTION VALUE=VA " + ((selectValue == "VA") ? "SELECTED" : "")   + ">Virginia\n");
write("<OPTION VALUE=WA " + ((selectValue == "WA") ? "SELECTED" : "")   + ">Washington\n");
write("<OPTION VALUE=WV " + ((selectValue == "WV") ? "SELECTED" : "")   + ">West Virginia\n");
write("<OPTION VALUE=WI " + ((selectValue == "WI") ? "SELECTED" : "")   + ">Wisconsin\n");
write("<OPTION VALUE=WY " + ((selectValue == "WY") ? "SELECTED" : "")   + ">Wyoming\n");

write("<OPTION VALUE=DC " + ((selectValue == "DC") ? "SELECTED" : "")   + ">Washington, D.C.\n");

//Close the SELECT block
write("</SELECT>\n");


}  // END stateListFull()


// ========================================================

function countryList(listname, size, multiple, handlerText, selectValue ) {

selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (" " + handlerText + ">\n");

// Write out the OPTIONS array

write("<OPTION VALUE=\"\">pick a country\n");

write("<OPTION VALUE=US " + ((selectValue == "US") ? "SELECTED" : "")   + ">United States\n");

write("<OPTION VALUE=AUSTRALIA " + ((selectValue == "AUSTRALIA") ? "SELECTED" : "")   + ">Australia\n");
write("<OPTION VALUE=BELGIUM " + ((selectValue == "BELGIUM") ? "SELECTED" : "")   + ">Belgium & Luxemburg\n");
write("<OPTION VALUE=CANADA " + ((selectValue == "CANADA") ? "SELECTED" : "")   + ">Canada\n");
write("<OPTION VALUE=CZE " + ((selectValue == "CZE") ? "SELECTED" : "")   + ">Czech Republic\n");
write("<OPTION VALUE=FRANCE " + ((selectValue == "FRANCE") ? "SELECTED" : "")   + ">France\n");

write("<OPTION VALUE=GERMANY " + ((selectValue == "GERMANY") ? "SELECTED" : "")   + ">Germany\n");
write("<OPTION VALUE=HK " + ((selectValue == "HK") ? "SELECTED" : "")   + ">Hong Kong\n");
write("<OPTION VALUE=HUNGARY " + ((selectValue == "HUNGARY") ? "SELECTED" : "")   + ">Hungary\n");
write("<OPTION VALUE=ITALY " + ((selectValue == "ITALY") ? "SELECTED" : "")   + ">Italy\n");
write("<OPTION VALUE=JAPAN " + ((selectValue == "JAPAN") ? "SELECTED" : "")   + ">Japan\n");

write("<OPTION VALUE=MEXICO " + ((selectValue == "MEXICO") ? "SELECTED" : "")   + ">Mexico\n");
write("<OPTION VALUE=NETHERLANDS " + ((selectValue == "NETHERLANDS") ? "SELECTED" : "")   + ">Netherlands\n");
write("<OPTION VALUE=POLAND " + ((selectValue == "POLAND") ? "SELECTED" : "")   + ">Poland\n");
write("<OPTION VALUE=RUSSIA " + ((selectValue == "RUSSIA") ? "SELECTED" : "")   + ">Russia\n");

write("<OPTION VALUE=SLOVENIA " + ((selectValue == "SLOVENIA") ? "SELECTED" : "")   + ">Slovenija\n");
write("<OPTION VALUE=SPAIN " + ((selectValue == "SPAIN") ? "SELECTED" : "")   + ">Spain\n");
write("<OPTION VALUE=UK " + ((selectValue == "UK") ? "SELECTED" : "")   + ">United Kingdom\n");


// Close the SELECT block
write("</SELECT>\n");

}// END countryList()


// ===================================================
// ===================================================

function creditCardList( listname, size, multiple, handlerText, selectValue ) {

selectValue.toUpperCase();  // convert to upper case for purposes of comparison

// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (handlerText + ">\n");

// Write out the OPTIONS array

write("<OPTION VALUE=VISA " + ((selectValue == "VISA") ? "SELECTED" : "")   + ">VISA\n");
write("<OPTION VALUE=MC " + ((selectValue == "MC") ? "SELECTED" : "")   + ">MasterCard\n");
write("<OPTION VALUE=DISC " + ((selectValue == "DISC") ? "SELECTED" : "")   + ">Discover\n");
write("<OPTION VALUE=AMEX " + ((selectValue == "AMEX") ? "SELECTED" : "")   + ">American Express\n");

// Close the SELECT block
write("</SELECT>\n");

} // END creditCardList()

