import netscape.plugin.Plugin;
import AviObserver;

public class AviPlayer extends Plugin {

	// used to fire avi asynchronous events like OnStop or OnPositionChange.
	// AviObserver is an interface (see AviObserver.java)
	private AviObserver observer;

	public AviObserver getObserver() {
		return observer;
	}

	// the object interested in listening the avi must register here.
	// timeout defines the time that occurs beetwen two OnPositionChange events
	public boolean advise(AviObserver o, int timeout) {
		System.err.println("called advise "+o+" "+timeout);
		if (observer == null)
			observer = o;
		else
			return false;

		setTimeOut(timeout);
		return true;
	}

	//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
	// those are all native.
	// check AviPlayer.c/.h for stubs and prototypes information
	// check avijava.cpp for native implementation

	// set the timeout for the position checking timer
	public native void setTimeOut(int timeout);

	//\\//\\// WARNING - WARNING - WARNING 
	// avi methods
	// with MCI drivers, an instance of an AVI driver belongs to the thread
	// which created it. When an applet try to call one of the following
	// functions MCI fails to execute the command because the applet is in a 
	// different thread than the one where the AVI instance was created (which is
	// the main thread when it loads the plugin)
	// The isAsync argument is used to see wheather the function can be called
	// directly (isAsync = false) or a message needs to be posted in order
	// to execute the function.
	// This problem may happen every time, in some applet, you have thread-safe data 
	// that you try to access (directly or not) from within another thread.
	// I guess usually this doesn't happen since your data is in the java class
	// and so it's available from other applets, but when you have native functions
	// hiding data (the plugin is a very good example of this) this problem might occur.
	// I wish the MCI drivers were not so strict (and I wonder why they need to be)
	// NOTE:	in this example this is true only becouse of the MCI driver instance,
	//			any other data is accessible and maybe if we use VFW API this problem
	//			vanishes

	public native boolean play(boolean isAsync);
	public native boolean stop(boolean isAsync);
	public native boolean seek (boolean isAsync, int position);
	public native boolean rewind (boolean isAsync);
	public native boolean forward (boolean isAsync);
	public native boolean frameForward (boolean isAsync);
	public native boolean frameBack (boolean isAsync);
}

