//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
// avijava.cpp 
// 
//		This is the main file in the Java<->Plugin story.
//		In AviPlayer.java some native functions have been defined.
//		javah spits out .c and .h files to represent that class (AviPlayer)
//		Those files declare the prototypes for the native methods.
//		Here is the implementation for the native methods
//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.

// stubs from javah

#define IMPLEMENT_AviPlayer
#ifndef _AviPlayer_H_
#include "AVIPlayer.h"
#endif
#ifndef _AviObserver_H_
#include "AVIObserver.h"
#endif

#ifndef __PLGWND_H__
#include "plgwnd.h"
#endif
#ifndef __CAVI_H__
#include "cavi.h"
#endif

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
//
//	all those functions are very straightforward.
//	They all get a NPP instance to retrive a CPluginWindow object (main 
//	interface between navigator and plugin dll) from which they 
//	get the CAvi instance and call the method they are interested in
//	(see plgwnd.cpp/.h and cavi.cpp/.h)
//
extern "C" JRI_PUBLIC_API(void) 
native_AviPlayer_setTimeOut(JRIEnv* env, struct AviPlayer* self, jint timeout)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	// CAvi::SetFrequency(..)
	pPluginData->GetAviStream().SetFrequency(timeout);
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_play(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_PLAY, 0), 0);
		return TRUE;
	}
	else
		// CAvi::Play()
		return pPluginData->GetAviStream().Play();
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_stop(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_STOP, 0), 0);
		return TRUE;
	}
	else
		// CAvi::Stop()
		return pPluginData->GetAviStream().Stop();
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_seek(JRIEnv* env, struct AviPlayer* self, jbool isAsync, jint position)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_SEEK, 0), 0);
		return TRUE;
	}
	else
		// CAvi::Seek(..)
		return pPluginData->GetAviStream().Seek(position);
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_rewind(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_REWIND, 0), 0);
		return TRUE;
	}
	else
		// CAvi::Rewind()
		return pPluginData->GetAviStream().Rewind();
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_forward(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_FORWARD, 0), 0);
		return TRUE;
	}
	else
		// CAvi::Forward()
		return pPluginData->GetAviStream().Forward();
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_frameForward(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_FRAME_BACK, 0), 0);
		return TRUE;
	}
	else
		// CAvi::FrameForward()
		return pPluginData->GetAviStream().FrameForward();
}

extern "C" JRI_PUBLIC_API(jbool) 
native_AviPlayer_frameBack(JRIEnv* env, struct AviPlayer* self, jbool isAsync)
{
	NPP instance = (NPP)self->getPeer(env);
	CPluginWindow* pPluginData = (CPluginWindow*)instance->pdata;
	if (isAsync) {
		::PostMessage(*pPluginData, WM_COMMAND, MAKEWPARAM(ID_VIDEO_FRAME_FORWARD, 0), 0);
		return TRUE;
	}
	else
		// CAvi::FrameBack()
		return pPluginData->GetAviStream().FrameBack();
}


