//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
// cavi.h
//
//		This file contains some basic code to play and display AVI files
//		It implements a CAvi class which can be used to display video
//		for windows files.
//
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.

#ifndef __CAVI_H__
#define __CAVI_H__

#ifndef _INC_WINDOWS    
#include <windows.h>
#endif

// for java call back
#ifndef _NPAPI_H_
#include "npapi.h"
#endif

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
//
// CAvi 
//
//	A basic avi class. Pretty straightforward
//
class CAvi
{

	private:
		NPP		_pluginInstance;	// used to call back java (see OnStop() and OnPsitionChange()
		UINT	_mDeviceID;			// mci device ID, used to call into the mci driver
		HWND	_hMovieWnd;			// avi window handle

		BOOL	_bLoop;				// set the REPEAT flag on the play command
		BOOL	_bAutoStart;		// start plying on open
		BOOL	_bPlaying;			// playing status

		// timer information
		UINT	_uTimeOut;
		UINT	_uTimerID;

	private:
		static UINT	s_InstanceCount; // for setting the timer

	public:
		CAvi (BOOL autoStart, BOOL bLoop, NPP instance);
		~CAvi ();

		BOOL Open (HWND, LPCSTR);
		void Close (void);

		BOOL Play (void);
		BOOL Stop (void);
		BOOL Seek (ULONG);
		BOOL Rewind (void);
		BOOL Forward (void);
		BOOL FrameForward (void);
		BOOL FrameBack (void);

		DWORD GetLength (void);
		DWORD GetPosition (void);
		int GetWidth (void);
		int GetHeight (void);
		BOOL isPlaying() const { return _bPlaying;}

		BOOL Center (void);

		void Update(void);
		BOOL Realize (void);

		void SetFrequency(UINT uTimer);

		void OnStop();
		void OnPositionChange();
};


//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
//
// CRect 
//	
//	kind of stupid utility class
//
class CRect : public RECT {
	public:
		CRect() {left = 0; top = 0; right = 0; bottom = 0;}
		long Width() const {return right - left;}
		long Height() const {return bottom - top;}
		CRect& operator = (RECT rc) {left = rc.left, top = rc.top; 
									right = rc.right; left = rc.left;
									return *this;}
};

#endif